/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.gef.alignment.xpl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.internal.InternalImages;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;

public abstract class DefaultAlignmentAction
extends SelectionAction {
    public static final String ID_ALIGN_LEFT = "org.eclipse.gef.align_left";
    public static final String ID_ALIGN_RIGHT = "org.eclipse.gef.align_right";
    public static final String ID_ALIGN_TOP = "org.eclipse.gef.align_top";
    public static final String ID_ALIGN_BOTTOM = "org.eclipse.gef.align_bottom";
    public static final String ID_ALIGN_CENTER = "org.eclipse.gef.align_center";
    public static final String ID_ALIGN_MIDDLE = "org.eclipse.gef.align_middle";
    private List operationSet;
    private int alignment;

    public DefaultAlignmentAction(IWorkbenchPart editor, int align) {
        super(editor);
        this.alignment = align;
        this.init();
    }

    protected boolean calculateEnabled() {
        this.operationSet = null;
        Command cmd = this.createAlignmentCommand();
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    protected Rectangle calculateAlignmentRectangle(Request request) {
        List editparts = this.getOperationSet(request);
        if (editparts == null || editparts.isEmpty()) {
            return null;
        }
        GraphicalEditPart part = (GraphicalEditPart)editparts.get(editparts.size() - 1);
        Rectangle rect = part.getFigure().getBounds().getCopy();
        part.getFigure().translateToAbsolute((Translatable)rect);
        return rect;
    }

    private Command createAlignmentCommand() {
        AlignmentRequest request = new AlignmentRequest((Object)"align");
        request.setAlignmentRectangle(this.calculateAlignmentRectangle((Request)request));
        request.setAlignment(this.alignment);
        List editparts = this.getOperationSet((Request)request);
        if (editparts.size() < 2) {
            return null;
        }
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel(this.getText());
        int i = 0;
        while (i < editparts.size()) {
            EditPart editpart = (EditPart)editparts.get(i);
            command.add(editpart.getCommand((Request)request));
            ++i;
        }
        return command;
    }

    public void dispose() {
        this.operationSet = Collections.EMPTY_LIST;
        super.dispose();
    }

    public ImageDescriptor getHoverImageDescriptor() {
        return super.getHoverImageDescriptor();
    }

    protected List getOperationSet(Request request) {
        if (this.operationSet != null) {
            return this.operationSet;
        }
        List editparts = new ArrayList(this.getSelectedObjects());
        if (editparts.isEmpty() || !(editparts.get(0) instanceof GraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        editparts = ToolUtilities.getSelectionWithoutDependants(editparts);
        ToolUtilities.filterEditPartsUnderstanding(editparts, (Request)request);
        if (editparts.size() < 2) {
            return Collections.EMPTY_LIST;
        }
        EditPart parent = ((EditPart)editparts.get(0)).getParent();
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (part.getParent() != parent) {
                return Collections.EMPTY_LIST;
            }
            ++i;
        }
        return editparts;
    }

    protected void init() {
        super.init();
        switch (this.alignment) {
            case 1: {
                this.setId(ID_ALIGN_LEFT);
                this.setText(GEFMessages.AlignLeftAction_Label);
                this.setToolTipText(GEFMessages.AlignLeftAction_Tooltip);
                this.setHoverImageDescriptor(InternalImages.DESC_HORZ_ALIGN_LEFT);
                this.setImageDescriptor(InternalImages.DESC_HORZ_ALIGN_LEFT);
                this.setDisabledImageDescriptor(InternalImages.DESC_HORZ_ALIGN_LEFT_DIS);
                break;
            }
            case 4: {
                this.setId(ID_ALIGN_RIGHT);
                this.setText(GEFMessages.AlignRightAction_Label);
                this.setToolTipText(GEFMessages.AlignRightAction_Tooltip);
                this.setHoverImageDescriptor(InternalImages.DESC_HORZ_ALIGN_RIGHT);
                this.setImageDescriptor(InternalImages.DESC_HORZ_ALIGN_RIGHT);
                this.setDisabledImageDescriptor(InternalImages.DESC_HORZ_ALIGN_RIGHT_DIS);
                break;
            }
            case 8: {
                this.setId(ID_ALIGN_TOP);
                this.setText(GEFMessages.AlignTopAction_Label);
                this.setToolTipText(GEFMessages.AlignTopAction_Tooltip);
                this.setHoverImageDescriptor(InternalImages.DESC_VERT_ALIGN_TOP);
                this.setImageDescriptor(InternalImages.DESC_VERT_ALIGN_TOP);
                this.setDisabledImageDescriptor(InternalImages.DESC_VERT_ALIGN_TOP_DIS);
                break;
            }
            case 32: {
                this.setId(ID_ALIGN_BOTTOM);
                this.setText(GEFMessages.AlignBottomAction_Label);
                this.setToolTipText(GEFMessages.AlignBottomAction_Tooltip);
                this.setHoverImageDescriptor(InternalImages.DESC_VERT_ALIGN_BOTTOM);
                this.setImageDescriptor(InternalImages.DESC_VERT_ALIGN_BOTTOM);
                this.setDisabledImageDescriptor(InternalImages.DESC_VERT_ALIGN_BOTTOM_DIS);
                break;
            }
            case 2: {
                this.setId(ID_ALIGN_CENTER);
                this.setText(GEFMessages.AlignCenterAction_Label);
                this.setToolTipText(GEFMessages.AlignCenterAction_Tooltip);
                this.setHoverImageDescriptor(InternalImages.DESC_HORZ_ALIGN_CENTER);
                this.setImageDescriptor(InternalImages.DESC_HORZ_ALIGN_CENTER);
                this.setDisabledImageDescriptor(InternalImages.DESC_HORZ_ALIGN_CENTER_DIS);
                break;
            }
            case 16: {
                this.setId(ID_ALIGN_MIDDLE);
                this.setText(GEFMessages.AlignMiddleAction_Label);
                this.setToolTipText(GEFMessages.AlignMiddleAction_Tooltip);
                this.setHoverImageDescriptor(InternalImages.DESC_VERT_ALIGN_MIDDLE);
                this.setImageDescriptor(InternalImages.DESC_VERT_ALIGN_MIDDLE);
                this.setDisabledImageDescriptor(InternalImages.DESC_VERT_ALIGN_MIDDLE_DIS);
            }
        }
    }

    public void run() {
        this.operationSet = null;
        this.execute(this.createAlignmentCommand());
    }

    public abstract void update();
}

