/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.gef;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.text.FlowContext;
import org.eclipse.draw2d.text.SimpleTextLayout;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.stackview.CommandStackInspectorPage;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.gef.GEFGraphicalViewer;
import org.jboss.tools.common.gef.action.IDiagramSelectionProvider;
import org.jboss.tools.common.gef.outline.xpl.DiagramContentOutlinePage;
import org.jboss.tools.common.gef.xpl.GEFSplitter;

public class GEFEditor
extends GraphicalEditor
implements MouseListener,
MouseTrackListener,
KeyListener {
    protected static final int PALETTE_MIN_SIZE = 23;
    private static final QualifiedName PALETTE_SIZE_KEY = new QualifiedName("", "palette_size");
    private static final QualifiedName ZOOM_SIZE_KEY = new QualifiedName("", "zoom_size");
    protected int lastPaletteLayout = -1;
    protected PaletteViewer paletteViewer;
    protected IEditorInput input;
    protected static final int PALETTE_SIZE = 23;
    private KeyHandler sharedKeyHandler;
    private PaletteRoot root;
    protected boolean savePreviouslyNeeded = false;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part != GEFEditor.this) {
                return;
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    ScrollingGraphicalViewer viewer;
    protected DiagramContentOutlinePage outline;

    protected void setPaletteViewer(PaletteViewer paletteViewer) {
        this.paletteViewer = paletteViewer;
    }

    protected void initializeGraphicalViewer() {
    }

    public boolean isBordersPaint() {
        return true;
    }

    protected void createGraphicalViewer(Composite parent) {
        GEFGraphicalViewer viewer = new GEFGraphicalViewer(this);
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
    }

    protected PaletteViewer getPaletteViewer() {
        return this.paletteViewer;
    }

    public void createPartControl(Composite parent) {
        GEFSplitter splitter = new GEFSplitter(parent, 256, 23);
        this.createPaletteViewer(splitter);
        this.createGraphicalViewer(splitter);
        splitter.maintainSize(this.getPaletteViewer().getControl());
        splitter.setFixedSize(this.loadPaletteSize());
        splitter.addFixedSizeChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                int size = ((GEFSplitter)((Object)evt.getSource())).getFixedSize();
                GEFEditor.this.setPaletteLayout(GEFEditor.this.paletteViewer.getPaletteViewerPreferences(), size);
                GEFEditor.this.savePaletteSize(size);
            }
        });
        splitter.getChildren()[1].addMouseListener((MouseListener)this);
        splitter.getChildren()[1].addMouseTrackListener((MouseTrackListener)this);
    }

    protected void setPaletteLayout(PaletteViewerPreferences prefs, int size) {
        int paletteLayout;
        int n = paletteLayout = size > 23 ? 0 : 2;
        if (paletteLayout != this.lastPaletteLayout) {
            this.lastPaletteLayout = paletteLayout;
            prefs.setLayoutSetting(paletteLayout);
            FigureCanvas canvas = (FigureCanvas)this.paletteViewer.getControl();
            this.makeUnwrapPaletteItems(canvas.getContents());
        }
    }

    protected void makeUnwrapPaletteItems(IFigure figure) {
        if (figure instanceof TextFlow) {
            TextFlow textFlow = (TextFlow)figure;
            SimpleTextLayout layout = new SimpleTextLayout((TextFlow)figure);
            figure.setLayoutManager((LayoutManager)layout);
            textFlow.setFlowContext((FlowContext)textFlow.getParent().getLayoutManager());
        } else {
            List children = figure.getChildren();
            int i = 0;
            while (i < children.size()) {
                this.makeUnwrapPaletteItems((IFigure)children.get(i));
                ++i;
            }
        }
    }

    protected void createPaletteViewer(Composite parent) {
    }

    public GEFEditor(IEditorInput input) {
        this.input = input;
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    public GEFEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    protected void configurePaletteViewer() {
        PaletteViewer viewer = this.getPaletteViewer();
        PaletteContextMenuProvider provider = new PaletteContextMenuProvider(viewer);
        this.getPaletteViewer().setContextMenu((MenuManager)provider);
    }

    public ScrollingGraphicalViewer getScrollingGraphicalViewer() {
        return this.viewer;
    }

    protected void configureGraphicalViewer() {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public Control getControl() {
        return this.getPaletteViewer().getControl();
    }

    protected void createOutputStream(OutputStream os) throws IOException {
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
        this.partListener = null;
        if (this.outline != null) {
            this.outline.dispose();
            this.outline = null;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
    }

    public void doSaveAs() {
    }

    public Object getAdapter(Class type) {
        if (type == IDiagramSelectionProvider.class) {
            if (this.getScrollingGraphicalViewer() == null) {
                return null;
            }
            return new IDiagramSelectionProvider(){

                public ISelection getSelection() {
                    if (GEFEditor.this.getScrollingGraphicalViewer() == null) {
                        return null;
                    }
                    return GEFEditor.this.getScrollingGraphicalViewer().getSelection();
                }
            };
        }
        if (type == CommandStackInspectorPage.class) {
            return new CommandStackInspectorPage(this.getCommandStack());
        }
        if (type == IContentOutlinePage.class) {
            if (this.outline != null) {
                return this.outline;
            }
            this.outline = new DiagramContentOutlinePage((EditPartViewer)new TreeViewer());
            this.outline.setGraphicalViewer(this.getGraphicalViewer());
            this.outline.setSelectionSynchronizer(this.getSelectionSynchronizer());
            return this.outline;
        }
        if (type == ZoomManager.class && this.getGraphicalViewer() != null) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    protected int getInitialPaletteSize() {
        return 22;
    }

    protected void handlePaletteResized(int newSize) {
    }

    protected KeyHandler getCommonKeyHandler() {
        return this.sharedKeyHandler;
    }

    public ISelectionProvider getModelSelectionProvider() {
        return null;
    }

    protected PaletteRoot createPalette() {
        PaletteRoot palette = new PaletteRoot();
        palette.addAll(this.createCategories(palette));
        return palette;
    }

    protected PaletteContainer createControlGroup(PaletteRoot root) {
        return null;
    }

    protected List createCategories(PaletteRoot root) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(this.createControlGroup(root));
        return categories;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = this.createPalette();
        }
        return this.root;
    }

    public void gotoMarker(IMarker marker) {
    }

    protected void hookPaletteViewer() {
        this.getEditDomain().setPaletteViewer(this.paletteViewer);
        this.getPaletteViewer().getContextMenu().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.removeAll();
            }
        });
    }

    protected void initializePaletteViewer() {
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
        this.getPaletteViewer().addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)this.getPaletteViewer()));
        this.getPaletteViewer().getPaletteViewerPreferences().setLayoutSetting(0);
    }

    protected void createActions() {
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    protected boolean performSaveAs() {
        return false;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    protected void superSetInput(IEditorInput input) {
        super.setInput(input);
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
    }

    private IFile getFile() {
        return this.input instanceof IFileEditorInput ? ((IFileEditorInput)this.input).getFile() : null;
    }

    protected int loadPaletteSize() {
        IFile file = this.getFile();
        int size = 23;
        if (file == null || !file.isAccessible()) {
            return size;
        }
        try {
            String s = file.getPersistentProperty(PALETTE_SIZE_KEY);
            if (s != null) {
                size = Integer.parseInt(s);
            }
        }
        catch (CoreException e) {
            CommonPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (NumberFormatException e) {
            CommonPlugin.getPluginLog().logError((Throwable)e);
        }
        return size;
    }

    protected void savePaletteSize(int fixedSise) {
        IFile file = this.getFile();
        if (file == null || !file.isAccessible()) {
            return;
        }
        try {
            String s = "" + fixedSise;
            file.setPersistentProperty(PALETTE_SIZE_KEY, s);
        }
        catch (CoreException e) {
            CommonPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected double loadZoomSize() {
        IFile file = this.getFile();
        double size = 1.0;
        if (file == null || !file.isAccessible()) {
            return size;
        }
        try {
            String s = file.getPersistentProperty(ZOOM_SIZE_KEY);
            if (s != null && s.length() > 0) {
                size = Double.parseDouble(s);
            }
        }
        catch (CoreException e) {
            CommonPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (NumberFormatException e) {
            CommonPlugin.getPluginLog().logError((Throwable)e);
        }
        return size;
    }

    protected void saveZoomSize(double zoom) {
        IFile file = this.getFile();
        if (file == null || !file.isAccessible()) {
            return;
        }
        try {
            String s = "" + zoom;
            file.setPersistentProperty(ZOOM_SIZE_KEY, s);
        }
        catch (CoreException e) {
            CommonPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
    }
}

