/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.jboss.tools.common.ui.preferences.SeverityPreferencesMessages;

public abstract class SeverityConfigurationBlock
extends OptionsConfigurationBlock {
    protected static final String ERROR = "error";
    protected static final String WARNING = "warning";
    protected static final String IGNORE = "ignore";
    protected static final String ENABLED = "enabled";
    protected static final String DISABLED = "disabled";
    protected String[] errorWarningIgnore = new String[]{"error", "warning", "ignore"};
    protected String[] enableDisableValues = new String[]{"enabled", "disabled"};
    protected String[] errorWarningIgnoreLabels = new String[]{SeverityPreferencesMessages.VALIDATOR_CONFIGURATION_BLOCK_ERROR, SeverityPreferencesMessages.VALIDATOR_CONFIGURATION_BLOCK_WARNING, SeverityPreferencesMessages.VALIDATOR_CONFIGURATION_BLOCK_IGNORE};

    public SeverityConfigurationBlock(IStatusChangeListener context, IProject project, OptionsConfigurationBlock.Key[] allKeys, IWorkbenchPreferenceContainer container) {
        super(context, project, allKeys, container);
    }

    protected abstract String getCommonDescription();

    protected abstract SectionDescription[] getAllSections();

    protected abstract IDialogSettings getDialogSettings();

    protected Composite createStyleTabContent(Composite folder) {
        int nColumns = 3;
        ScrolledPageContent sc1 = new ScrolledPageContent(folder);
        Composite composite = sc1.getBody();
        GridLayout layout = new GridLayout(nColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 16448);
        description.setFont(description.getFont());
        description.setText(this.getCommonDescription());
        description.setLayoutData((Object)new GridData(1, 2, true, false, nColumns - 1, 1));
        int defaultIndent = 0;
        SectionDescription[] sections = this.getAllSections();
        int i = 0;
        while (i < sections.length) {
            SectionDescription section = sections[i];
            String label = section.label;
            ExpandableComposite excomposite = this.createStyleSection(composite, label, nColumns);
            Composite inner = new Composite((Composite)excomposite, 0);
            inner.setFont(composite.getFont());
            inner.setLayout((Layout)new GridLayout(nColumns, false));
            excomposite.setClient((Control)inner);
            int j = 0;
            while (j < section.options.length) {
                OptionDescription option = section.options[j];
                label = option.label;
                this.addComboBox(inner, label, option.key, this.errorWarningIgnore, this.errorWarningIgnoreLabels, defaultIndent);
                ++j;
            }
            ++i;
        }
        IDialogSettings section = this.getDialogSettings();
        this.restoreSectionExpansionStates(section);
        return sc1;
    }

    protected Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite mainComp = new Composite(parent, 0);
        mainComp.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        mainComp.setLayout((Layout)layout);
        Composite commonComposite = this.createStyleTabContent(mainComp);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertHeightInCharsToPixels((Control)parent, 20);
        commonComposite.setLayoutData((Object)gridData);
        this.validateSettings(null, null, null);
        return mainComp;
    }

    private int convertHeightInCharsToPixels(Control control, int chars) {
        Font font = control.getFont();
        GC gc = new GC((Drawable)font.getDevice());
        gc.setFont(font);
        FontMetrics fFontMetrics = gc.getFontMetrics();
        gc.dispose();
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fFontMetrics, (int)chars);
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = SeverityPreferencesMessages.ValidatorConfigurationBlock_needsbuild_title;
        String message = workspaceSettings ? SeverityPreferencesMessages.ValidatorConfigurationBlock_needsfullbuild_message : SeverityPreferencesMessages.ValidatorConfigurationBlock_needsprojectbuild_message;
        return new String[]{title, message};
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (!this.areSettingsEnabled()) {
            return;
        }
        this.fContext.statusChanged((IStatus)new StatusInfo());
    }

    public static class OptionDescription {
        public String label;
        public OptionsConfigurationBlock.Key key;

        public OptionDescription(String keyName, String label, String pluginId) {
            this.label = label;
            this.key = SeverityConfigurationBlock.getKey((String)pluginId, (String)keyName);
        }
    }

    public static class SectionDescription {
        public String label;
        public OptionDescription[] options;

        public SectionDescription(String label, String[][] optionLabelsAndKeys, String pluginId) {
            this.label = label;
            this.options = new OptionDescription[optionLabelsAndKeys.length];
            int i = 0;
            while (i < this.options.length) {
                this.options[i] = new OptionDescription(optionLabelsAndKeys[i][0], optionLabelsAndKeys[i][1], pluginId);
                ++i;
            }
        }
    }
}

