/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.ui.editor.model.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.action.XModelObjectActionList;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesElement;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesModel;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.TilesModel;

public class TilesElement
implements ITilesElement {
    protected String name = "";
    protected boolean visible = false;
    protected boolean hidden = false;
    protected boolean deleted = false;
    protected ITilesElement parent;
    protected ITilesModel tilesModel;
    protected String iconPath;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    protected XModelObject source;
    protected Hashtable map = new Hashtable();

    public TilesElement() {
    }

    public TilesElement(ITilesElement parent) {
        this.parent = parent;
        this.tilesModel = this.getTilesModel();
    }

    public TilesElement(ITilesElement parent, XModelObject source) {
        this.parent = parent;
        this.source = source;
        this.tilesModel = this.getTilesModel();
        ((TilesModel)this.tilesModel).putToMap(source.getPath(), this);
    }

    public void dispose() {
        this.vetoableChangeSupport = null;
        this.propertyChangeSupport = null;
        if (this.map != null) {
            this.map.clear();
        }
        this.map = null;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object obj) {
        this.source = (XModelObject)obj;
    }

    public String getText() {
        return "";
    }

    public ITilesElement getRoot() {
        ITilesElement current = this;
        while (current.getParentTilesElement() != null) {
            current = current.getParentTilesElement();
        }
        return current;
    }

    public ITilesModel getTilesModel() {
        ITilesElement model = this.getRoot();
        if (model instanceof ITilesElement) {
            return (ITilesModel)model;
        }
        return null;
    }

    public String getJSFElementPath() {
        ITilesElement current = this;
        String path = current.getName();
        while (current.getParentTilesElement() != null) {
            current = current.getParentTilesElement();
            path = String.valueOf(current.getName()) + "/" + path;
        }
        return path;
    }

    public void updateModelModifiedProperty(Object oldValue, Object newValue) {
        if (this.getTilesModel() != null && !oldValue.equals(newValue)) {
            this.getTilesModel().setModified(true);
        }
    }

    public void updateModelModifiedProperty(int oldValue, int newValue) {
        if (this.getTilesModel() != null) {
            if (newValue != oldValue) {
                // empty if block
            }
            this.getTilesModel().setModified(true);
        }
    }

    public void updateModelModifiedProperty(boolean oldValue, boolean newValue) {
        if (this.getTilesModel() != null) {
            if (newValue != oldValue) {
                // empty if block
            }
            this.getTilesModel().setModified(true);
        }
    }

    public ITilesElement getParentTilesElement() {
        return this.parent;
    }

    public void setParentTilesElement(ITilesElement element) {
        ITilesElement oldValue = this.parent;
        this.parent = element;
        this.tilesModel = this.getTilesModel();
        this.propertyChangeSupport.firePropertyChange("parent", oldValue, element);
        this.updateModelModifiedProperty(oldValue, element);
    }

    public String getName() {
        return this.source.getAttributeValue("name");
    }

    public String getTarget() {
        return this.source.getAttributeValue("extends");
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        this.vetoableChangeSupport.fireVetoableChange("name", oldValue, name);
        this.name = name;
    }

    public void setSourceProperty(String name, Object value) {
    }

    public Object getSourceProperty(String name) {
        return this.source.getAttributeValue(name);
    }

    public Object getSourceProperty(int index) {
        return null;
    }

    public int getSourcePropertyCounter() {
        return 0;
    }

    public String[] getSourcePropertyNames() {
        XModelObject mobject = this.source;
        XAttribute[] attributes = mobject.getModelEntity().getAttributes();
        String[] attributeNames = new String[attributes.length];
        int i = 0;
        while (i < attributeNames.length) {
            attributeNames[i] = attributes[i].getName();
            ++i;
        }
        return attributeNames;
    }

    public String[] getSourcePropertyDisplayNames() {
        XModelObject mobject = this.source;
        XAttribute[] attributes = mobject.getModelEntity().getAttributes();
        String[] attributeNames = new String[attributes.length];
        int i = 0;
        while (i < attributeNames.length) {
            attributeNames[i] = attributes[i].getName();
            ++i;
        }
        return attributeNames;
    }

    public void remove() {
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(propertyName, l);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(propertyName, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, l);
    }

    public Object clone() {
        TilesElement newElement = new TilesElement();
        newElement.source = this.source.copy();
        return newElement;
    }

    public Enumeration children() {
        return null;
    }

    public boolean isLeaf() {
        return true;
    }

    public void removeAllListeners() {
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public void structureChanged(Object eventData) {
    }

    public void nodeChanged(Object eventData) {
    }

    public void nodeAdded(Object eventData) {
    }

    public void nodeRemoved(Object eventData) {
    }

    public TilesModel.TilesHashtable getMap() {
        return ((TilesModel)this.getTilesModel()).getMap();
    }

    public void removeFromMap(Object key) {
        ((TilesModel)this.getTilesModel()).removeFromMap(key);
    }

    public ITilesElement getFromMap(Object key) {
        return ((TilesModel)this.getTilesModel()).getFromMap(key);
    }

    public Menu getPopupMenu(Control control, Object environment) {
        if (this.getSource() == null) {
            return null;
        }
        if (((XModelObject)this.getSource()).getModelEntity().getActionList().getActionItems().length != 0) {
            XModelObjectActionList l = new XModelObjectActionList(((XModelObject)this.getSource()).getModelEntity().getActionList(), (XModelObject)this.getSource(), null, environment);
            Menu menu = l.createMenu(control);
            return menu;
        }
        return null;
    }

    public Menu getPopupMenu(Control control) {
        return this.getPopupMenu(control, null);
    }

    public boolean isConfirmed() {
        return false;
    }
}

