/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.ui.editor.model.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jst.web.tiles.ui.editor.model.IDefinition;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ILink;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ILinkListener;
import org.jboss.tools.jst.web.tiles.ui.editor.model.ITilesElement;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.Definition;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.TilesElement;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.TilesModel;

public class Link
extends TilesElement
implements ILink {
    public static final String PATH_PROPERTY = "link shape";
    public static final String HIDDEN_PROPERTY = "hidden";
    List<ILinkListener> linkListeners = new Vector<ILinkListener>();
    XModelObject target = null;
    IDefinition toDefinition;

    public void dispose() {
        super.dispose();
        if (this.linkListeners != null) {
            this.linkListeners.clear();
        }
        this.linkListeners = null;
    }

    public Link(ITilesElement parent, XModelObject source) {
        super(parent, source);
    }

    public boolean setTarget() {
        this.target = this.getTilesModel().getHelper().getItemOutputTarget((XModelObject)this.getSource());
        if (this.target == null) {
            return false;
        }
        if (this.target.getPath() == null) {
            this.target = null;
            return false;
        }
        this.toDefinition = (IDefinition)this.tilesModel.findElement(this.target.getPath());
        if (this.toDefinition == null) {
            this.target = null;
            return false;
        }
        if (this.toDefinition != null) {
            ((Definition)this.toDefinition).addInputLink(this);
            ((Definition)this.getParentTilesElement()).fireLinkAdd(this);
        }
        return true;
    }

    public XModelObject getTargetModel() {
        return this.target;
    }

    public Menu getPopupMenu(Control control, Object environment) {
        if (this.getSource() == null) {
            return null;
        }
        return null;
    }

    public IDefinition getToDefinition() {
        return this.toDefinition;
    }

    public IDefinition getFromDefinition() {
        return (Definition)this.getParentTilesElement();
    }

    public void addLinkListener(ILinkListener l) {
        this.linkListeners.add(l);
    }

    public void removeLinkListener(ILinkListener l) {
        this.linkListeners.remove(l);
    }

    public void fireLinkChange() {
        ArrayList<ILinkListener> targets = new ArrayList<ILinkListener>();
        targets.addAll(this.linkListeners);
        int i = 0;
        while (i < targets.size()) {
            ILinkListener listener = (ILinkListener)targets.get(i);
            if (listener != null) {
                listener.linkChange(this);
            }
            ++i;
        }
    }

    public void fireLinkRemove() {
        ArrayList<ILinkListener> targets = new ArrayList<ILinkListener>();
        targets.addAll(this.linkListeners);
        int i = 0;
        while (i < targets.size()) {
            ILinkListener listener = (ILinkListener)targets.get(i);
            if (listener != null) {
                listener.linkRemove(this);
            }
            ++i;
        }
        ((TilesModel)this.getTilesModel()).fireLinkRemove(this);
    }

    public void nodeChanged(Object eventData) {
        XModelObject newTarget = this.getTilesModel().getHelper().getItemOutputTarget((XModelObject)this.getSource());
        if (this.target == null && newTarget != null) {
            ((Definition)this.getFromDefinition()).addLink(this);
        } else if (this.target != newTarget) {
            ((Definition)this.getFromDefinition()).removeLink(this);
            ((Definition)this.getFromDefinition()).addLink(this);
        } else if (newTarget == null) {
            this.target = null;
        }
    }
}

