/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.ui.editor;

import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.common.editor.AbstractSectionEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.jst.web.tiles.ui.TilesUIPlugin;
import org.jboss.tools.jst.web.tiles.ui.editor.TilesEditor;
import org.jboss.tools.jst.web.tiles.ui.editor.model.impl.TilesModel;
import org.xml.sax.SAXException;

public class TilesGuiEditor
extends AbstractSectionEditor {
    private TilesEditor gui = null;
    private IModelObjectEditorInput input;
    private boolean isInitialized = false;
    private XModelObject installedProcess = null;
    private ActionRegistry actionRegistry;
    private TilesModel model;

    protected boolean isWrongEntity(String entity) {
        return !entity.equals("FileTiles");
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof IModelObjectEditorInput) {
            this.input = (IModelObjectEditorInput)input;
        }
    }

    public TilesEditor getGUI() {
        return this.gui;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.gui == null ? null : this.gui.getModelSelectionProvider();
    }

    protected XModelObject getInstalledObject() {
        return this.installedProcess;
    }

    protected void updateGui() {
        if (this.object != this.installedProcess) {
            this.disposeGui();
        } else if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.installedProcess = this.object;
        this.guiControl.setVisible(this.object != null);
        if (this.object == null) {
            return;
        }
        try {
            this.gui = new TilesEditor((IFileEditorInput)this.input);
            this.model = new TilesModel(this.object);
            this.model.updateLinks();
            this.gui.setTilesModel(this.model);
            this.gui.init((IEditorSite)this.getSite(), (IEditorInput)this.input);
            this.gui.createPartControl(this.guiControl);
            this.control = this.guiControl.getChildren()[0];
            this.control.setLayoutData((Object)new GridData(1808));
            this.guiControl.layout();
            this.wrapper.update();
            this.wrapper.layout();
        }
        catch (SAXException ex) {
            TilesUIPlugin.getPluginLog().logError((Throwable)ex);
        }
        catch (PartInitException ex) {
            TilesUIPlugin.getPluginLog().logError((Throwable)ex);
        }
    }

    public TilesEditor getTilesDiagram() {
        return this.gui;
    }

    public void dispose() {
        if (this.model != null) {
            this.model.dispose();
        }
        this.model = null;
        super.dispose();
    }

    protected void disposeGui() {
        if (this.gui != null) {
            this.gui.dispose();
            this.gui = null;
            this.control.dispose();
            this.control = null;
        }
    }

    protected ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    protected void createActions() {
    }

    public Object getAdapter(Class adapter) {
        if ((adapter == ActionRegistry.class || adapter == ZoomManager.class) && this.gui != null) {
            return this.gui.getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }
}

