/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.tiles.ui.editor;

import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.editor.ObjectTextEditor;
import org.jboss.tools.common.gef.outline.xpl.DiagramContentOutlinePage;
import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.ui.texteditors.XMLTextEditorComponent;
import org.jboss.tools.jst.web.messages.xpl.WebUIMessages;
import org.jboss.tools.jst.web.tiles.model.TilesConfigFilteredTreeConstraint;
import org.jboss.tools.jst.web.tiles.ui.TilesUIPlugin;
import org.jboss.tools.jst.web.tiles.ui.editor.TilesGuiEditor;

public class TilesCompoundEditor
extends ObjectMultiPageEditor {
    protected TilesGuiEditor guiEditor;
    protected TilesConfigFilteredTreeConstraint constraint = new TilesConfigFilteredTreeConstraint();

    public TilesCompoundEditor() {
        this.outline.addFilter((XFilteredTreeConstraint)this.constraint);
    }

    protected Composite createPageContainer(Composite parent) {
        Composite composite = super.createPageContainer(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.jboss.tools.jst.web.tiles.ui.tiles_editor");
        return composite;
    }

    protected void doCreatePages() {
        if (this.isAppropriateNature()) {
            this.treeFormPage = this.createTreeFormPage();
            this.treeFormPage.setTitle(WebUIMessages.TILES_EDITOR);
            this.treeFormPage.addFilter((XFilteredTreeConstraint)this.constraint);
            this.treeFormPage.initialize((Object)this.object);
            this.addFormPage(this.treeFormPage);
            this.createGuiPage();
        }
        this.createTextPage();
        this.initEditors();
    }

    protected boolean isWrongEntity(String entity) {
        return !entity.equals("FileTiles");
    }

    public TilesGuiEditor getGuiEditor() {
        return this.guiEditor;
    }

    protected void createGuiPage() {
        this.guiEditor = new TilesGuiEditor();
        try {
            int index = this.addPage((IEditorPart)this.guiEditor, this.guiEditor.getEditorInput());
            this.setPageText(index, WebUIMessages.DIAGRAM);
            this.guiEditor.setInput((IEditorInput)this.input);
            this.selectionProvider.setHost(this.guiEditor.getSelectionProvider());
            this.guiEditor.addErrorSelectionListener(this.createErrorSelectionListener());
            this.selectionProvider.addHost("guiEditor", this.guiEditor.getSelectionProvider());
        }
        catch (PartInitException e) {
            TilesUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    protected ObjectTextEditor createTextEditor() {
        return new XMLTextEditorComponent();
    }

    public void dispose() {
        if (this.input != null) {
            this.selectionProvider.setHost(null);
            this.getSite().setSelectionProvider(null);
        }
        super.dispose();
        if (this.guiEditor != null) {
            this.guiEditor.dispose();
            this.guiEditor = null;
        }
    }

    protected void setNormalMode() {
        if (this.guiEditor != null && this.isAppropriateNature()) {
            this.guiEditor.setObject(this.getModelObject(), this.isErrorMode());
        }
        if (this.treeFormPage != null) {
            this.treeFormPage.initialize((Object)this.getModelObject());
            this.treeFormPage.setErrorMode(this.isErrorMode());
        }
        this.updateSelectionProvider();
    }

    protected void setErrorMode() {
        this.setNormalMode();
    }

    protected int getGuiPageIndex() {
        return 1;
    }

    public boolean isGuiEditorActive() {
        return this.getActivePage() == this.getGuiPageIndex();
    }

    protected void updateSelectionProvider() {
        int index;
        if (this.guiEditor != null) {
            this.selectionProvider.addHost("guiEditor", this.guiEditor.getSelectionProvider());
        }
        if (this.textEditor != null) {
            this.selectionProvider.addHost("textEditor", (ISelectionProvider)this.getTextSelectionProvider());
        }
        if ((index = this.getActivePage()) == this.getSourcePageIndex()) {
            if (this.textEditor != null) {
                this.selectionProvider.setHost((ISelectionProvider)this.getTextSelectionProvider());
            }
            return;
        }
        if (index != this.getGuiPageIndex() || this.guiEditor == null || this.guiEditor.getSelectionProvider() == null) {
            if (this.treeEditor != null) {
                this.selectionProvider.setHost(this.treeEditor.getSelectionProvider());
                this.treeEditor.fireEditorSelected();
            }
            if (this.treeFormPage != null) {
                this.selectionProvider.addHost("treeEditor", this.treeFormPage.getSelectionProvider(), true);
            }
        } else {
            ISelectionProvider p = this.guiEditor.getSelectionProvider();
            this.selectionProvider.setHost(p);
            if (p instanceof AbstractSelectionProvider) {
                ((AbstractSelectionProvider)p).fireSelectionChanged();
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IContentOutlinePage.class) {
            if (this.guiEditor == null || this.guiEditor.getGUI() == null) {
                return super.getAdapter(adapter);
            }
            Object o = this.guiEditor.getGUI().getAdapter(adapter);
            if (o instanceof DiagramContentOutlinePage) {
                DiagramContentOutlinePage g = (DiagramContentOutlinePage)o;
                g.setTreeOutline((ContentOutlinePage)this.outline);
            }
            return o;
        }
        if ((adapter == ActionRegistry.class || adapter == ZoomManager.class) && this.guiEditor != null && this.guiEditor.getGUI() != null) {
            return this.guiEditor.getGUI().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }
}

