/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;

public abstract class TextScanner
implements ITokenScanner {
    protected Reader reader;
    protected InputStream stream;
    protected int offset;
    protected int length;
    protected int position;
    private StringBuffer text = new StringBuffer();
    public static final IWhitespaceDetector WS_DETECTOR = new WhitespaceDetector();
    public static final IWordDetector NMTOKEN_DETECTOR = new NameTokenDetector();
    public static final IWordDetector DECIMAL_DETECTOR = new DecimalTokenDetector();
    public static final IWordDetector HEXADECIMAL_DETECTOR = new HexadecimalTokenDetector();

    public TextScanner(InputStream stream) {
        this.stream = stream;
        this.reader = new BufferedReader(new InputStreamReader(stream));
    }

    public TextScanner(Reader reader) {
        this.stream = null;
        this.reader = reader;
    }

    protected void finalize() throws Exception {
        if (this.text != null) {
            this.text.setLength(0);
        }
        this.text = null;
    }

    public void setRange(IDocument document, int offset, int length) {
    }

    public abstract IToken nextToken();

    public int getTokenOffset() {
        return this.offset;
    }

    public int getTokenLength() {
        return this.length;
    }

    protected IToken getToken(String type) {
        this.length = this.position - this.offset;
        if (this.length == 0) {
            return Token.EOF;
        }
        if (type == null) {
            return Token.UNDEFINED;
        }
        return new TextToken(type, this.text.substring(this.offset, this.offset + this.length));
    }

    protected int read() {
        int ch = -1;
        if (this.position < this.text.length()) {
            ch = this.text.charAt(this.position);
        } else {
            try {
                ch = this.reader.read();
            }
            catch (IOException iOException) {
                return -1;
            }
            if (ch == -1) {
                return -1;
            }
            this.text.append((char)ch);
        }
        ++this.position;
        return ch;
    }

    protected void unread() {
        if (this.position > 0) {
            --this.position;
        }
    }

    public int skipWhitespaceToken() {
        int ch = this.read();
        int readsCount = 0;
        while (ch != -1) {
            if (!WS_DETECTOR.isWhitespace((char)ch)) {
                this.unread();
                return readsCount;
            }
            ++readsCount;
            ch = this.read();
        }
        return readsCount;
    }

    protected void clearText() {
        if (this.text == null) {
            this.text = new StringBuffer();
        }
        this.text.setLength(0);
        this.offset = 0;
        this.position = 0;
        this.length = 0;
    }

    public static int calcTokenLength(char[] tokenChars, IDocument d, int start, int stop) {
        int count = 0;
        while (start + count < stop && count < tokenChars.length) {
            try {
                if (d.getChar(start + count) != tokenChars[count]) {
                    return 0;
                }
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
            ++count;
        }
        return count;
    }

    public static int calcTokenLength(IWordDetector wd, IDocument d, int start, int stop) {
        int count;
        block4: {
            count = 0;
            if (wd.isWordStart(d.getChar(start))) break block4;
            return 0;
        }
        try {
            ++count;
            while (start + count < stop && wd.isWordPart(d.getChar(start + count))) {
                ++count;
            }
        }
        catch (BadLocationException badLocationException) {}
        return count;
    }

    public static int calcLiteralTokenLength(IDocument d, int start, int stop, String escapeChars) {
        char pair;
        int count = 0;
        try {
            pair = d.getChar(start);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
        if (pair != '\"' && pair != '\'') {
            return 0;
        }
        ++count;
        while (start + count < stop) {
            try {
                char character = d.getChar(start + count);
                if (escapeChars != null && escapeChars.indexOf(character) != -1) {
                    ++count;
                } else if (character == pair) {
                    return count + 1;
                }
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
            ++count;
        }
        return 0;
    }

    public static String rtrim(String text) {
        try {
            Document d = new Document(text);
            int length = d.getLength();
            while (length > 0 && WS_DETECTOR.isWhitespace(d.getChar(length - 1))) {
                --length;
            }
            return d.get(0, length);
        }
        catch (BadLocationException badLocationException) {
            return text;
        }
    }

    static class DecimalTokenDetector
    implements IWordDetector {
        DecimalTokenDetector() {
        }

        public boolean isWordStart(char c) {
            return this.isWordPart(c);
        }

        public boolean isWordPart(char c) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return true;
                }
            }
            return false;
        }
    }

    static class HexadecimalTokenDetector
    extends DecimalTokenDetector {
        HexadecimalTokenDetector() {
        }

        public boolean isWordStart(char c) {
            return c == 'x';
        }

        public boolean isWordPart(char c) {
            if (super.isWordPart(c)) {
                return true;
            }
            switch (c) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    return true;
                }
            }
            return false;
        }
    }

    static class NameTokenDetector
    implements IWordDetector {
        NameTokenDetector() {
        }

        public boolean isWordPart(char ch) {
            if (Character.isUnicodeIdentifierPart(ch)) {
                return true;
            }
            switch (ch) {
                case '-': 
                case '.': 
                case ':': 
                case '_': {
                    return true;
                }
            }
            return false;
        }

        public boolean isWordStart(char ch) {
            return this.isWordPart(ch);
        }
    }

    public static class TextToken
    extends Token {
        private String text;

        public TextToken(String type, String text) {
            super((Object)type);
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String getType() {
            return (String)this.getData();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TextToken)) {
                return false;
            }
            TextToken tt = (TextToken)((Object)obj);
            if (this.getType() == null ? tt.getType() != null : !this.getType().equals(tt.getType())) {
                return false;
            }
            return !(this.getText() == null ? tt.getText() != null : !this.getText().equals(tt.getText()));
        }
    }

    static class WhitespaceDetector
    implements IWhitespaceDetector {
        WhitespaceDetector() {
        }

        public boolean isWhitespace(char ch) {
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }
    }
}

