/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IExclusiblePartitionerRecognition;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLElementAttributeValueHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer,
IExclusiblePartitionerRecognition {
    public static final String XML_ATTRIBUTE_VALUE_PARTITION = "org.jboss.tools.common.text.ext.xml.XML_ATTRIBUTE_VALUE";

    protected String getPartitionType() {
        return XML_ATTRIBUTE_VALUE_PARTITION;
    }

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, superRegion.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            int start = Utils.getValueStart(n);
            int end = Utils.getValueEnd(n);
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = this.getPartitionType();
            int length = end - start - (superRegion.getOffset() - start);
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, region.getOffset());
            if (!(n instanceof Attr)) {
                return false;
            }
            int start = Utils.getValueStart(n);
            int end = Utils.getValueEnd(n);
            return start >= 0 && start <= region.getOffset() && end >= region.getOffset();
            {
            }
        }
        finally {
            smw.dispose();
        }
    }

    public boolean excludes(String partitionType, IDocument document, IHyperlinkRegion superRegion) {
        return false;
    }

    public String getExclusionPartitionType() {
        return this.getPartitionType();
    }
}

