/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink.xml;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xml.IncludeHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Node;

public class IncludeHyperlink
extends AbstractHyperlink {
    private String hyperlinkText = "";

    protected IRegion doGetHyperlinkRegion(int offset) {
        Node n = IncludeHyperlinkPartitioner.getNode(this.getDocument(), offset);
        int start = Utils.getValueStart(n);
        if (start < 0) {
            return null;
        }
        int end = Utils.getValueEnd(n);
        Region region = new Region(start, end - start);
        return region;
    }

    protected void doHyperlink(IRegion region) {
        if (region == null) {
            return;
        }
        try {
            IDocument document = this.getDocument();
            this.hyperlinkText = document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException ex) {
            ExtensionsPlugin.getPluginLog().logError((Throwable)ex);
        }
        String fileName = Utils.trimQuotes(this.hyperlinkText);
        IFile file = this.getFileFromProject(fileName);
        if (file != null) {
            this.openFileInEditor(file);
        } else {
            this.openFileFailed();
        }
    }

    public String getHyperlinkText() {
        return this.hyperlinkText;
    }
}

