/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.text.ext.hyperlink;

import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.project.IPromptingProvider;
import org.jboss.tools.common.model.project.PromptingProviderFactory;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class XModelBasedHyperlink
extends AbstractHyperlink {
    protected IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        IFile documentFile = this.getFile();
        XModel xModel = XModelBasedHyperlink.getXModel(documentFile);
        if (xModel == null) {
            this.openFileFailed();
            return;
        }
        IPromptingProvider provider = PromptingProviderFactory.WEB;
        Properties p = this.getRequestProperties(region);
        p.put("file", documentFile);
        List list = provider.getList(xModel, this.getRequestMethod(), p.getProperty("prefix"), p);
        if (list != null && list.size() >= 1) {
            this.openFileInEditor((String)list.get(0));
            return;
        }
        String error = p.getProperty("error");
        if (error != null && error.length() > 0) {
            this.openFileFailed();
        }
    }

    protected abstract String getRequestMethod();

    protected abstract Properties getRequestProperties(IRegion var1);

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset(xmlDocument, offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart(n);
            int end = Utils.getValueEnd(n);
            if (start > offset || end < offset) {
                return null;
            }
            String text = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }
}

