/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JSPValidatorHyperlinkPartitioner
extends AbstractHyperlinkPartitioner {
    public static final String JSP_VALIDATOR_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSP_VALIDATOR";

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            HyperlinkRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Utils.findNodeForOffset((Node)xmlDocument, (int)superRegion.getOffset());
            IRegion r = JSPValidatorHyperlinkPartitioner.getRegion(document, superRegion.getOffset());
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = JSP_VALIDATOR_PARTITION;
            int length = r.getLength() - (superRegion.getOffset() - r.getOffset());
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, IHyperlinkRegion superRegion) {
        if (superRegion.getAxis() == null || superRegion.getAxis().length() == 0) {
            return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis((IDocument)document, (int)superRegion.getOffset())) + "/";
        }
        return superRegion.getAxis();
    }

    public static IRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > offset) {
                return null;
            }
            String attrText = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = 0;
            int bEnd = attrText.length() - 1;
            while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
                ++bStart;
            }
            while (bEnd > bStart && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log((Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }
}

