/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.jboss.tools.jst.text.ext.util.TaglibManagerWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPLoadBundleHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String JSP_LOADBUNDLE_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSP_LOADBUNDLE";

    protected String getPartitionType() {
        return JSP_LOADBUNDLE_PARTITION;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            HyperlinkRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Utils.findNodeForOffset((Node)xmlDocument, (int)superRegion.getOffset());
            if (!this.recognize(document, superRegion)) {
                return null;
            }
            IHyperlinkRegion r = JSPLoadBundleHyperlinkPartitioner.getRegion(document, superRegion.getOffset());
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = this.getPartitionType();
            int length = r.getLength() - (superRegion.getOffset() - r.getOffset());
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, IHyperlinkRegion superRegion) {
        if (superRegion.getAxis() == null || superRegion.getAxis().length() == 0) {
            return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis((IDocument)document, (int)superRegion.getOffset())) + "/";
        }
        return superRegion.getAxis();
    }

    public static IHyperlinkRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > offset) {
                return null;
            }
            String attrText = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = offset - start;
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '.') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            int bEnd = offset - start;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd)) && sb.charAt(bEnd) != '.') break;
                ++bEnd;
            }
            int propStart = bStart + start;
            int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength, null, null, null);
            return hyperlinkRegion;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Attr)) {
                return false;
            }
            IHyperlinkRegion r = JSPLoadBundleHyperlinkPartitioner.getRegion(document, region.getOffset());
            if (r == null) {
                return false;
            }
            Attr attr = (Attr)n;
            String attrName = attr.getNodeName();
            if (!"var".equals(attrName) && !"basename".equals(attrName)) {
                return false;
            }
            Element lbTag = attr.getOwnerElement();
            String name = lbTag.getTagName();
            int column = name.indexOf(":");
            if (column == -1) {
                return false;
            }
            String usedPrefix = name.substring(0, column);
            if (usedPrefix == null || usedPrefix.trim().length() == 0) {
                return false;
            }
            String[] prefixes = this.getLoadBundleTagPrefixes(document, region.getOffset());
            if (prefixes == null) {
                return true;
            }
            boolean prefixIsAbleToBeUsed = false;
            String[] stringArray = prefixes;
            int n2 = prefixes.length;
            int n3 = 0;
            while (n3 < n2) {
                String prefix = stringArray[n3];
                if (usedPrefix.equals(prefix)) {
                    prefixIsAbleToBeUsed = true;
                    break;
                }
                ++n3;
            }
            if (!prefixIsAbleToBeUsed) {
                return false;
            }
            Attr lbTagVar = lbTag.getAttributeNode("var");
            Attr lbTagBasename = lbTag.getAttributeNode("basename");
            if (lbTagVar == null || lbTagVar.getNodeValue() == null || lbTagVar.getNodeValue().trim().length() == 0) {
                return false;
            }
            return lbTagBasename != null && lbTagBasename.getNodeValue() != null && lbTagBasename.getNodeValue().trim().length() != 0;
            {
            }
        }
        finally {
            smw.dispose();
        }
    }

    protected String[] getLoadBundleTagPrefixes(IDocument document, int offset) {
        TaglibManagerWrapper tmw = new TaglibManagerWrapper();
        tmw.init(document, offset);
        if (!tmw.exists()) {
            return null;
        }
        return new String[]{tmw.getCorePrefix()};
    }
}

