/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.jboss.tools.jst.text.ext.util.TaglibManagerWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPForwardHyperlinkPartitioner
extends AbstractHyperlinkPartitioner {
    public static final String JSP_FORWARD_PARTITION = "org.jboss.tools.common.text.ext.jsp.JSP_FORWARD";

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            HyperlinkRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Utils.findNodeForOffset((Node)xmlDocument, (int)superRegion.getOffset());
            IHyperlinkRegion r = JSPForwardHyperlinkPartitioner.getRegion(document, superRegion.getOffset());
            if (r == null) {
                return null;
            }
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = JSP_FORWARD_PARTITION;
            int length = r.getLength() - (superRegion.getOffset() - r.getOffset());
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, IHyperlinkRegion superRegion) {
        if (superRegion.getAxis() == null || superRegion.getAxis().length() == 0) {
            return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis((IDocument)document, (int)superRegion.getOffset())) + "/";
        }
        return superRegion.getAxis();
    }

    public static IHyperlinkRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            HyperlinkRegion region;
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > offset) {
                return null;
            }
            String attrText = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = 0;
            int bEnd = attrText.length() - 1;
            while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
                ++bStart;
            }
            while (bEnd > bStart && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength, null, null, null);
            return hyperlinkRegion;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(document);
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            if (!(n instanceof Attr)) {
                return false;
            }
            IHyperlinkRegion r = JSPForwardHyperlinkPartitioner.getRegion(document, region.getOffset());
            if (r == null) {
                return false;
            }
            Attr attr = (Attr)n;
            String attrName = attr.getNodeName();
            if (!"var".equals(attrName) && !"basename".equals(attrName)) {
                return false;
            }
            Element lbTag = attr.getOwnerElement();
            String name = lbTag.getTagName();
            int column = name.indexOf(":");
            if (column == -1) {
                return false;
            }
            String prefix = name.substring(0, column);
            if (prefix == null || prefix.trim().length() == 0) {
                return false;
            }
            TaglibManagerWrapper tmw = new TaglibManagerWrapper();
            tmw.init(document, region.getOffset());
            if (!tmw.exists()) {
                return false;
            }
            if (!prefix.equals(tmw.getCorePrefix())) {
                return false;
            }
            Attr lbTagVar = lbTag.getAttributeNode("var");
            Attr lbTagBasename = lbTag.getAttributeNode("basename");
            if (lbTagVar == null || lbTagVar.getNodeValue() == null || lbTagVar.getNodeValue().trim().length() == 0) {
                return false;
            }
            return lbTagBasename != null && lbTagBasename.getNodeValue() != null && lbTagBasename.getNodeValue().trim().length() != 0;
            {
            }
        }
        finally {
            smw.dispose();
        }
    }
}

