/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jsf.text.ext.hyperlink.JSFLinkHyperlink;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class JSFContextParamLinkHyperlink
extends JSFLinkHyperlink {
    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > offset) {
                return null;
            }
            String attrText = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = offset - start;
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '\\' && sb.charAt(bStart) != '/' && sb.charAt(bStart) != ':' && sb.charAt(bStart) != '-' && sb.charAt(bStart) != '.' && sb.charAt(bStart) != '_' && sb.charAt(bStart) != '%' && sb.charAt(bStart) != '?' && sb.charAt(bStart) != '&' && sb.charAt(bStart) != '=') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            int bEnd = offset - start;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd)) && sb.charAt(bEnd) != '\\' && sb.charAt(bEnd) != '/' && sb.charAt(bEnd) != ':' && sb.charAt(bEnd) != '-' && sb.charAt(bEnd) != '.' && sb.charAt(bEnd) != '_' && sb.charAt(bEnd) != '%' && sb.charAt(bEnd) != '?' && sb.charAt(bEnd) != '&' && sb.charAt(bEnd) != '=') break;
                ++bEnd;
            }
            int propStart = bStart + start;
            int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }
}

