/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.StructuredSelectionHelper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ForIDHyperlink
extends AbstractHyperlink {
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        String forID = this.getForId(region);
        IRegion elementByID = this.findElementByID(forID);
        if (elementByID != null) {
            StructuredSelectionHelper.setSelectionAndRevealInActiveEditor((IRegion)elementByID);
        } else {
            this.openFileFailed();
        }
    }

    private IRegion findElementByID(String id) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            IDOMElement element = this.findElementByID(xmlDocument.getChildNodes(), id);
            if (element != null) {
                int offset = element.getStartOffset();
                int length = element.getStartStructuredDocumentRegion().getLength();
                Region region = new Region(offset, length);
                return region;
            }
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    private IDOMElement findElementByID(NodeList list, String id) {
        if (list == null || id == null) {
            return null;
        }
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i);
            if (n instanceof IDOMElement) {
                IDOMElement child;
                String val;
                IDOMElement element = (IDOMElement)n;
                Attr idAttr = element.getAttributeNode("id");
                if (idAttr != null && id.equals(val = this.trimQuotes(idAttr.getNodeValue()))) {
                    return element;
                }
                if (element.hasChildNodes() && (child = this.findElementByID(element.getChildNodes(), id)) != null) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    String getForId(IRegion region) {
        if (region == null) {
            return null;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return null;
        }
        try {
            return this.trimQuotes(document.get(region.getOffset(), region.getLength()));
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    private String trimQuotes(String word) {
        if (word == null) {
            return null;
        }
        String attrText = word;
        int bStart = 0;
        int bEnd = word.length() - 1;
        StringBuffer sb = new StringBuffer(attrText);
        while (bStart < bEnd && (sb.charAt(bStart) == '\'' || sb.charAt(bStart) == '\"' || Character.isWhitespace(sb.charAt(bStart)))) {
            ++bStart;
        }
        while (bEnd > bStart && (sb.charAt(bEnd) == '\'' || sb.charAt(bEnd) == '\"' || Character.isWhitespace(sb.charAt(bEnd)))) {
            --bEnd;
        }
        return sb.substring(bStart, ++bEnd);
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    private IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start > offset || end < offset) {
                return null;
            }
            String text = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            int bIdStart = offset;
            int bIdEnd = offset;
            while (bIdStart >= propStart) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bIdStart - start)) && sb.charAt(bIdStart - start) != ' ') {
                    ++bIdStart;
                    break;
                }
                if (bIdStart == 0) break;
                --bIdStart;
            }
            while (bIdEnd < propStart + propLength) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bIdEnd - start)) && sb.charAt(bIdEnd - start) != ' ') break;
                ++bIdEnd;
            }
            while (bIdStart < bIdEnd) {
                if (Character.isJavaIdentifierPart(sb.charAt(bIdStart - start))) break;
                ++bIdStart;
            }
            while (bIdEnd > bIdStart) {
                if (Character.isJavaIdentifierPart(sb.charAt(bIdEnd - 1 - start))) break;
                --bIdEnd;
            }
            int idStart = bIdStart;
            int idLength = bIdEnd - bIdStart;
            if (idStart > offset || idStart + idLength < offset) {
                return null;
            }
            Region region = new Region(idStart, idLength);
            return region;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String forId = this.getForId(this.fLastRegion);
        if (forId == null) {
            return MessageFormat.format(Messages.BrowseFor, Messages.Id);
        }
        return MessageFormat.format(Messages.BrowseForId, forId);
    }
}

