/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.JavaMemberELSegment;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jsf.text.ext.JSFTextExtMessages;
import org.jboss.tools.jsf.text.ext.hyperlink.JSPExprHyperlinkPartitioner;

public class ExpressionHyperlink
extends AbstractHyperlink {
    private JavaMemberELSegment javaSegment = null;

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.javaSegment = null;
        ELContext context = JSPExprHyperlinkPartitioner.getELContext(this.getDocument());
        JSPExprHyperlinkPartitioner.ExpressionStructure eStructure = JSPExprHyperlinkPartitioner.getExpression(context, offset);
        ELInvocationExpression invocationExpression = JSPExprHyperlinkPartitioner.getInvocationExpression(eStructure.reference, eStructure.expression, offset);
        if (invocationExpression != null) {
            ELResolver[] eLResolverArray = context.getElResolvers();
            int n = eLResolverArray.length;
            int n2 = 0;
            while (n2 < n) {
                ELResolver resolver = eLResolverArray[n2];
                ELResolution resolution = resolver.resolve(context, (ELExpression)invocationExpression, offset);
                if (resolution == null) {
                    return null;
                }
                ELSegment segment = resolution.findSegmentByOffset(offset - eStructure.reference.getStartPosition());
                if (segment != null && segment instanceof JavaMemberELSegment) {
                    this.javaSegment = (JavaMemberELSegment)segment;
                    if (this.javaSegment.getJavaElement() != null) {
                        Region region = new Region(eStructure.reference.getStartPosition() + segment.getSourceReference().getStartPosition(), segment.getSourceReference().getLength());
                        return region;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    protected void doHyperlink(IRegion region) {
        IEditorPart part = null;
        if (this.javaSegment != null && this.javaSegment.getJavaElement() != null) {
            try {
                part = JavaUI.openInEditor((IJavaElement)this.javaSegment.getJavaElement());
            }
            catch (JavaModelException ex) {
                JSFExtensionsPlugin.log((Exception)((Object)ex));
            }
            catch (PartInitException ex) {
                JSFExtensionsPlugin.log((Exception)((Object)ex));
            }
            if (part != null) {
                JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)this.javaSegment.getJavaElement());
            }
        }
        if (part == null) {
            this.openFileFailed();
        }
    }

    public String getHyperlinkText() {
        return JSFTextExtMessages.OpenJavaElement;
    }
}

