/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.text.ext.hyperlink.ClassHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jsf.model.FileFacesConfigImpl;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jsf.text.ext.JSFExtensionsPlugin;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BundleBasenameHyperlink
extends ClassHyperlink {
    private static final String FILESYSTEMS = "/FileSystems/";
    private static final String LIB = "/lib-";
    private static final String SEPARATOR = "/";
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        try {
            String fileName = this.getBundleBasename(region);
            XModelObject mo = this.getXModelObjectToOpen(fileName);
            if (mo != null) {
                FindObjectHelper.findModelObject((XModelObject)mo, (int)FindObjectHelper.IN_EDITOR_ONLY);
            } else {
                IFile fileToOpen = this.getFileToOpen(fileName, "properties");
                if (fileToOpen != null) {
                    IWorkbenchPage workbenchPage = JSFExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)fileToOpen, (boolean)true);
                } else {
                    super.doHyperlink(region);
                }
            }
        }
        catch (CoreException coreException) {
            this.openFileFailed();
        }
    }

    private String getBundleBasename(IRegion region) {
        if (region == null || this.getDocument() == null) {
            return null;
        }
        try {
            return this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    private XModelObject[] getBundles(XModelObject fcObject) {
        if (fcObject == null) {
            return null;
        }
        XModel fcObjectModel = fcObject.getModel();
        if (fcObjectModel == null) {
            return null;
        }
        JSFProjectsRoot jsfProjectsRoot = JSFProjectsTree.getProjectsRoot((XModel)fcObjectModel);
        if (jsfProjectsRoot == null) {
            return null;
        }
        XModelObject rbObjects = jsfProjectsRoot.getChildByPath("Resource Bundles");
        if (!(rbObjects instanceof WebProjectNode)) {
            return null;
        }
        ((WebProjectNode)rbObjects).invalidate();
        ArrayList<XModelObject> resourceBundles = new ArrayList<XModelObject>();
        XModelObject[] bundles = ((WebProjectNode)rbObjects).getTreeChildren();
        int i = 0;
        while (bundles != null && i < bundles.length) {
            String res = XModelObjectLoaderUtil.getResourcePath((XModelObject)bundles[i]);
            if (res != null) {
                resourceBundles.add(bundles[i]);
            }
            ++i;
        }
        return resourceBundles.size() == 0 ? null : resourceBundles.toArray(new XModelObject[0]);
    }

    private String[] getBundles() {
        XModelObject fcObject = EclipseResourceUtil.createObjectForResource((IResource)this.getFile());
        if (fcObject == null) {
            return null;
        }
        ArrayList<String> bundlesPaths = new ArrayList<String>();
        XModelObject[] bundles = this.getBundles(fcObject);
        int i = 0;
        while (bundles != null && i < bundles.length) {
            String res = XModelObjectLoaderUtil.getResourcePath((XModelObject)bundles[i]);
            if (res != null) {
                res = res.substring(1, res.length() - 11).replace('/', '.');
                bundlesPaths.add(res);
            }
            ++i;
        }
        return bundlesPaths.size() == 0 ? null : bundlesPaths.toArray(new String[0]);
    }

    private String[] getOrderedLocales() {
        XModelObject fcObject = EclipseResourceUtil.createObjectForResource((IResource)this.getFile());
        if (fcObject == null) {
            return null;
        }
        return this.getOrderedLocales(fcObject);
    }

    private String[] getOrderedLocales(XModelObject fcObject) {
        Locale defJavaLocale;
        String defLocale;
        if (fcObject == null) {
            return null;
        }
        HashSet<String> allLocales = new HashSet<String>();
        ArrayList<String> supportedLocales = new ArrayList<String>();
        ArrayList<String> langs = new ArrayList<String>();
        XModelObject lcObject = fcObject != null ? fcObject.getChildByPath("application/Locale Config") : null;
        String string = defLocale = lcObject != null ? lcObject.getAttributeValue("default-locale") : null;
        if (defLocale != null && defLocale.trim().length() > 0) {
            String locale = defLocale.trim().replace('-', '_');
            if (!allLocales.contains(locale)) {
                allLocales.add(locale);
                supportedLocales.add(locale);
            }
            if (locale.indexOf(95) != -1) {
                if (!allLocales.contains(locale = locale.replace('_', '-'))) {
                    allLocales.add(locale);
                    supportedLocales.add(locale);
                }
                if (!allLocales.contains(locale = locale.substring(0, locale.indexOf(45)))) {
                    allLocales.add(locale);
                    supportedLocales.add(locale);
                }
            }
        }
        if ((defJavaLocale = Locale.getDefault()) != null && defJavaLocale.getLanguage() != null && defJavaLocale.getLanguage().length() > 0) {
            String locale;
            if (defJavaLocale.getCountry() != null && defJavaLocale.getCountry().length() > 0) {
                locale = String.valueOf(defJavaLocale.getLanguage()) + '_' + defJavaLocale.getCountry();
                if (!allLocales.contains(locale)) {
                    allLocales.add(locale);
                    supportedLocales.add(locale);
                }
                if (!allLocales.contains(locale = String.valueOf(defJavaLocale.getLanguage()) + '-' + defJavaLocale.getCountry())) {
                    allLocales.add(locale);
                    supportedLocales.add(locale);
                }
            }
            if (!allLocales.contains(locale = defJavaLocale.getLanguage())) {
                allLocales.add(locale);
                langs.add(locale);
            }
        }
        XModelObject[] lcChildren = lcObject != null ? lcObject.getChildren() : null;
        int i = 0;
        while (lcChildren != null && i < lcChildren.length) {
            String supLocale = lcChildren[i].getAttributeValue("supported-locale");
            if (supLocale != null && supLocale.trim().length() > 0) {
                String locale = supLocale.trim().replace('-', '_');
                if (!allLocales.contains(locale)) {
                    allLocales.add(locale);
                    supportedLocales.add(locale);
                }
                if (locale.indexOf(95) != -1) {
                    if (!allLocales.contains(locale = locale.replace('_', '-'))) {
                        allLocales.add(locale);
                        supportedLocales.add(locale);
                    }
                    if (!allLocales.contains(locale = locale.substring(0, locale.indexOf(45)))) {
                        allLocales.add(locale);
                        langs.add(locale);
                    }
                }
            }
            ++i;
        }
        supportedLocales.addAll(langs);
        supportedLocales.add("");
        return supportedLocales.toArray(new String[0]);
    }

    private XModelObject getXModelObjectToOpen(String fileName) {
        String baseLocation = this.getBaseLocation();
        if (baseLocation == null) {
            return null;
        }
        int index = baseLocation.indexOf(FILESYSTEMS);
        if (index == -1) {
            return null;
        }
        String projectName = baseLocation.substring(1, index);
        String path = baseLocation.substring(index + 1);
        IProject project = null;
        try {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        catch (Throwable throwable) {
            return null;
        }
        IModelNature modelNature = EclipseResourceUtil.getModelNature((IProject)project);
        if (modelNature == null || modelNature.getModel() == null) {
            return null;
        }
        XModelObject xmo = modelNature.getModel().getByPath(path);
        if (xmo instanceof FileFacesConfigImpl) {
            XModelObject fcObject = xmo;
            String[] orderedLocales = this.getOrderedLocales(fcObject);
            XModelObject[] bundles = this.getBundles(fcObject);
            int l = 0;
            while (orderedLocales != null && l < orderedLocales.length) {
                String name = String.valueOf(fileName) + (orderedLocales[l].length() == 0 ? "" : "_" + orderedLocales[l]);
                int i = 0;
                while (bundles != null && i < bundles.length) {
                    String bundleName = XModelObjectLoaderUtil.getResourcePath((XModelObject)bundles[i]);
                    if (bundleName.equals(name)) {
                        return bundles[i];
                    }
                    ++i;
                }
                ++l;
            }
        }
        return null;
    }

    private IFile getFileToOpen(String fileName, String fileExt) {
        if (fileName == null) {
            return null;
        }
        String[] orderedLocales = this.getOrderedLocales();
        String[] bundles = this.getBundles();
        int l = 0;
        while (orderedLocales != null && l < orderedLocales.length) {
            String name = String.valueOf(fileName) + (orderedLocales[l].length() == 0 ? "" : "_" + orderedLocales[l]);
            int i = 0;
            while (bundles != null && i < bundles.length) {
                IFile file;
                if (bundles[i].equals(name) && (file = this.findFile(String.valueOf(name.replace('.', '/')) + (fileExt != null ? "." + fileExt : ""))) != null) {
                    return file;
                }
                ++i;
            }
            ++l;
        }
        return null;
    }

    private IFile findFile(String name) {
        IProject project;
        block7: {
            block6: {
                IFile documentFile = this.getFile();
                project = documentFile.getProject();
                if (project != null && project.isOpen()) break block6;
                return null;
            }
            if (project.hasNature("org.eclipse.jdt.core.javanature")) break block7;
            return null;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IFile file;
                if (es[i].getEntryKind() == 3 && (file = project.getFile(es[i].getPath().removeFirstSegments(1) + SEPARATOR + name)) != null && file.exists()) {
                    return file;
                }
                ++i;
            }
            return null;
        }
        catch (CoreException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    private IFile getFileToOpenOld(String fileName, String fileExt) {
        String name;
        IProject project;
        block7: {
            block6: {
                IFile documentFile = this.getFile();
                project = documentFile.getProject();
                name = String.valueOf(fileName.replace('.', '/')) + (fileExt != null ? "." + fileExt : "");
                if (project != null && project.isOpen()) break block6;
                return null;
            }
            if (project.hasNature("org.eclipse.jdt.core.javanature")) break block7;
            return null;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IFile file;
                if (es[i].getEntryKind() == 3 && (file = project.getFile(es[i].getPath().removeFirstSegments(1) + SEPARATOR + name)) != null && file.exists()) {
                    return file;
                }
                ++i;
            }
            return null;
        }
        catch (CoreException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    public IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        smw.init(this.getDocument());
        try {
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start > offset || end < offset) {
                return null;
            }
            String text = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(text);
            int bStart = 0;
            int bEnd = text.length() - 1;
            while (bStart < bEnd && (Character.isWhitespace(sb.charAt(bStart)) || sb.charAt(bStart) == '\"' || sb.charAt(bStart) == '\"')) {
                ++bStart;
            }
            while (bEnd > bStart && (Character.isWhitespace(sb.charAt(bEnd)) || sb.charAt(bEnd) == '\"' || sb.charAt(bEnd) == '\"')) {
                --bEnd;
            }
            int propStart = bStart + start;
            int propLength = ++bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException x) {
            JSFExtensionsPlugin.log("", (Exception)((Object)x));
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String baseName = this.getBundleBasename(this.fLastRegion);
        if (baseName == null) {
            return MessageFormat.format(Messages.OpenA, Messages.Bundle);
        }
        return MessageFormat.format(Messages.OpenBundle, baseName);
    }
}

