/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VMessageFormat;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.VRuleSet;
import org.jboss.tools.common.verification.vrules.plugin.VerificationPlugin;

public class VRuleSetImpl
implements VRuleSet {
    protected String description;
    protected String name;
    VRuleSet parentRuleSet;
    protected VRule[] rules;
    protected VRuleSet[] ruleSets;
    protected String url;
    protected String vendor;
    protected String version;
    protected boolean enabled;
    protected boolean defaultEnabled = true;
    protected ResourceBundle bundle;
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected Object managerKey;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public boolean isEnabled() {
        if (this.parentRuleSet != null && !this.parentRuleSet.isEnabled()) {
            return false;
        }
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.enabled;
        this.enabled = enabled;
        this.propertyChangeSupport.firePropertyChange("enabled", oldEnabled, enabled);
    }

    public void setDefaultEnabled(boolean b) {
        this.defaultEnabled = b;
    }

    public boolean isDefaultEnabled() {
        return this.defaultEnabled;
    }

    public VRuleSet getParentRuleSet() {
        return this.parentRuleSet;
    }

    public void setParentRuleSet(VRuleSet parentRuleSet) {
        this.parentRuleSet = parentRuleSet;
    }

    public VRule[] getRules() {
        return this.rules;
    }

    public void setRules(VRule[] rules) {
        this.rules = rules;
    }

    public VRuleSet[] getRuleSets() {
        return this.ruleSets;
    }

    public void setRuleSets(VRuleSet[] ruleSets) {
        this.ruleSets = ruleSets;
    }

    public VMessageFormat getMessageFormat(String id) {
        if (this.bundle == null) {
            return null;
        }
        String pattern = null;
        try {
            pattern = this.bundle.getString("message." + id);
        }
        catch (MissingResourceException missingResourceException) {
            VerificationPlugin.getPluginLog().logError("Cannot find message-id " + id);
            pattern = "";
        }
        if (pattern == null) {
            return null;
        }
        VMessageFormat format = new VMessageFormat(pattern);
        format.setParent(VHelper.getManager().getMessageFormat());
        return format;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setManagerKey(Object key) {
        this.managerKey = key;
    }
}

