/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.verification.vrules.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.event.XActionAgent;
import org.jboss.tools.common.model.event.XActionAgentListener;
import org.jboss.tools.common.verification.vrules.VAction;
import org.jboss.tools.common.verification.vrules.VEntity;
import org.jboss.tools.common.verification.vrules.VHelper;
import org.jboss.tools.common.verification.vrules.VObject;
import org.jboss.tools.common.verification.vrules.VResult;
import org.jboss.tools.common.verification.vrules.VRule;
import org.jboss.tools.common.verification.vrules.impl.VRuleImpl;

public abstract class VerifyHandler
extends AbstractHandler
implements XActionAgent {
    protected void check(Map entities, VObject vobject, XModel model) {
        VEntity entity = vobject.getEntity();
        List rules = (List)entities.get(entity.getName());
        if (rules != null) {
            int i = 0;
            while (i < rules.size()) {
                VRule rule = (VRule)rules.get(i);
                VAction vaction = rule.getAction();
                VResult[] results = vaction.check(vobject);
                this.mergeResults(model, rule, vobject, results);
                ++i;
            }
        }
        Iterator itr = entities.keySet().iterator();
        boolean found = false;
        while (itr.hasNext()) {
            if (!entity.isDescendant((String)itr.next())) continue;
            found = true;
            break;
        }
        if (found) {
            VObject[] c = vobject.getChildren();
            int i = 0;
            while (i < c.length) {
                this.check(entities, c[i], model);
                ++i;
            }
        }
    }

    protected void mergeResults(XModel model, VRule rule, VObject source, VResult[] results) {
        int sign = VHelper.getManager().getMinSignificance();
        VResult[] c = rule.getResults();
        ArrayList<VResult> list = new ArrayList<VResult>();
        int i = 0;
        while (i < c.length) {
            if (!c[i].getSourceObject().equals(source)) {
                list.add(c[i]);
            }
            ++i;
        }
        if (results == null || results.length == 0) {
            model.getOut().println(String.valueOf(rule.getName()) + ": OK: " + source);
        } else {
            i = 0;
            while (i < results.length) {
                if (results[i].getSignificance() >= sign) {
                    list.add(results[i]);
                    model.getOut().println(String.valueOf(rule.getName()) + ": " + results[i].getMessage());
                }
                ++i;
            }
        }
        ((VRuleImpl)rule).setResults(list.toArray(new VResult[list.size()]));
    }

    public void setListener(XActionAgentListener listener) {
    }

    public void stopAction() {
    }
}

