/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.el.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.model.project.ProjectHome;
import org.jboss.tools.jsf.el.refactoring.ELProjectSetExtension;
import org.jboss.tools.jsf.el.refactoring.ProjectsSet;
import org.jboss.tools.jsf.el.refactoring.RefactorSearcher;
import org.jboss.tools.jsf.ui.JsfUIMessages;

public class RenameMethodParticipant
extends RenameParticipant {
    private IJavaElement element;
    private String oldName;
    private String newName;
    private SeamRenameMethodSearcher searcher;
    private RefactoringStatus status;
    private CompositeChange rootChange;
    private TextFileChange lastChange;
    private ArrayList<String> keys = new ArrayList();
    private static boolean added = false;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        IMethod method;
        if (this.searcher == null) {
            return this.status;
        }
        if (this.element instanceof IMethod && (method = (IMethod)this.element) != null && !added) {
            if (SeamRenameMethodSearcher.isGetter((IMethod)method)) {
                this.status.addWarning(JsfUIMessages.RENAME_METHOD_PARTICIPANT_GETTER_WARNING);
            } else if (SeamRenameMethodSearcher.isSetter((IMethod)method)) {
                this.status.addWarning(JsfUIMessages.RENAME_METHOD_PARTICIPANT_SETTER_WARNING);
            }
            added = true;
        }
        this.searcher.findELReferences();
        return this.status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return this.rootChange;
    }

    public String getName() {
        return this.oldName;
    }

    protected boolean initialize(Object element) {
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            this.status = new RefactoringStatus();
            this.rootChange = new CompositeChange(JsfUIMessages.RENAME_METHOD_PARTICIPANT_UPDATE_METHOD_REFERENCES);
            this.element = method;
            this.oldName = method.getElementName();
            this.newName = RefactorSearcher.getPropertyName((IMethod)method, (String)this.getArguments().getNewName());
            this.searcher = new SeamRenameMethodSearcher((IFile)method.getResource(), this.oldName);
            added = false;
            return true;
        }
        return false;
    }

    public boolean initialize(Object element, String newName) {
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            this.status = new RefactoringStatus();
            this.rootChange = new CompositeChange(JsfUIMessages.RENAME_METHOD_PARTICIPANT_UPDATE_METHOD_REFERENCES);
            this.element = method;
            this.oldName = method.getElementName();
            this.newName = newName;
            this.searcher = new SeamRenameMethodSearcher((IFile)method.getResource(), this.oldName);
            added = false;
            return true;
        }
        return false;
    }

    protected TextFileChange getChange(IFile file) {
        if (this.lastChange != null && this.lastChange.getFile().equals((Object)file)) {
            return this.lastChange;
        }
        int i = 0;
        while (i < this.rootChange.getChildren().length) {
            TextFileChange change = (TextFileChange)this.rootChange.getChildren()[i];
            if (change.getFile().equals((Object)file)) {
                this.lastChange = change;
                return this.lastChange;
            }
            ++i;
        }
        this.lastChange = new TextFileChange(file.getName(), file);
        MultiTextEdit root = new MultiTextEdit();
        this.lastChange.setEdit((TextEdit)root);
        this.rootChange.add((Change)this.lastChange);
        return this.lastChange;
    }

    private void change(IFile file, int offset, int length, String text) {
        String key = String.valueOf(file.getFullPath().toString()) + " " + offset;
        if (!this.keys.contains(key)) {
            TextFileChange change = this.getChange(file);
            ReplaceEdit edit = new ReplaceEdit(offset, length, text);
            change.addEdit((TextEdit)edit);
            this.keys.add(key);
        }
    }

    class SeamRenameMethodSearcher
    extends RefactorSearcher {
        ProjectsSet projectSet;

        public SeamRenameMethodSearcher(IFile file, String name) {
            super(file, name, RenameMethodParticipant.this.element);
            this.projectSet = null;
            ELProjectSetExtension[] extensions = ELProjectSetExtension.getInstances();
            if (extensions.length > 0) {
                this.projectSet = extensions[0].getProjectSet();
                if (this.projectSet != null) {
                    this.projectSet.init(file.getProject());
                }
            }
        }

        protected boolean isFileCorrect(IFile file) {
            if (!file.isSynchronized(0)) {
                RenameMethodParticipant.this.status.addFatalError(Messages.format((String)JsfUIMessages.RENAME_METHOD_PARTICIPANT_OUT_OF_SYNC_FILE, (Object)file.getFullPath().toString()));
                return false;
            }
            if (file.isPhantom()) {
                RenameMethodParticipant.this.status.addFatalError(Messages.format((String)JsfUIMessages.RENAME_METHOD_PARTICIPANT_ERROR_PHANTOM_FILE, (Object)file.getFullPath().toString()));
                return false;
            }
            if (file.isReadOnly()) {
                RenameMethodParticipant.this.status.addFatalError(Messages.format((String)JsfUIMessages.RENAME_METHOD_PARTICIPANT_ERROR_READ_ONLY_FILE, (Object)file.getFullPath().toString()));
                return false;
            }
            return true;
        }

        protected void match(IFile file, int offset, int length) {
            RenameMethodParticipant.this.change(file, offset, length, RenameMethodParticipant.this.newName);
        }

        protected IProject[] getProjects() {
            if (this.projectSet != null) {
                return this.projectSet.getLinkedProjects();
            }
            return new IProject[]{this.baseFile.getProject()};
        }

        protected IContainer getViewFolder(IProject project) {
            if (this.projectSet != null) {
                return this.projectSet.getViewFolder(project);
            }
            IPath path = ProjectHome.getFirstWebContentPath((IProject)this.baseFile.getProject());
            if (path != null) {
                return project.getFolder(path.removeFirstSegments(1));
            }
            return null;
        }
    }
}

