/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.model.impl;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.geometry.Rectangle;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.IJSFElement;
import org.jboss.tools.jsf.ui.editor.model.IJSFElementList;
import org.jboss.tools.jsf.ui.editor.model.IJSFElementListListener;
import org.jboss.tools.jsf.ui.editor.model.ILink;
import org.jboss.tools.jsf.ui.editor.model.IPage;
import org.jboss.tools.jsf.ui.editor.model.IPageListener;
import org.jboss.tools.jsf.ui.editor.model.impl.Group;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFElement;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFElementList;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFModel;
import org.jboss.tools.jsf.ui.editor.model.impl.Link;

public class Page
extends JSFElement
implements IPage,
IJSFElementListListener {
    public LinkList linkList;
    Rectangle rect = new Rectangle(0, 0, 10, 10);
    public List<IPageListener> pageListeners = new Vector<IPageListener>();
    IJSFElementList partList = new JSFElementList();
    String name;
    String target;
    boolean relink = false;

    public IJSFElementList getLinkList() {
        return this.linkList;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.rect = new Rectangle(x, y, width, height);
    }

    public Rectangle getBounds() {
        return this.rect;
    }

    public Page(IJSFElement parent, XModelObject source) {
        super(parent, source);
        this.linkList = new LinkList(source);
        this.linkList.addJSFElementListListener(this);
        this.target = source.getAttributeValue("target");
        this.initLink();
        this.name = this.getName();
    }

    public void dispose() {
        super.dispose();
        if (this.pageListeners != null) {
            this.pageListeners.clear();
        }
        this.pageListeners = null;
    }

    public XModelObject getTargetModel() {
        XModelObject target = this.jsfModel.getHelper().getItemOutputTarget(this.source);
        return target;
    }

    public boolean isHidden() {
        String hidden;
        if (this.source == null) {
            this.source = (XModelObject)this.parent.getSource();
        }
        return "yes".equals(hidden = this.source.getAttributeValue("hidden"));
    }

    public String getTargetString() {
        return this.target;
    }

    public void initLink() {
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDelete() {
        return true;
    }

    public String getText() {
        return "\t\t\t\t<MSG MESSAGE=\"" + this.getName() + "\"/>";
    }

    public void addPageListener(IPageListener listener) {
        this.pageListeners.add(listener);
    }

    public void removePageListener(IPageListener listener) {
        this.pageListeners.remove(listener);
    }

    void firePageRemoved() {
        ArrayList<IPageListener> listeners = new ArrayList<IPageListener>();
        listeners.addAll(this.pageListeners);
        int i = 0;
        while (i < listeners.size()) {
            IPageListener listener = (IPageListener)listeners.get(i);
            if (listener != null) {
                listener.pageRemoved(this);
            }
            ++i;
        }
    }

    public void removeLink(IPage message) {
    }

    public void rename(String newName) {
    }

    public IGroup getGroup() {
        return (IGroup)this.getParentJSFElement();
    }

    public IJSFElementList getPartList() {
        return this.partList;
    }

    public boolean isLinkAllowed() {
        return true;
    }

    public Enumeration children() {
        return null;
    }

    public boolean isLeaf() {
        return false;
    }

    public void remove() {
        int i = this.getLinkList().size() - 1;
        while (i >= 0) {
            ILink link = (ILink)this.getLinkList().get(i);
            this.linkList.removeLink(link);
            --i;
        }
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean hasErrors() {
        return this.getJSFModel().getHelper().hasErrors((XModelObject)this.getSource());
    }

    public void nodeChanged(Object eventData) {
        if (!this.name.equals(this.getName())) {
            this.propertyChangeSupport.firePropertyChange("name", this.name, this.getName());
            this.name = this.getName();
        }
    }

    public void fireLinkAdd(ILink link) {
        ArrayList<IPageListener> listeners = new ArrayList<IPageListener>();
        listeners.addAll(this.pageListeners);
        int i = 0;
        while (i < listeners.size()) {
            IPageListener listener = (IPageListener)listeners.get(i);
            if (listener != null && listener.isPageListenerEnable()) {
                ((IPageListener)listeners.get(i)).linkAdd(this, link);
            }
            ++i;
        }
        ((Group)this.getParentJSFElement()).fireLinkAdd(this, link);
    }

    public void fireLinkRemove(ILink link, int index) {
        ArrayList<IPageListener> listeners = new ArrayList<IPageListener>();
        listeners.addAll(this.pageListeners);
        int i = 0;
        while (i < listeners.size()) {
            IPageListener listener = (IPageListener)listeners.get(i);
            if (listener != null && listener.isPageListenerEnable()) {
                ((IPageListener)listeners.get(i)).linkRemove(this, link);
            }
            ++i;
        }
        ((Group)this.getParentJSFElement()).fireLinkRemove(this, link, index);
    }

    public void firePageChange(IPage message, PropertyChangeEvent evt) {
    }

    public boolean isRelink() {
        return this.relink;
    }

    public boolean isElementListListenerEnable() {
        return true;
    }

    public void setElementListListenerEnable(boolean set) {
    }

    public void listElementMove(IJSFElementList list, IJSFElement element, int newIndex, int oldIndex) {
    }

    public void listElementAdd(IJSFElementList list, IJSFElement element, int index) {
    }

    public void listElementRemove(IJSFElementList list, IJSFElement element, int index) {
    }

    public void listElementChange(IJSFElementList list, IJSFElement element, int index, PropertyChangeEvent event) {
    }

    public void nodeAdded(Object eventData) {
        this.linkList.nodeAdded(eventData);
    }

    public void nodeRemoved(Object eventData) {
        this.linkList.nodeRemoved(eventData);
    }

    public class LinkList
    extends JSFElementList {
        public LinkList(XModelObject listSource) {
            super(Page.this);
            XModelObject[] links = listSource.getChildren();
            int i = 0;
            while (i < links.length) {
                Link newLink = new Link(Page.this, links[i]);
                this.add(newLink);
                ((Group)Page.this.getParentJSFElement()).addOutputLink(newLink);
                ++i;
            }
        }

        public void structureChanged(Object eventData) {
            XModelObject o;
            IJSFElement pe;
            XModelObject listSource = (XModelObject)Page.this.getSource();
            XModelObject[] links = listSource.getChildren();
            if (links.length != this.size()) {
                return;
            }
            int i = 0;
            while (i < this.size()) {
                pe = (IJSFElement)this.get(i);
                o = (XModelObject)pe.getSource();
                if (listSource.getChildByPath(o.getPathPart()) == null) {
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < this.size()) {
                pe = (IJSFElement)this.get(i);
                o = (XModelObject)pe.getSource();
                if (!links[i].getPathPart().equals(o.getPathPart())) {
                    this.moveTo(pe, this.size() - 1);
                    --i;
                }
                ++i;
            }
        }

        public void nodeAdded(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            Link newLink = new Link(Page.this, (XModelObject)event.getInfo());
            this.addLink(newLink);
        }

        public void nodeRemoved(Object eventData) {
            XModelTreeEvent event = (XModelTreeEvent)eventData;
            ILink removedLink = (ILink)this.getFromMap(event.getInfo());
            this.removeLink(removedLink);
        }

        public void addLink(ILink link) {
            ((JSFModel)this.jsfModel).putToMap(link.getSource(), link);
            this.add(link);
            IGroup group = (IGroup)Page.this.getParentJSFElement();
            int index = 0;
            int i = 0;
            while (i < group.getPageList().size()) {
                index += ((IPage)group.getPageList().get(i)).getLinkList().size();
                if (i == group.getPageList().indexOf(Page.this)) break;
                ++i;
            }
            group.addOutputLink(link, index - 1);
            link.setTarget();
        }

        public void removeLink(ILink link) {
            this.removeFromMap(link);
            int index = this.indexOf(link);
            link.getToGroup().removeInputLink(link);
            this.remove(link);
            ((Group)Page.this.getParentJSFElement()).removeOutputLink(link);
            Page.this.fireLinkRemove(link, index);
            link.remove();
        }
    }
}

