/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.model.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.jsf.ui.editor.model.IJSFElement;
import org.jboss.tools.jsf.ui.editor.model.IJSFElementList;
import org.jboss.tools.jsf.ui.editor.model.IJSFElementListListener;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFElement;
import org.jboss.tools.jsf.ui.editor.model.impl.JSFModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFElementList
extends JSFElement
implements IJSFElementList,
VetoableChangeListener {
    List<IJSFElementListListener> listeners = new Vector<IJSFElementListListener>();
    List<Object> elements = new Vector<Object>();
    boolean elementListListenerEnable = true;
    boolean allowDuplicate = false;

    public JSFElementList() {
    }

    public JSFElementList(IJSFElement parent) {
        super(parent);
    }

    public JSFElementList(IJSFElement parent, XModelObject source) {
        super(parent, source);
    }

    @Override
    public List getElements() {
        return this.elements;
    }

    public JSFElementList(List<Object> vector) {
        this.elements = vector;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listeners = null;
        if (this.elements != null) {
            this.elements.clear();
        }
        this.elements = null;
    }

    public void setAllowDuplicate(boolean set) {
        this.allowDuplicate = set;
    }

    public boolean isAllowDuplicate() {
        return this.allowDuplicate;
    }

    @Override
    public void moveTo(Object object, int index) {
        int currentIndex = this.indexOf(object);
        if (index < 0 || index >= this.size()) {
            return;
        }
        if (currentIndex > index) {
            int i = currentIndex - 1;
            while (i >= index) {
                Object elementAt = this.get(i);
                this.set(i + 1, elementAt);
                --i;
            }
            this.set(index, object);
            this.fireElementMoved((IJSFElement)object, index, currentIndex);
        } else if (currentIndex < index) {
            int i = currentIndex + 1;
            while (i <= index) {
                Object elementAt = this.get(i);
                this.set(i - 1, elementAt);
                ++i;
            }
            this.set(index, object);
            this.fireElementMoved((IJSFElement)object, index, currentIndex);
        }
    }

    @Override
    public void moveUp(Object object) {
        int currentIndex = this.indexOf(object);
        if (currentIndex == 0) {
            return;
        }
        this.set(currentIndex, this.get(currentIndex - 1));
        this.set(currentIndex - 1, object);
        this.fireElementMoved((IJSFElement)object, currentIndex - 1, currentIndex);
    }

    @Override
    public void moveDown(Object object) {
        int currentIndex = this.indexOf(object);
        if (currentIndex == this.size()) {
            return;
        }
        this.set(currentIndex, this.get(currentIndex + 1));
        this.set(currentIndex + 1, object);
        this.fireElementMoved((IJSFElement)object, currentIndex + 1, currentIndex);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.elements.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.elements.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        boolean result = o instanceof IJSFElement && this.elements.add(o);
        return result;
    }

    @Override
    public void add(IJSFElementList list) {
        int i = 0;
        while (i < list.size()) {
            Object o = list.get(i);
            if (o instanceof JSFElement) {
                this.add(o);
            }
            ++i;
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.elements.remove(o);
        return result;
    }

    @Override
    public void remove(Comparator comp) {
        int i = this.size() - 1;
        while (i >= 0) {
            if (comp.equals(this.get(i))) {
                this.remove(this.get(i));
            }
            --i;
        }
    }

    @Override
    public void removeAll() {
        int i = this.size() - 1;
        while (i >= 0) {
            this.remove(this.get(i));
            --i;
        }
    }

    @Override
    public Object get(int index) {
        return this.elements.get(index);
    }

    public Object get(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < this.elements.size()) {
            JSFElement element = (JSFElement)this.elements.get(i);
            if (name.equals(element.getPath())) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Object set(int index, Object element) {
        Object newElement = this.elements.set(index, element);
        return newElement;
    }

    @Override
    public void add(int index, Object element) {
        this.elements.add(index, element);
    }

    @Override
    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    @Override
    public IJSFElement findElement(Comparator comparator) {
        return null;
    }

    @Override
    public IJSFElementList findElements(Comparator comparator) {
        return null;
    }

    @Override
    public String getText() {
        return this.toString();
    }

    @Override
    public Object clone() {
        Vector<Object> copy = new Vector<Object>();
        copy.addAll(this.elements);
        JSFElementList clone = new JSFElementList(copy);
        return clone;
    }

    public JSFElementList getClone() {
        JSFElementList list = (JSFElementList)this.clone();
        return list;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public void addJSFElementListListener(IJSFElementListListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeJSFElementListListener(IJSFElementListListener l) {
        this.listeners.remove(l);
    }

    protected void fireElementMoved(IJSFElement element, int newIndex, int oldIndex) {
        int i = 0;
        while (i < this.listeners.size()) {
            IJSFElementListListener listener = this.listeners.get(i);
            if (listener != null && listener.isElementListListenerEnable()) {
                listener.listElementMove(this, element, newIndex, oldIndex);
            }
            ++i;
        }
        ((JSFModel)this.getJSFModel()).fireElementRemoved(element, oldIndex);
        ((JSFModel)this.getJSFModel()).fireElementInserted(element);
    }

    protected void fireElementAdded(IJSFElement element, int index) {
        int i = 0;
        while (i < this.listeners.size()) {
            IJSFElementListListener listener = this.listeners.get(i);
            if (listener != null && listener.isElementListListenerEnable()) {
                listener.listElementAdd(this, element, index);
            }
            ++i;
        }
    }

    protected void fireElementRemoved(IJSFElement element, int index) {
        int i = 0;
        while (i < this.listeners.size()) {
            IJSFElementListListener listener = this.listeners.get(i);
            if (listener != null && listener.isElementListListenerEnable()) {
                listener.listElementRemove(this, element, index);
            }
            ++i;
        }
    }

    protected void fireElementChanged(IJSFElement element, int index, PropertyChangeEvent event) {
        int i = 0;
        while (i < this.listeners.size()) {
            IJSFElementListListener listener = this.listeners.get(i);
            if (listener != null && listener.isElementListListenerEnable()) {
                listener.listElementChange(this, element, index, event);
            }
            ++i;
        }
    }

    public void remove(int index) {
        Object obj = this.elements.get(index);
        this.elements.remove(obj);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

