/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.gef.GEFGraphicalViewer;
import org.jboss.tools.jsf.ui.editor.edit.GroupEditPart;
import org.jboss.tools.jsf.ui.editor.figures.NodeFigure;
import org.jboss.tools.jsf.ui.editor.figures.xpl.FixedConnectionAnchor;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.IPage;
import org.jboss.tools.jsf.ui.editor.print.PrintIconHelper;

public class GroupFigure
extends NodeFigure
implements HandleBounds,
FigureListener,
MouseListener,
MouseMotionListener,
KeyListener {
    private static final Dimension SIZE = new Dimension(56, 100);
    private Image icon = null;
    public IGroup group;
    private Label label = null;
    PointList fillPointlist;
    PointList fill2Pointlist;
    PointList shadowPointlist;
    PointList shadow2Pointlist;
    String path;
    GroupEditPart editPart;
    int width;
    int height;

    public void setGroupEditPart(GroupEditPart part) {
        this.editPart = part;
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        this.resizeFigure();
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
    }

    public void setPath(String path) {
        this.path = path;
        if (this.label != null) {
            this.label.setText(path);
            this.label.setSize(this.label.getPreferredSize());
        }
    }

    public void refreshFont() {
        if (this.label != null) {
            this.label.setFont(this.group.getJSFModel().getOptions().getViewPathFont());
            this.label.setSize(this.label.getPreferredSize());
            this.label.setLocation(new Point(this.getLocation().x - 5, this.getLocation().y - (12 + this.group.getJSFModel().getOptions().getViewPathFont().getFontData()[0].getHeight())));
        }
    }

    public void setIcon(Image i) {
        this.icon = PrintIconHelper.getPrintImage(i);
    }

    public void addNotify() {
        if (this.group == null) {
            return;
        }
        this.label = new Label(this.path);
        this.label.setFont(this.group.getJSFModel().getOptions().getViewPathFont());
        this.getParent().add((IFigure)this.label);
        this.label.setForegroundColor(ColorConstants.black);
        this.label.setOpaque(false);
        this.label.setText(this.path);
        this.label.setVisible(true);
        this.label.setSize(this.label.getPreferredSize());
        this.label.setLocation(new Point(this.getLocation().x - 5, this.getLocation().y - (12 + this.group.getJSFModel().getOptions().getViewPathFont().getFontData()[0].getHeight())));
        this.label.addMouseListener((MouseListener)this);
    }

    public void removeNotify() {
        if (this.group == null) {
            return;
        }
        this.label.removeMouseListener((MouseListener)this);
        this.getParent().remove((IFigure)this.label);
    }

    public void figureMoved(IFigure source) {
        if (this.group != null) {
            this.label.setLocation(new Point(this.getLocation().x - 5, this.getLocation().y - 20));
        }
    }

    public void init(int number) {
        if (number == 0) {
            number = 1;
        }
        int i = 0;
        while (i < number) {
            FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
            c.offsetV = 32 + 16 * i;
            c.leftToRight = false;
            this.connectionAnchors.put(String.valueOf(i + 1) + "_OUT", c);
            this.outputConnectionAnchors.addElement(c);
            ++i;
        }
    }

    public void addConnectionAnchor(int number) {
        if (number == 1) {
            return;
        }
        FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
        c.offsetV = 32 + 16 * (number - 1);
        c.leftToRight = false;
        this.connectionAnchors.put(String.valueOf(number) + "_OUT", c);
        this.outputConnectionAnchors.addElement(c);
    }

    public void removeConnectionAnchor() {
        if (this.outputConnectionAnchors.size() == 1) {
            return;
        }
        this.outputConnectionAnchors.remove(this.outputConnectionAnchors.size() - 1);
    }

    public void removeAllConnectionAnchor() {
        this.outputConnectionAnchors.removeAllElements();
    }

    public GroupFigure(IGroup group) {
        this.group = group;
        if (group != null) {
            this.setIcon(group.getImage());
            this.setPath(group.getVisiblePath());
        }
        this.setOpaque(false);
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.resizeFigure();
        this.addFigureListener(this);
        this.addKeyListener(this);
        this.setBorder((Border)new GroupBorder(blackColor));
        if (group != null) {
            FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
            c.offsetV = 8;
            c.offsetH = -1;
            this.connectionAnchors.put("1_IN", c);
            this.inputConnectionAnchors.addElement(c);
            if (group.getPageList().size() <= 1) {
                this.init(group.getListOutputLinks().size());
            }
        }
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(0, 0, 0, 0));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    private void resizeFigure() {
        if (this.width == this.getSize().width && this.height == this.getSize().height) {
            return;
        }
        int start = 0;
        this.width = this.getSize().width - 1;
        this.height = this.getSize().height - 1;
        if (this.group != null && this.group.isPattern()) {
            start += 3;
            --this.height;
        }
        this.fillPointlist = new PointList();
        this.fillPointlist.addPoint(start, 20);
        this.fillPointlist.addPoint(start + 23, 20);
        this.fillPointlist.addPoint(start + 23, 0);
        this.fillPointlist.addPoint(this.width - 15, 0);
        this.fillPointlist.addPoint(this.width - 1, 14);
        this.fillPointlist.addPoint(this.width - 1, this.height - 1);
        this.fillPointlist.addPoint(start, this.height - 1);
        if (this.group != null && this.group.isPattern()) {
            this.fill2Pointlist = new PointList();
            this.fill2Pointlist.addPoint(0, 3);
            this.fill2Pointlist.addPoint(1, 2);
            this.fill2Pointlist.addPoint(3, 2);
            this.fill2Pointlist.addPoint(3, this.getSize().height - 3);
            this.fill2Pointlist.addPoint(this.width - 6, this.getSize().height - 3);
            this.fill2Pointlist.addPoint(this.width - 6, this.getSize().height - 1);
            this.fill2Pointlist.addPoint(1, this.getSize().height - 1);
            this.fill2Pointlist.addPoint(0, this.getSize().height - 2);
        }
        this.shadowPointlist = new PointList();
        this.shadowPointlist.addPoint(this.width - 15, 0);
        this.shadowPointlist.addPoint(this.width - 14, 4);
        this.shadowPointlist.addPoint(this.width - 15, 7);
        this.shadowPointlist.addPoint(this.width - 18, 10);
        this.shadowPointlist.addPoint(this.width - 1, 14);
        this.shadowPointlist.addPoint(this.width - 9, 14);
        this.shadowPointlist.addPoint(this.width - 16, 13);
        this.shadowPointlist.addPoint(this.width - 21, 11);
        this.shadowPointlist.addPoint(this.width - 18, 8);
        this.shadowPointlist.addPoint(this.width - 16, 4);
        this.shadow2Pointlist = new PointList();
        this.shadow2Pointlist.addPoint(this.width - 15, 0);
        this.shadow2Pointlist.addPoint(this.width - 1, 14);
        this.shadow2Pointlist.addPoint(this.width - 3, 14);
        this.shadow2Pointlist.addPoint(this.width - 15, 2);
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        int height = r.height - 1;
        int start = 0;
        if (this.group != null && this.group.isPattern()) {
            start += 3;
            --height;
        }
        g.setBackgroundColor(whiteColor);
        g.fillRectangle(start + 1, 1, 22, 19);
        if (this.icon != null) {
            g.drawImage(this.icon, start + 4, 2);
        }
        if (this.group.hasErrors()) {
            g.drawImage(errorIcon, start + 4, 10);
        }
        if (this.group != null && this.group.isPattern()) {
            g.setBackgroundColor(lightBlueColor);
        } else if (this.group != null && this.group.isConfirmed()) {
            g.setBackgroundColor(yellowColor);
        } else {
            g.setBackgroundColor(lightGrayColor);
        }
        g.fillPolygon(this.fillPointlist);
        if (this.group != null && this.group.isPattern()) {
            g.fillPolygon(this.fill2Pointlist);
        }
        if (this.group != null && this.group.isPattern()) {
            g.setBackgroundColor(darkBlueColor);
        } else if (this.group != null && this.group.isConfirmed()) {
            g.setBackgroundColor(orangeColor);
        } else {
            g.setBackgroundColor(lightGrayColor);
        }
        g.fillPolygon(this.shadowPointlist);
        g.fillPolygon(this.shadow2Pointlist);
    }

    public void mouseDoubleClicked(MouseEvent me) {
    }

    public void mousePressed(MouseEvent me) {
        if (me.button == 3) {
            ((GEFGraphicalViewer)this.editPart.getViewer()).setNoDeselect();
            this.editPart.getViewer().select((EditPart)this.editPart);
        }
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void mouseDragged(MouseEvent me) {
    }

    public void mouseEntered(MouseEvent me) {
    }

    public void mouseExited(MouseEvent me) {
        this.closeNavigator();
    }

    public void closeNavigator() {
    }

    public void mouseHover(MouseEvent me) {
    }

    public void mouseMoved(MouseEvent me) {
    }

    public void keyPressed(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
    }

    class GroupBorder
    extends LineBorder {
        public GroupBorder(Color color) {
            super(color);
        }

        public void paint(IFigure figure, Graphics graphics, Insets insets) {
            Rectangle r = GroupBorder.getPaintRectangle((IFigure)figure, (Insets)insets).getCopy();
            graphics.translate(r.getLocation());
            int start = 0;
            int width = r.width - 1;
            int height = r.height - 1;
            if (GroupFigure.this.group != null && GroupFigure.this.group.isPattern()) {
                start += 3;
                --height;
            }
            if (GroupFigure.this.group != null && GroupFigure.this.group.isConfirmed()) {
                graphics.setForegroundColor(blackColor);
            } else {
                graphics.setForegroundColor(darkGrayColor);
            }
            graphics.drawLine(start + 1, 0, width - 15, 0);
            graphics.drawLine(start, 1, start, height - 2);
            graphics.drawLine(start + 1, height - 1, width - 2, height - 1);
            graphics.drawLine(width - 1, 14, width - 1, height - 2);
            graphics.drawLine(width - 15, 0, width - 1, 14);
            graphics.drawLine(start, 1, start + 1, 0);
            graphics.drawLine(start, height - 2, start + 1, height - 1);
            graphics.drawLine(width - 2, height - 1, width - 1, height - 2);
            graphics.drawLine(width - 15, 0, width - 14, 4);
            graphics.drawLine(width - 14, 4, width - 15, 7);
            graphics.drawLine(width - 15, 7, width - 18, 10);
            graphics.drawLine(width - 18, 10, width - 1, 14);
            graphics.drawLine(start + 23, 0, start + 23, 19);
            graphics.drawLine(start, 20, start + 22, 20);
            graphics.drawLine(start + 22, 20, start + 23, 19);
            if (GroupFigure.this.group != null && GroupFigure.this.group.isPattern()) {
                graphics.drawLine(1, 2, 3, 2);
                graphics.drawLine(0, 3, 0, r.height - 2);
                graphics.drawLine(1, r.height - 1, width - 7, r.height - 1);
                graphics.drawLine(width - 6, r.height - 2, width - 6, r.height - 3);
                graphics.drawLine(0, 3, 1, 2);
                graphics.drawLine(0, r.height - 2, 1, r.height - 1);
                graphics.drawLine(width - 7, r.height - 1, width - 6, r.height - 2);
            }
            if (GroupFigure.this.group != null && GroupFigure.this.group.isPattern()) {
                graphics.setForegroundColor(pattBorder);
            } else if (GroupFigure.this.group != null && GroupFigure.this.group.isConfirmed()) {
                graphics.setForegroundColor(borderColor);
            } else {
                graphics.setForegroundColor(darkGrayColor);
            }
            int index = 0;
            int y = 24;
            if (GroupFigure.this.group != null) {
                int i = 1;
                while (i < GroupFigure.this.group.getPageList().size()) {
                    index = ((IPage)GroupFigure.this.group.getPageList().get(i - 1)).getLinkList().size();
                    if (((IPage)GroupFigure.this.group.getPageList().get(i - 1)).getLinkList().size() == 0) {
                        index = 1;
                    }
                    graphics.drawLine(start + 1, y += index * 16 - 1, width - 2, y);
                    ++y;
                    ++i;
                }
            }
        }
    }
}

