/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.edit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.gef.GEFGraphicalViewer;
import org.jboss.tools.common.gef.edit.GEFRootEditPart;
import org.jboss.tools.common.gef.figures.GEFLabel;
import org.jboss.tools.common.gef.figures.xpl.CustomLocator;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.dnd.DnDUtil;
import org.jboss.tools.jsf.ui.JsfUIMessages;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.JSFEditor;
import org.jboss.tools.jsf.ui.editor.edit.GroupEditPart;
import org.jboss.tools.jsf.ui.editor.edit.LinkEditPolicy;
import org.jboss.tools.jsf.ui.editor.edit.LinkEndpointEditPolicy;
import org.jboss.tools.jsf.ui.editor.figures.ConnectionFigure;
import org.jboss.tools.jsf.ui.editor.figures.FigureFactory;
import org.jboss.tools.jsf.ui.editor.model.ILink;
import org.jboss.tools.jsf.ui.editor.model.ILinkListener;

public class LinkEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener,
ILinkListener,
EditPartListener {
    public static final Image icon = ImageDescriptor.createFromFile(JSFEditor.class, (String)"icons/shortcut.gif").createImage();
    AccessibleEditPart acc;
    private boolean shortcut;
    private CustomLocator shortcutLocator;
    private GEFLabel shortcutLabel;
    private CustomLocator pathLocator;
    private GEFLabel pathLabel;

    public void activate() {
        super.activate();
        this.getLink().addPropertyChangeListener(this);
        this.addEditPartListener(this);
    }

    public void activateFigure() {
        super.activateFigure();
        this.getFigure().addPropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
    }

    public void doDoubleClick(boolean cf) {
        try {
            XModelObject s = (XModelObject)this.getLinkModel().getSource();
            XAction action = DnDUtil.getEnabledAction((XModelObject)s, null, (String)"Properties.Properties");
            if (action != null) {
                action.executeHandler(s, null);
            }
        }
        catch (XModelException e) {
            JsfUiPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void doMouseDown(boolean cf) {
    }

    public void doMouseUp(boolean cf) {
        if (!(this.getTarget() instanceof GroupEditPart)) {
            return;
        }
        GroupEditPart g = (GroupEditPart)this.getTarget();
        if (cf && this.getLink().isShortcut()) {
            ((GEFGraphicalViewer)this.getViewer()).getGEFEditor().getModelSelectionProvider().setSelection((ISelection)new StructuredSelection(g.getGroupModel().getSource()));
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new LinkEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new LinkEditPolicy());
    }

    protected IFigure createFigure() {
        if (this.getLink() == null) {
            return null;
        }
        ConnectionFigure conn = FigureFactory.createNewBendableWire(this, this.getLink());
        PointList list = this.getLink().getPointList();
        if (list.size() > 0) {
            conn.setManual(true);
            conn.setOldPoints(list.getFirstPoint(), list.getLastPoint());
            conn.setPoints(list);
        }
        this.pathLabel = new GEFLabel(this.getLink().getLinkName(), FigureFactory.normalColor);
        this.pathLabel.setFont(this.getLink().getJSFModel().getOptions().getLinkPathFont());
        this.pathLabel.setIcon(null);
        this.pathLabel.setTextAlignment(1);
        this.pathLabel.setLabelAlignment(1);
        this.pathLocator = new CustomLocator((Connection)conn, false);
        this.pathLocator.setUDistance(5);
        this.pathLocator.setVDistance(-13);
        if (!this.getLink().isShortcut()) {
            conn.add((IFigure)this.pathLabel, this.pathLocator);
        }
        String text = "";
        if (this.getLink().getJSFModel().getOptions().showShortcutPath() && this.getLink().getToGroup() != null) {
            text = this.getLink().getToGroup().getVisiblePath();
        }
        this.shortcutLabel = new GEFLabel(text, FigureFactory.normalColor);
        if (this.getLink().getJSFModel().getOptions().showShortcutIcon()) {
            this.shortcutLabel.setIcon(icon);
        }
        this.shortcutLabel.setFont(this.getLink().getJSFModel().getOptions().getLinkPathFont());
        this.shortcutLabel.setTextAlignment(1);
        this.shortcutLabel.setLabelAlignment(1);
        this.shortcutLabel.setIconAlignment(1);
        this.shortcutLocator = new CustomLocator((Connection)conn, false);
        this.shortcutLocator.setUDistance(18);
        this.shortcutLocator.setVDistance(-6);
        if (this.getLink().isShortcut()) {
            conn.add((IFigure)this.shortcutLabel, this.shortcutLocator);
        }
        return conn;
    }

    public ILink getLinkModel() {
        return (ILink)this.getModel();
    }

    public void save() {
        PointList list = ((ConnectionFigure)this.getFigure()).getPoints();
        this.getLink().savePointList(list);
    }

    public void clear() {
        this.getLink().clearPointList();
    }

    public void deactivate() {
        this.removeEditPartListener(this);
        this.getLink().removePropertyChangeListener(this);
        super.deactivate();
    }

    public void deactivateFigure() {
        this.getFigure().removePropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
        super.deactivateFigure();
    }

    public AccessibleEditPart getAccessibleEditPart() {
        if (this.acc == null) {
            this.acc = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = JsfUIMessages.LinkEditPart_Link;
                }
            };
        }
        return this.acc;
    }

    protected ILink getLink() {
        return (ILink)this.getModel();
    }

    protected ConnectionFigure getLinkFigure() {
        return (ConnectionFigure)this.getFigure();
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getPropertyName();
        if ("value".equals(property)) {
            this.refreshVisuals();
        }
    }

    protected void refreshVisuals() {
    }

    public void setModel(Object model) {
        super.setModel(model);
        ((ILink)model).addLinkListener(this);
        this.shortcut = this.getLink().isShortcut();
    }

    public boolean isLinkListenerEnable() {
        return true;
    }

    public void linkChange(ILink source) {
        this.pathLabel.setText(this.getLink().getLinkName());
        if (this.getLinkModel().getJSFModel().getOptions().showShortcutPath() && this.getLink().getToGroup() != null) {
            this.shortcutLabel.setText(this.getLink().getToGroup().getVisiblePath());
        } else {
            this.shortcutLabel.setText("");
        }
        if (this.getLinkModel().getJSFModel().getOptions().showShortcutIcon()) {
            this.shortcutLabel.setIcon(icon);
        } else {
            this.shortcutLabel.setIcon(null);
        }
        this.getLinkFigure().refreshFont();
        if (this.shortcut != this.getLink().isShortcut()) {
            this.shortcut = this.getLink().isShortcut();
            if (this.shortcut) {
                this.getLinkFigure().add((IFigure)this.shortcutLabel, this.shortcutLocator);
                this.getLinkFigure().remove((IFigure)this.pathLabel);
            } else {
                this.getLinkFigure().remove((IFigure)this.shortcutLabel);
                this.getLinkFigure().add((IFigure)this.pathLabel, this.pathLocator);
            }
            this.refresh();
        }
        if (this.getLinkFigure().isManual() && this.getLink().getPathFromModel().equals("")) {
            this.getLinkFigure().setManual(false);
            this.refresh();
        } else if (!this.getLinkFigure().isManual() && !this.getLink().getPathFromModel().equals("")) {
            this.getLinkFigure().setManual(true);
            this.refresh();
        }
    }

    public void linkRemove(ILink source) {
        this.getLink().removeLinkListener(this);
    }

    public void childAdded(EditPart child, int index) {
    }

    public void partActivated(EditPart editpart) {
    }

    public void partDeactivated(EditPart editpart) {
    }

    public void removingChild(EditPart child, int index) {
    }

    public void selectedStateChanged(EditPart editpart) {
        if (this.getSelected() == 2) {
            ((GEFRootEditPart)this.getParent()).setToFront((AbstractConnectionEditPart)this);
        }
    }
}

