/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.PaletteContextMenuProvider;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerPreferences;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.stackview.CommandStackInspectorPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jboss.tools.common.editor.AbstractSelectionProvider;
import org.jboss.tools.common.gef.GEFConnectionCreationToolEntry;
import org.jboss.tools.common.gef.GEFEditor;
import org.jboss.tools.common.gef.action.DiagramAlignmentAction;
import org.jboss.tools.common.gef.action.IDiagramSelectionProvider;
import org.jboss.tools.common.gef.edit.GEFRootEditPart;
import org.jboss.tools.common.gef.editor.xpl.DefaultPaletteCustomizer;
import org.jboss.tools.common.gef.outline.xpl.DiagramContentOutlinePage;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelTransferBuffer;
import org.jboss.tools.common.reporting.ProblemReportingHelper;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.helpers.JSFProcessStructureHelper;
import org.jboss.tools.jsf.ui.JsfUiPlugin;
import org.jboss.tools.jsf.ui.editor.FacesConfigEditorMessages;
import org.jboss.tools.jsf.ui.editor.JSFContextMenuProvider;
import org.jboss.tools.jsf.ui.editor.actions.JSFCopyAction;
import org.jboss.tools.jsf.ui.editor.actions.JSFCutAction;
import org.jboss.tools.jsf.ui.editor.actions.JSFDeleteAction;
import org.jboss.tools.jsf.ui.editor.actions.JSFPasteAction;
import org.jboss.tools.jsf.ui.editor.dnd.FileTransferDropTargetListener;
import org.jboss.tools.jsf.ui.editor.dnd.JSFTemplateTransferDropTargetListener;
import org.jboss.tools.jsf.ui.editor.dnd.XModelTransferDropTargetListener;
import org.jboss.tools.jsf.ui.editor.edit.GraphicalPartFactory;
import org.jboss.tools.jsf.ui.editor.edit.GroupEditPart;
import org.jboss.tools.jsf.ui.editor.edit.JSFDiagramEditPart;
import org.jboss.tools.jsf.ui.editor.edit.JSFEditPart;
import org.jboss.tools.jsf.ui.editor.edit.LinkEditPart;
import org.jboss.tools.jsf.ui.editor.edit.xpl.JSFConnectionRouter;
import org.jboss.tools.jsf.ui.editor.figures.GroupFigure;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.IJSFElement;
import org.jboss.tools.jsf.ui.editor.model.IJSFModel;
import org.jboss.tools.jsf.ui.editor.model.IJSFModelListener;
import org.jboss.tools.jsf.ui.editor.model.ILink;
import org.jboss.tools.jsf.ui.editor.palette.JSFPaletteViewerPreferences;
import org.jboss.tools.jsf.ui.editor.print.Page;
import org.jboss.tools.jsf.ui.editor.print.PageFormat;
import org.jboss.tools.jsf.ui.editor.print.Pages;
import org.jboss.tools.jsf.ui.editor.print.PrintPreviewDialog;

public class JSFEditor
extends GEFEditor
implements IJSFModelListener {
    public static byte JSF_DIAGRAM_RENAME;
    private KeyHandler sharedKeyHandler;
    private IJSFModel model;
    ScrollingGraphicalViewer viewer;
    private static GEFConnectionCreationToolEntry connectionCreationTool;
    public static String PRINT_DIAGRAM;
    private static boolean switchToSelectionTool;
    private ModelSelectionProvider modelSelectionProvider = new ModelSelectionProvider();

    static {
        connectionCreationTool = null;
        PRINT_DIAGRAM = "Print_Diagram";
        switchToSelectionTool = false;
    }

    public boolean isBordersPaint() {
        return this.getJSFModel().isBorderPaint();
    }

    protected void createPaletteViewer(Composite parent) {
        PaletteViewer viewer = new PaletteViewer();
        JSFPaletteViewerPreferences prefs = new JSFPaletteViewerPreferences(this);
        prefs.setUseLargeIcons(1, false);
        prefs.setUseLargeIcons(0, false);
        prefs.setUseLargeIcons(2, false);
        prefs.setUseLargeIcons(3, false);
        prefs.setLayoutSetting(0);
        viewer.createControl(parent);
        this.setPaletteViewer(viewer);
        this.setPaletteLayout((PaletteViewerPreferences)prefs, this.loadPaletteSize());
        this.paletteViewer.setPaletteViewerPreferences((PaletteViewerPreferences)prefs);
        this.configurePaletteViewer();
        this.hookPaletteViewer();
        this.initializePaletteViewer();
    }

    public JSFEditor(IEditorInput input) {
        super(input);
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void closeEditor(boolean save) {
        this.getSite().getPage().closeEditor((IEditorPart)this, save);
    }

    public void commandStackChanged(EventObject event) {
        if (this.isDirty()) {
            if (!this.savePreviouslyNeeded()) {
                this.setSavePreviouslyNeeded(true);
                this.firePropertyChange(257);
            }
        } else {
            this.setSavePreviouslyNeeded(false);
            this.firePropertyChange(257);
        }
        super.commandStackChanged(event);
    }

    protected void configurePaletteViewer() {
        PaletteViewer viewer = this.getPaletteViewer();
        PaletteContextMenuProvider provider = new PaletteContextMenuProvider(viewer);
        this.getPaletteViewer().setContextMenu((MenuManager)provider);
        viewer.setCustomizer((PaletteCustomizer)new DefaultPaletteCustomizer());
    }

    public ScrollingGraphicalViewer getScrollingGraphicalViewer() {
        return this.viewer;
    }

    protected void configureGraphicalViewer() {
        this.viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.modelSelectionProvider);
        GEFRootEditPart root = new GEFRootEditPart();
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        root.getZoomManager().setZoomLevels(new double[]{0.25, 0.5, 0.75, 1.0});
        root.getZoomManager().setZoom(this.loadZoomSize());
        root.getZoomManager().addZoomListener(new ZoomListener(){

            public void zoomChanged(double zoom) {
                JSFEditor.this.saveZoomSize(zoom);
            }
        });
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.registerAction((IAction)zoomIn);
        this.registerAction((IAction)zoomOut);
        this.viewer.setRootEditPart((RootEditPart)root);
        this.viewer.setEditPartFactory((EditPartFactory)new GraphicalPartFactory());
        JSFContextMenuProvider provider = new JSFContextMenuProvider((EditPartViewer)this.viewer, this.getActionRegistry());
        this.viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("JSFContextmenu", (MenuManager)provider, (ISelectionProvider)this.viewer);
        this.viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)this.viewer).setParent(this.getCommonKeyHandler()));
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        boolean controlFlag = (e.stateMask & 0x40000) > 0;
        EditPart part = this.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        if (part instanceof JSFEditPart) {
            ((JSFEditPart)part).doMouseHover(controlFlag);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        boolean controlFlag = (e.stateMask & 0x40000) > 0;
        EditPart part = this.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        if (part instanceof JSFEditPart) {
            ((JSFEditPart)part).doDoubleClick(controlFlag);
        } else if (part instanceof LinkEditPart) {
            ((LinkEditPart)part).doDoubleClick(controlFlag);
        }
    }

    public void mouseDown(MouseEvent e) {
        boolean controlFlag = (e.stateMask & 0x40000) > 0;
        EditPart part = this.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        if (part instanceof JSFEditPart) {
            ((JSFEditPart)part).doMouseDown(controlFlag);
        } else if (part instanceof LinkEditPart) {
            ((LinkEditPart)part).doMouseDown(controlFlag);
        }
    }

    public void mouseUp(MouseEvent e) {
        boolean controlFlag = (e.stateMask & 0x40000) > 0;
        EditPart part = this.getGraphicalViewer().findObjectAt(new Point(e.x, e.y));
        if (part instanceof JSFEditPart) {
            ((JSFEditPart)part).doMouseUp(controlFlag);
        } else if (part instanceof LinkEditPart) {
            ((LinkEditPart)part).doMouseUp(controlFlag);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public Control getControl() {
        return this.getPaletteViewer().getControl();
    }

    protected void createOutputStream(OutputStream os) throws IOException {
    }

    public void dispose() {
        this.model.removeJSFModelListener(this);
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
    }

    public void doSaveAs() {
    }

    public Object getAdapter(Class type) {
        if (type == IDiagramSelectionProvider.class) {
            if (this.getScrollingGraphicalViewer() == null) {
                return null;
            }
            return new IDiagramSelectionProvider(){

                public ISelection getSelection() {
                    if (JSFEditor.this.getScrollingGraphicalViewer() == null) {
                        return null;
                    }
                    return JSFEditor.this.getScrollingGraphicalViewer().getSelection();
                }
            };
        }
        if (type == CommandStackInspectorPage.class) {
            return new CommandStackInspectorPage(this.getCommandStack());
        }
        if (type == IContentOutlinePage.class) {
            if (this.outline != null) {
                return this.outline;
            }
            this.outline = new DiagramContentOutlinePage((EditPartViewer)new TreeViewer());
            this.outline.setGraphicalViewer(this.getGraphicalViewer());
            this.outline.setSelectionSynchronizer(this.getSelectionSynchronizer());
            return this.outline;
        }
        if (type == ZoomManager.class && this.getGraphicalViewer() != null) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }

    protected int getInitialPaletteSize() {
        return 22;
    }

    protected void handlePaletteResized(int newSize) {
    }

    protected KeyHandler getCommonKeyHandler() {
        return this.sharedKeyHandler;
    }

    public IJSFModel getJSFModel() {
        return this.model;
    }

    protected PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup("control");
        ArrayList<Object> entries = new ArrayList<Object>();
        SelectionToolEntry tool = new SelectionToolEntry();
        tool.setDescription(FacesConfigEditorMessages.JSFDIAGRAM_SELECT);
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        tool.setDescription(FacesConfigEditorMessages.JSFDIAGRAM_MARQUEE);
        entries.add(tool);
        PaletteSeparator sep = new PaletteSeparator("separator");
        sep.setUserModificationPermission(1);
        entries.add(sep);
        connectionCreationTool = new GEFConnectionCreationToolEntry(FacesConfigEditorMessages.JSFDIAGRAM_CREATE_NEW_CONNECTION, FacesConfigEditorMessages.JSFDIAGRAM_CREATE_NEW_CONNECTION, null, ImageDescriptor.createFromFile(JSFEditor.class, (String)"icons/transition.gif"), null){

            protected void dragFinished() {
                XModelTransferBuffer.getInstance().disable();
            }
        };
        connectionCreationTool.setUnloadWhenFinished(switchToSelectionTool);
        entries.add(connectionCreationTool);
        entries.add(sep);
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry(FacesConfigEditorMessages.JSFDIAGRAM_VIEW_TEMPLATE, FacesConfigEditorMessages.JSFDIAGRAM_VIEW_TEMPLATE, (Object)"view template", (CreationFactory)new SimpleFactory(String.class), ImageDescriptor.createFromFile(JSFEditor.class, (String)"icons/view.gif"), null);
        entries.add(combined);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    public void gotoMarker(IMarker marker) {
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.getJSFModel());
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new XModelTransferDropTargetListener(this));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new FileTransferDropTargetListener(this));
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new JSFTemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
        ((ConnectionLayer)((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getLayer((Object)"Connection Layer")).setConnectionRouter((ConnectionRouter)new JSFConnectionRouter());
        this.getGraphicalViewer().setProperty("SnapToGrid.isVisible", (Object)Boolean.TRUE);
        this.getGraphicalViewer().setProperty("SnapToGrid.isEnabled", (Object)Boolean.TRUE);
        this.getGraphicalViewer().setProperty("SnapToGrid.GridSpacing", (Object)new Dimension(8, 8));
    }

    protected void initializePaletteViewer() {
        this.getEditDomain().setPaletteRoot(this.getPaletteRoot());
        FigureCanvas canvas = (FigureCanvas)this.paletteViewer.getControl();
        this.makeUnwrapPaletteItems(canvas.getContents());
        canvas.getContents().revalidate();
        canvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        canvas.setVerticalScrollBarVisibility(FigureCanvas.NEVER);
        this.getPaletteViewer().addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)this.getPaletteViewer()));
    }

    protected void createActions() {
        this.register((IAction)new JSFDeleteAction((IWorkbenchPart)this), true, false);
        this.register((IAction)new JSFCopyAction((IWorkbenchPart)this), true, false);
        this.register((IAction)new JSFPasteAction((IWorkbenchPart)this), true, false);
        this.register((IAction)new JSFCutAction((IWorkbenchPart)this), true, false);
        this.register((IAction)new MyPrintAction((IEditorPart)this), false, true);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 1), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 4), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 8), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 32), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 2), true, false);
        this.register((IAction)new DiagramAlignmentAction((IWorkbenchPart)this, 16), true, false);
    }

    private void register(IAction action, boolean isSelectionAction, boolean isKeyBindingAction) {
        ActionRegistry registry = this.getActionRegistry();
        registry.registerAction(action);
        if (isSelectionAction) {
            this.getSelectionActions().add(action.getId());
        }
        if (isKeyBindingAction) {
            this.getSite().getKeyBindingService().registerAction(action);
        }
    }

    private void registerAction(IAction action) {
        if (action == null) {
            return;
        }
        IHandlerService handler = (IHandlerService)this.getSite().getService(IHandlerService.class);
        String id = action.getId();
        handler.activateHandler(id, (IHandler)new ActionHandler(action));
    }

    public boolean isDirty() {
        return this.isSaveOnCloseNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.getCommandStack().isDirty();
    }

    protected boolean performSaveAs() {
        return false;
    }

    private boolean savePreviouslyNeeded() {
        return this.savePreviouslyNeeded;
    }

    public void setInput(XModelObject input) {
    }

    public void setJSFModel(IJSFModel diagram) {
        this.model = diagram;
        this.model.addJSFModelListener(this);
        switchToSelectionTool = this.model.getOptions().switchToSelectionTool();
    }

    private void setSavePreviouslyNeeded(boolean value) {
        this.savePreviouslyNeeded = value;
    }

    protected void superSetInput(IEditorInput input) {
        super.setInput(input);
    }

    public ISelectionProvider getModelSelectionProvider() {
        return this.modelSelectionProvider;
    }

    private XModelObject getTarget(ISelection ss) {
        if (ss.isEmpty() || !(ss instanceof StructuredSelection)) {
            return null;
        }
        return this.getTarget(((StructuredSelection)ss).getFirstElement());
    }

    private XModelObject getTarget(Object selected) {
        PropertyChangeListener part;
        Object partModel;
        if (selected instanceof JSFEditPart && (partModel = (part = (JSFEditPart)selected).getModel()) instanceof IJSFElement) {
            return (XModelObject)((IJSFElement)partModel).getSource();
        }
        if (selected instanceof LinkEditPart && (partModel = (part = (LinkEditPart)selected).getModel()) instanceof IJSFElement) {
            return (XModelObject)((IJSFElement)partModel).getSource();
        }
        return null;
    }

    protected void hookGraphicalViewer() {
        this.getSelectionSynchronizer().addViewer((EditPartViewer)this.getGraphicalViewer());
    }

    public void groupAdd(IGroup group) {
    }

    public void groupRemove(IGroup group) {
    }

    public boolean isStrutsModelListenerEnabled() {
        return true;
    }

    public void linkAdd(ILink link) {
    }

    public void linkRemove(ILink link) {
    }

    public void processChanged(boolean flag) {
        if (switchToSelectionTool != this.model.getOptions().switchToSelectionTool()) {
            switchToSelectionTool = this.model.getOptions().switchToSelectionTool();
            connectionCreationTool.setUnloadWhenFinished(switchToSelectionTool);
        }
    }

    class ModelSelectionProvider
    extends AbstractSelectionProvider
    implements ISelectionChangedListener {
        ModelSelectionProvider() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.fireSelectionChanged();
            JSFEditor.this.updateActions(JSFEditor.this.getSelectionActions());
        }

        protected XModelObject getSelectedModelObject() {
            if (JSFEditor.this.viewer == null) {
                return null;
            }
            XModelObject o = JSFEditor.this.getTarget(JSFEditor.this.viewer.getSelection());
            XModelObject ref = JSFProcessStructureHelper.instance.getReference(o);
            return ref;
        }

        public void scroll(FreeformViewport vp, GroupFigure figure) {
            int delta;
            int SCROLL_MARGIN = 20;
            Point origin = vp.getViewLocation();
            if (figure.getLocation().x - SCROLL_MARGIN < origin.x) {
                delta = origin.x - (figure.getLocation().x - SCROLL_MARGIN);
                origin.x -= delta;
            } else if (figure.getLocation().x + figure.getSize().width + SCROLL_MARGIN > origin.x + vp.getSize().width) {
                delta = figure.getLocation().x + figure.getSize().width + SCROLL_MARGIN - (origin.x + vp.getSize().width);
                origin.x += delta;
            }
            if (figure.getLocation().y - SCROLL_MARGIN < origin.y) {
                delta = origin.y - (figure.getLocation().y - SCROLL_MARGIN);
                origin.y -= delta;
            } else if (figure.getLocation().y + figure.getSize().height + SCROLL_MARGIN > origin.y + vp.getSize().height) {
                delta = figure.getLocation().y + figure.getSize().height + SCROLL_MARGIN - (origin.y + vp.getSize().height);
                origin.y += delta;
            }
            if (origin.x != vp.getViewLocation().x || origin.y != vp.getViewLocation().y) {
                vp.setViewLocation(origin);
            }
        }

        protected void setSelectedModelObject(XModelObject object) {
            IJSFElement element = JSFEditor.this.getJSFModel().findElement(object.getPath());
            if (element == null) {
                return;
            }
            EditPart part = (EditPart)JSFEditor.this.viewer.getEditPartRegistry().get(element);
            if (part != null) {
                JSFEditor.this.viewer.setSelection((ISelection)new StructuredSelection((Object)part));
                JSFDiagramEditPart diagram = (JSFDiagramEditPart)JSFEditor.this.getScrollingGraphicalViewer().getRootEditPart().getChildren().get(0);
                FreeformViewport vp = diagram.getFreeformViewport();
                if (vp != null && part instanceof GroupEditPart) {
                    GroupFigure fig = (GroupFigure)((GroupEditPart)part).getFigure();
                    if (fig.getLocation().x == 0 && fig.getLocation().y == 0) {
                        fig.setLocation(((GroupEditPart)part).getGroupModel().getPosition());
                    }
                    this.scroll(vp, fig);
                }
            }
        }
    }

    public class MyPrintAction
    extends WorkbenchPartAction {
        private Insets printMargin;

        public MyPrintAction(IEditorPart editor) {
            super((IWorkbenchPart)editor);
            this.printMargin = new Insets(1, 1, 1, 1);
        }

        protected boolean calculateEnabled() {
            return true;
        }

        protected void init() {
            super.init();
            this.setText(JSFUIMessages.PRINT_DIAGRAM);
            this.setToolTipText(JSFUIMessages.PRINT_DIAGRAM);
            this.setId(PRINT_DIAGRAM);
        }

        public Rectangle getPrintRegion(Printer printer) {
            org.eclipse.swt.graphics.Rectangle trim = printer.computeTrim(0, 0, 0, 0);
            org.eclipse.swt.graphics.Rectangle clientArea = printer.getClientArea();
            org.eclipse.swt.graphics.Point printerDPI = printer.getDPI();
            Rectangle printRegion = new Rectangle();
            printRegion.x = Math.max(this.printMargin.left * printerDPI.x / 72 - trim.width, clientArea.x);
            printRegion.y = Math.max(this.printMargin.top * printerDPI.y / 72 - trim.height, clientArea.y);
            printRegion.width = clientArea.x + clientArea.width - printRegion.x - Math.max(0, this.printMargin.right * printerDPI.x / 72 - trim.width);
            printRegion.height = clientArea.y + clientArea.height - printRegion.y - Math.max(0, this.printMargin.bottom * printerDPI.y / 72 - trim.height);
            Rectangle r = new Rectangle(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
            return r;
        }

        public void run() {
            GraphicalViewer viewer = (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
            PrintPreviewDialog d = new PrintPreviewDialog(this.getWorkbenchPart().getSite().getShell(), 67680);
            d.setPrintViewer(viewer);
            d.setEditor(JSFEditor.this);
            Printer printer = new Printer();
            SWTException ex = null;
            try {
                printer.getDPI();
            }
            catch (SWTException ee) {
                ex = ee;
                printer.dispose();
                d = null;
                Status status = new Status(4, "org.jboss.tools.jsf.ui", 0, WizardKeys.getString((String)"PRN_ERROR"), (Throwable)ee);
                ProblemReportingHelper.reportProblem((IStatus)status);
            }
            if (ex == null) {
                d.setPages(new Pages(viewer, new PageFormat(printer, this.getWorkbenchPart().getSite().getShell().getDisplay())));
                String result = d.open();
                if (result != null && result.equals("ok")) {
                    LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
                    IFigure figure = lm.getLayer((Object)"Printable Layers");
                    PrintDialog dialog = new PrintDialog(viewer.getControl().getShell(), 0);
                    PrinterData data = dialog.open();
                    if (data != null) {
                        printer = new Printer(data);
                        double scale = d.getPages().getScale();
                        double dpiScale = printer.getDPI().x / Display.getCurrent().getDPI().x;
                        GC printerGC = new GC((Drawable)printer);
                        SWTGraphics g = new SWTGraphics(printerGC);
                        PrinterGraphics graphics = new PrinterGraphics((Graphics)g, printer);
                        if (printer.startJob(this.getWorkbenchPart().getTitle())) {
                            Pages p = d.getPages();
                            int i = 0;
                            while (i < p.getNumberOfPages()) {
                                if (printer.startPage()) {
                                    graphics.pushState();
                                    Page pg = p.getPrintable(i);
                                    org.eclipse.swt.graphics.Rectangle r1 = pg.getRectangle();
                                    org.eclipse.swt.graphics.Rectangle r = new org.eclipse.swt.graphics.Rectangle(r1.x + p.ix, r1.y + p.iy, r1.width, r1.height);
                                    Rectangle clipRect = new Rectangle();
                                    graphics.translate(-((int)((double)r.x * dpiScale * scale)), -((int)((double)r.y * dpiScale * scale)));
                                    graphics.getClip(clipRect);
                                    clipRect.setLocation((int)((double)r.x * dpiScale * scale), (int)((double)r.y * dpiScale * scale));
                                    graphics.clipRect(clipRect);
                                    graphics.scale(dpiScale * scale);
                                    figure.paint((Graphics)graphics);
                                    graphics.popState();
                                    printer.endPage();
                                }
                                ++i;
                            }
                            graphics.dispose();
                            printer.endJob();
                        }
                    }
                }
            }
        }

        public boolean isEnabled() {
            return true;
        }
    }

    class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException exception) {
                JsfUiPlugin.getPluginLog().logError((Throwable)exception);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((FileEditorInput)JSFEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    if (!JSFEditor.this.isDirty()) {
                        JSFEditor.this.closeEditor(false);
                    }
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = JSFEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        public void run() {
                            JSFEditor.this.superSetInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }
    }
}

