/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.util;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_WITH_PREFIX = "xmlns:";

    public static Element getDocumentElement(String xmlFileName) throws Exception {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(xmlFileName);
            InputSource inSource = new InputSource(inStream);
            Element element = XmlUtil.getDocumentElement(inSource);
            return element;
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Exception e) {
                JspEditorPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    public static Element getDocumentElement(InputSource is) throws Exception {
        return XmlUtil.getDocument(is).getDocumentElement();
    }

    public static Document getDocument(InputSource is) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(is);
    }

    public static void removeChildren(Node node) {
        NodeList children = node.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            int i = len - 1;
            while (i >= 0) {
                node.removeChild(children.item(i));
                --i;
            }
        }
    }

    public static List<TaglibData> processNode(Node node, List<TaglibData> includeTaglibData) {
        ArrayList<TaglibData> taglibs = new ArrayList<TaglibData>();
        if (node == null) {
            return taglibs;
        }
        Node currentNode = node;
        do {
            NamedNodeMap attribList;
            if ((attribList = currentNode.getAttributes()) == null) continue;
            int i = 0;
            while (i < attribList.getLength()) {
                Node tmp = attribList.item(i);
                XmlUtil.processAttribute(taglibs, (Attr)tmp, false);
                ++i;
            }
        } while ((currentNode = currentNode.getParentNode()) != null);
        for (TaglibData taglibData : includeTaglibData) {
            XmlUtil.addTaglib(taglibs, taglibData.getUri(), taglibData.getPrefix(), true, false);
        }
        return taglibs;
    }

    public static List<TaglibData> getTaglibsForJSPDocument(IDocument document, List<TaglibData> includeTaglibs) {
        ArrayList<TaglibData> taglibData = new ArrayList<TaglibData>();
        TLDCMDocumentManager tldcmDocumentManager = TaglibController.getTLDCMDocumentManager((IDocument)document);
        if (tldcmDocumentManager != null) {
            List taglibs_JSP = tldcmDocumentManager.getTaglibTrackers();
            for (TaglibTracker taglibTracker : taglibs_JSP) {
                XmlUtil.addTaglib(taglibData, taglibTracker.getURI(), taglibTracker.getPrefix(), true, false);
            }
        }
        for (TaglibData taglib : includeTaglibs) {
            XmlUtil.addTaglib(taglibData, taglib.getUri(), taglib.getPrefix(), true, false);
        }
        return taglibData;
    }

    private static void processAttribute(List<TaglibData> taglibs, Attr attr, boolean bScopePrefix) {
        String name = attr.getName();
        if (!name.startsWith(XMLNS)) {
            return;
        }
        name = XMLNS.equals(name) ? "" : name.substring(XMLNS_WITH_PREFIX.length());
        XmlUtil.addTaglib(taglibs, attr.getValue(), name, true, bScopePrefix);
    }

    private static void addTaglib(List<TaglibData> taglibs, String newUri, String newPrefix, boolean ns, boolean bScopePrefix) {
        boolean bHasSame = false;
        int i = 0;
        while (i < taglibs.size()) {
            TaglibData taglib = taglibs.get(i);
            if (newUri.equals(taglib.getUri())) {
                return;
            }
            if (newPrefix.equals(taglib.getPrefix())) {
                return;
            }
            ++i;
        }
        if (!bHasSame) {
            taglibs.add(new TaglibData(taglibs.size(), newUri, newPrefix, ns));
        }
    }

    public static TaglibData getTaglibForPrefix(String prefix, List<TaglibData> taglibData) {
        for (TaglibData data : taglibData) {
            if (data.getPrefix() == null || !data.getPrefix().equalsIgnoreCase(prefix)) continue;
            return data;
        }
        return null;
    }
}

