/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.outline.cssdialog.tabs;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.css.ui.StructuredTextViewerConfigurationCSS;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.jboss.tools.jst.jsp.outline.cssdialog.common.ICSSDialogModel;
import org.jboss.tools.jst.jsp.outline.cssdialog.common.StyleAttributes;
import org.jboss.tools.jst.jsp.outline.cssdialog.tabs.ICSSTabControl;

public class TabPreviewControl
extends Composite
implements ICSSTabControl {
    SourceViewer viewer = null;
    private ICSSDialogModel cssModel = null;
    private String selector = null;
    private StyleAttributes styleAttributes;

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public TabPreviewControl(Composite tabFolder, StyleAttributes styleAttributes, ICSSDialogModel cssModel) {
        super(tabFolder, 0);
        this.setLayout((Layout)new FillLayout());
        this.cssModel = cssModel;
        this.styleAttributes = styleAttributes;
        this.initPreview(cssModel);
    }

    public void initPreview(ICSSDialogModel cssModel) {
        this.cssModel = cssModel;
        if (cssModel != null) {
            StructuredTextViewerConfigurationCSS baseConfiguration = new StructuredTextViewerConfigurationCSS();
            this.viewer = new StructuredTextViewer((Composite)this, null, null, false, 2816);
            ((StructuredTextViewer)this.viewer).getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.sse.ui.textfont"));
            this.viewer.configure((SourceViewerConfiguration)baseConfiguration);
            this.viewer.setDocument(cssModel.getDocument());
            this.viewer.setEditable(false);
            this.layout();
        }
    }

    public void reinit(ICSSDialogModel cssModel) {
        this.cssModel = cssModel;
        this.viewer.setDocument(cssModel.getDocument());
    }

    public void releaseModel() {
        this.viewer.setDocument(null);
        this.cssModel = null;
    }

    public void selectClass(String selector) {
        if (this.cssModel != null) {
            IndexedRegion indexedRegion = this.cssModel.getIndexedRegion(selector);
            if (this.viewer != null) {
                if (indexedRegion != null) {
                    this.viewer.setSelectedRange(indexedRegion.getStartOffset(), indexedRegion.getLength());
                    this.viewer.revealRange(indexedRegion.getStartOffset(), indexedRegion.getLength());
                } else {
                    this.viewer.setSelectedRange(0, 0);
                    this.viewer.revealRange(0, 0);
                }
            }
        }
    }

    public void update() {
        this.cssModel.updateCSSStyle(this.selector, this.styleAttributes);
        this.selectClass(this.selector);
    }
}

