/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.outline.cssdialog.common;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.outline.cssdialog.common.CSSConstants;
import org.jboss.tools.jst.jsp.outline.cssdialog.common.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final String CSS_FILE_EXTENTION = "css";
    private static String RGB = "rgb";
    private static String THIN = "thin";
    private static int START_INDEX_RED = 1;
    private static int END_INDEX_RED = 3;
    private static int START_INDEX_GRENN = 3;
    private static int END_INDEX_GREEN = 5;
    private static int START_INDEX_BLUE = 5;
    private static int END_INDEX_BLUE = 7;
    private static int MAX_VALUE_RGB = 255;
    private static int MIN_VALUE_RGB = 0;
    private static int COUNT_COLORS = 3;
    private static int RADIX = 16;
    private static int COLOR_LENGTH = 7;
    private static int START_COLOR_INDEX = 0;
    private static char OPEN_BRACKET = (char)123;
    private static char CLOSE_BRACKET = (char)125;
    private static char SHARP = (char)35;
    private static String SHARP_STRING = "#";
    private static String ZERO_STR = "0";
    private static int NORMAL_MIN_VALUE = 10;
    private static final String EDITOR_ID = "org.eclipse.wst.css.core.csssource.source";

    public static boolean containFolder(String name) {
        return Constants.elemFolder.contains(name);
    }

    public static boolean searchInElement(String name, Map<String, ArrayList<String>> elementMap) {
        Set<String> set = elementMap.keySet();
        for (String str : set) {
            ArrayList<String> list = elementMap.get(str);
            if (!list.contains(name.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static RGB getColor(String color) {
        if (color.equals("") || color.equals("none")) {
            return null;
        }
        if (color.charAt(START_COLOR_INDEX) == SHARP && color.length() == COLOR_LENGTH) {
            String strR = color.substring(START_INDEX_RED, END_INDEX_RED);
            String strG = color.substring(START_INDEX_GRENN, END_INDEX_GREEN);
            String strB = color.substring(START_INDEX_BLUE, END_INDEX_BLUE);
            try {
                Integer.parseInt(strR, RADIX);
                Integer.parseInt(strG, RADIX);
                Integer.parseInt(strB, RADIX);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            return Util.convertColorHEX(color);
        }
        if (color.toLowerCase().indexOf(RGB) != -1) {
            int start = color.indexOf(OPEN_BRACKET);
            int end = color.indexOf(CLOSE_BRACKET);
            String str = color.substring(start + 1, end);
            StringTokenizer st = new StringTokenizer(str, Constants.COMMA);
            int j = 0;
            while (st.hasMoreTokens()) {
                try {
                    int i = Integer.parseInt(st.nextToken().trim());
                    if (i < MIN_VALUE_RGB || i > MAX_VALUE_RGB) {
                        return null;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                ++j;
            }
            if (j == COUNT_COLORS) {
                return Util.convertColorRGB(color);
            }
        } else {
            Map<String, String> colorMap = CSSConstants.COLORS;
            for (String key : colorMap.keySet()) {
                if (!colorMap.get(key).equalsIgnoreCase(color)) continue;
                return Util.convertColorHEX(key);
            }
        }
        return null;
    }

    public static String[] convertExtString(String str) {
        if (THIN.equalsIgnoreCase(str)) {
            return new String[]{THIN, ""};
        }
        if (str == null) {
            return null;
        }
        if (str.trim().equals("")) {
            return new String[]{"", ""};
        }
        String newStr = str.toLowerCase().trim();
        int index = -1;
        int i = 1;
        while (i < Constants.extSizes.length) {
            index = newStr.indexOf(Constants.extSizes[i]);
            if (index != -1) break;
            ++i;
        }
        if (index == -1) {
            return new String[]{newStr, ""};
        }
        String number = newStr.substring(0, index);
        String ext = newStr.substring(index, index + 2);
        return new String[]{number, ext};
    }

    public static boolean searchInExtElement(String name) {
        return Constants.extElem.contains(name);
    }

    public static RGB convertColorRGB(String color) {
        String newStr = color.trim().toLowerCase();
        int[] rgb = new int[COUNT_COLORS];
        int start = newStr.indexOf(OPEN_BRACKET);
        int end = newStr.indexOf(CLOSE_BRACKET);
        String str = newStr.substring(start + 1, end);
        StringTokenizer st = new StringTokenizer(str, Constants.COMMA);
        int i = 0;
        while (st.hasMoreTokens()) {
            rgb[i++] = Integer.parseInt(st.nextToken().trim());
        }
        return new RGB(rgb[0], rgb[1], rgb[2]);
    }

    public static RGB convertColorHEX(String color) {
        String newStr = color.trim().toLowerCase();
        String strR = newStr.substring(START_INDEX_RED, END_INDEX_RED);
        String strG = newStr.substring(START_INDEX_GRENN, END_INDEX_GREEN);
        String strB = newStr.substring(START_INDEX_BLUE, END_INDEX_BLUE);
        int red = Integer.parseInt(strR, RADIX);
        int green = Integer.parseInt(strG, RADIX);
        int blue = Integer.parseInt(strB, RADIX);
        return new RGB(red, green, blue);
    }

    public static String createColorString(RGB rgb) {
        String colorStr = String.valueOf(SHARP_STRING) + (rgb.red < NORMAL_MIN_VALUE ? ZERO_STR : "") + Integer.toHexString(rgb.red) + (rgb.green < NORMAL_MIN_VALUE ? ZERO_STR : "") + Integer.toHexString(rgb.green) + (rgb.blue < NORMAL_MIN_VALUE ? ZERO_STR : "") + Integer.toHexString(rgb.blue);
        if (CSSConstants.COLORS.get(colorStr = colorStr.toUpperCase()) != null) {
            return CSSConstants.COLORS.get(colorStr);
        }
        return colorStr;
    }

    public static IResource getCurrentProject() {
        IWorkspaceRoot result = null;
        IWorkbenchPage page = JspEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && page.getActiveEditor() != null) {
            IEditorPart editor = page.getActiveEditor();
            IEditorInput input = editor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                result = file.getProject();
            }
        } else {
            result = ResourcesPlugin.getWorkspace().getRoot();
        }
        return result;
    }

    public static IFile getActiveCssFile() {
        IFile file;
        IEditorInput input;
        IWorkbenchPage page = JspEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && page.getActiveEditor() != null && (input = page.getActiveEditor().getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()).getName().toLowerCase().endsWith(CSS_FILE_EXTENTION)) {
            return file;
        }
        return null;
    }

    public static String getActivePageCSSSelectorIfAny() {
        IWorkbenchPage page = JspEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection selection = page.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object node : ss) {
                ICSSStyleRule styleRule;
                if (!(node instanceof ICSSNode) || (styleRule = Util.getSelector((ICSSNode)node, null, 0)) == null) continue;
                return styleRule.getSelectorText();
            }
        }
        return null;
    }

    public static ICSSStyleRule getSelector(ICSSNode node, String selector, int index) {
        if (node != null) {
            short nodeType = node.getNodeType();
            switch (nodeType) {
                case 7: {
                    ICSSStyleSheet styleSheet = (ICSSStyleSheet)node;
                    return Util.getSelector(styleSheet.getFirstChild(), selector, index);
                }
                case 1: {
                    ICSSStyleRule styleRule = (ICSSStyleRule)node;
                    boolean selectorFound = true;
                    if (selector != null) {
                        if (styleRule.getSelectorText().equals(selector)) {
                            if (index > 0) {
                                --index;
                                selectorFound = false;
                            }
                        } else {
                            selectorFound = false;
                        }
                    }
                    if (selectorFound) {
                        return styleRule;
                    }
                    return Util.getSelector(styleRule.getNextSibling(), selector, index);
                }
            }
            return Util.getSelector(node.getParentNode(), selector, index);
        }
        return null;
    }

    public static String formatStyleClassToCSSView(String styleClass) {
        if (styleClass != null && !styleClass.equals("")) {
            String[] styleClasses = styleClass.split("\\s++");
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < styleClasses.length) {
                String value = styleClasses[i];
                if (!value.startsWith("#")) {
                    sb.append(".");
                }
                sb.append(value);
                if (i != styleClasses.length - 1) {
                    sb.append(Constants.COMMA);
                    sb.append(" ");
                }
                ++i;
            }
            return sb.toString().trim();
        }
        return null;
    }

    public static String formatCSSSelectorToStyleClassView(String cssSelector) {
        String className = cssSelector;
        if (cssSelector != null) {
            className = cssSelector.replaceAll("\\.", "");
            className = className.replaceAll("\\,", "");
            className = className.replaceAll("\\s++", " ");
        }
        return className;
    }

    public static Point getSelectionInFile(IFile file) {
        IEditorPart editorPart;
        IEditorReference[] editorReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditors((IEditorInput)new FileEditorInput(file), EDITOR_ID, 3);
        Point point = new Point(0, 0);
        if (editorReference != null && editorReference.length > 0 && (editorPart = editorReference[0].getEditor(false)) != null) {
            point = ((StructuredTextEditor)editorPart).getTextViewer().getSelectedRange();
        }
        return point;
    }
}

