/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.outline.cssdialog.common;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.jboss.tools.jst.jsp.JspEditorPlugin;

public class FileExtensionFilter
extends ViewerFilter {
    private String[] fTargetExtension;

    public FileExtensionFilter(String[] targetExtension) {
        this.fTargetExtension = targetExtension;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            int i = 0;
            while (i < this.fTargetExtension.length) {
                if (((IFile)element).getName().toLowerCase().endsWith("." + this.fTargetExtension[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (element instanceof IProject && ((IProject)element).isOpen()) {
            return true;
        }
        if (element instanceof IContainer) {
            try {
                IResource[] resources = ((IContainer)element).members();
                int i = 0;
                while (i < resources.length) {
                    if (this.select(viewer, parent, resources[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                JspEditorPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return false;
    }
}

