/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.outline.cssdialog;

import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jboss.tools.jst.jsp.messages.JstUIMessages;
import org.jboss.tools.jst.jsp.outline.cssdialog.common.StyleAttributes;
import org.jboss.tools.jst.jsp.outline.cssdialog.tabs.BaseTabControl;
import org.jboss.tools.jst.jsp.outline.cssdialog.tabs.ICSSTabControl;
import org.jboss.tools.jst.jsp.outline.cssdialog.tabs.TabBackgroundControl;
import org.jboss.tools.jst.jsp.outline.cssdialog.tabs.TabBoxesControl;
import org.jboss.tools.jst.jsp.outline.cssdialog.tabs.TabPropertySheetControl;
import org.jboss.tools.jst.jsp.outline.cssdialog.tabs.TabQuickEditControl;
import org.jboss.tools.jst.jsp.outline.cssdialog.tabs.TabTextControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleComposite
extends Composite {
    private TabFolder tabFolder;
    private StyleAttributes styleAttributes;
    public static int DEFAULT_START_TAB = 4;

    public StyleComposite(Composite parent, StyleAttributes styleAttributes, DataBindingContext bindingContext) {
        super(parent, 0);
        this.styleAttributes = styleAttributes;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.tabFolder = new TabFolder((Composite)this, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StyleComposite.this.updateTab((TabItem)e.item);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ScrolledComposite tabComposite = this.createTabComposite();
        BaseTabControl baseTabControl = new TabTextControl((Composite)tabComposite, styleAttributes, bindingContext);
        this.createTabItem((Composite)tabComposite, baseTabControl, JstUIMessages.TEXT_FONT_TAB_NAME, JstUIMessages.TEXT_FONT_TAB_NAME);
        tabComposite.setContent((Control)baseTabControl);
        tabComposite.setMinSize(baseTabControl.computeSize(-1, -1));
        tabComposite = this.createTabComposite();
        baseTabControl = new TabBackgroundControl((Composite)tabComposite, styleAttributes, bindingContext);
        this.createTabItem((Composite)tabComposite, baseTabControl, JstUIMessages.BACKGROUND_TAB_NAME, JstUIMessages.BACKGROUND_TAB_NAME);
        tabComposite.setContent((Control)baseTabControl);
        tabComposite.setMinSize(baseTabControl.computeSize(-1, -1));
        tabComposite = this.createTabComposite();
        baseTabControl = new TabBoxesControl((Composite)tabComposite, styleAttributes, bindingContext);
        this.createTabItem((Composite)tabComposite, baseTabControl, JstUIMessages.BOXES_TAB_NAME, JstUIMessages.BOXES_TAB_NAME);
        tabComposite.setContent((Control)baseTabControl);
        tabComposite.setMinSize(baseTabControl.computeSize(-1, -1));
        tabComposite = this.createTabComposite();
        baseTabControl = new TabPropertySheetControl((Composite)tabComposite, styleAttributes, bindingContext);
        this.createTabItem((Composite)tabComposite, baseTabControl, JstUIMessages.PROPERTY_SHEET_TAB_NAME, JstUIMessages.PROPERTY_SHEET_TAB_NAME);
        tabComposite.setContent((Control)baseTabControl);
        tabComposite.setMinSize(baseTabControl.computeSize(-1, -1));
        tabComposite = this.createTabComposite();
        baseTabControl = new TabQuickEditControl((Composite)tabComposite, styleAttributes, bindingContext);
        this.createTabItem((Composite)tabComposite, baseTabControl, JstUIMessages.QUICK_EDIT_TAB_NAME, JstUIMessages.QUICK_EDIT_TAB_NAME);
        tabComposite.setContent((Control)baseTabControl);
        tabComposite.setMinSize(baseTabControl.computeSize(-1, -1));
        this.tabFolder.setSelection(DEFAULT_START_TAB);
    }

    public void clearStyleComposite() {
        this.styleAttributes.clear();
    }

    public void setStyleProperties(Map<String, String> properties) {
        this.styleAttributes.setStyleProperties(properties);
    }

    public TabFolder getTabFolder() {
        return this.tabFolder;
    }

    public TabItem createTabItem(Composite content, ICSSTabControl tabControl, String label, String tooltip) {
        TabItem item = new TabItem(this.tabFolder, 0);
        item.setText(label);
        item.setToolTipText(tooltip);
        item.setControl((Control)content);
        item.setData((Object)tabControl);
        return item;
    }

    public ScrolledComposite createTabComposite() {
        ScrolledComposite scroll = new ScrolledComposite((Composite)this.tabFolder, 768);
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        return scroll;
    }

    public void selectTab(int index) {
        this.tabFolder.setSelection(index);
        TabItem item = this.tabFolder.getItem(index);
        this.updateTab(item);
    }

    public void updateCurrentTab() {
        this.updateTab(this.tabFolder.getSelection()[0]);
    }

    private void updateTab(TabItem item) {
        if (item.getData() instanceof ICSSTabControl) {
            ((ICSSTabControl)item.getData()).update();
        }
    }
}

