/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.jspeditor;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.services.IServiceLocator;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditorPart;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageSelectionProvider;

public abstract class JSPMultiPageEditorSite
implements IEditorSite {
    private IEditorPart fEditorPart;
    private JSPMultiPageEditorPart fEditor;
    private ISelectionChangedListener fSelChangeListener = null;
    private IKeyBindingService fService = null;
    private ArrayList fMenuExts;
    private final ServiceLocator serviceLocator;

    public JSPMultiPageEditorSite(JSPMultiPageEditorPart multiPageEditor, IEditorPart editor) {
        Assert.isNotNull((Object)((Object)multiPageEditor));
        Assert.isNotNull((Object)editor);
        this.fEditor = multiPageEditor;
        this.fEditorPart = editor;
        this.serviceLocator = (ServiceLocator)((IServiceLocatorCreator)multiPageEditor.getSite().getService(IServiceLocatorCreator.class)).createServiceLocator((IServiceLocator)multiPageEditor.getSite(), null, new IDisposable(){

            public void dispose() {
                Control control = ((PartSite)JSPMultiPageEditorSite.this.getMultiPageEditor().getSite()).getPane().getControl();
                if (control != null && !control.isDisposed()) {
                    ((PartSite)JSPMultiPageEditorSite.this.getMultiPageEditor().getSite()).getPane().doHide();
                }
            }
        });
        this.serviceLocator.registerService(IWorkbenchLocationService.class, (Object)new WorkbenchLocationService("org.eclipse.ui.part.MultiPageEditorSite", this.getWorkbenchWindow().getWorkbench(), this.getWorkbenchWindow(), multiPageEditor.getSite(), (IEditorSite)this, null, 3));
    }

    public void dispose() {
        if (this.fMenuExts != null) {
            int i = 0;
            while (i < this.fMenuExts.size()) {
                ((PopupMenuExtender)this.fMenuExts.get(i)).dispose();
                ++i;
            }
            this.fMenuExts = null;
        }
        if (this.fService != null) {
            IKeyBindingService parentService = this.getEditor().getSite().getKeyBindingService();
            if (parentService instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableParent = (INestableKeyBindingService)parentService;
                nestableParent.removeKeyBindingService((IWorkbenchSite)this);
            }
            if (this.fService instanceof KeyBindingService) {
                ((KeyBindingService)this.fService).dispose();
            }
            this.fService = null;
        }
        if (this.fSelChangeListener != null) {
            this.getSelectionProvider().removeSelectionChangedListener(this.fSelChangeListener);
            this.fSelChangeListener = null;
        }
        if (this.serviceLocator != null) {
            this.serviceLocator.dispose();
        }
    }

    public IEditorActionBarContributor getActionBarContributor() {
        return null;
    }

    public IActionBars getActionBars() {
        return this.fEditor.getEditorSite().getActionBars();
    }

    public ILabelDecorator getDecoratorManager() {
        return this.getWorkbenchWindow().getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    public IEditorPart getEditor() {
        return this.fEditorPart;
    }

    public String getId() {
        return String.valueOf(ContentTypeIdForJSP.ContentTypeID_JSP) + ".source";
    }

    public IKeyBindingService getKeyBindingService() {
        if (this.fService == null) {
            this.fService = this.getMultiPageEditor().getEditorSite().getKeyBindingService();
            if (this.fService instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)this.fService;
                this.fService = nestableService.getKeyBindingService((IWorkbenchSite)this);
            } else {
                WorkbenchPlugin.log((String)("MultiPageEditorSite.getKeyBindingService()   Parent key binding fService was not an instance of INestableKeyBindingService.  It was an instance of " + this.fService.getClass().getName() + " instead."));
            }
        }
        return this.fService;
    }

    public JSPMultiPageEditorPart getMultiPageEditor() {
        return this.fEditor;
    }

    public IWorkbenchPage getPage() {
        return this.getMultiPageEditor().getSite().getPage();
    }

    public String getPluginId() {
        return "";
    }

    public String getRegisteredName() {
        return "";
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        if (this.fSelChangeListener == null) {
            this.fSelChangeListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    JSPMultiPageEditorSite.this.handleSelectionChanged(event);
                }
            };
        }
        return this.fSelChangeListener;
    }

    public Shell getShell() {
        return this.getMultiPageEditor().getSite().getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        if (this.getMultiPageEditor().getSite() == null) {
            return null;
        }
        return this.getMultiPageEditor().getSite().getWorkbenchWindow();
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
        if (parentProvider instanceof JSPMultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            ((JSPMultiPageSelectionProvider)parentProvider).fireSelectionChanged(newEvent);
        }
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.fMenuExts == null) {
            this.fMenuExts = new ArrayList(1);
        }
        PopupMenuExtender extender = this.findMenuExtender(menuMgr, selProvider);
        if (this.findMenuExtender(menuMgr, selProvider) == null) {
            extender = new PopupMenuExtender(menuID, menuMgr, selProvider, (IWorkbenchPart)this.fEditorPart);
            this.fMenuExts.add(extender);
        } else {
            extender.addMenuId(menuID);
        }
    }

    private PopupMenuExtender findMenuExtender(MenuManager menuMgr, ISelectionProvider selProvider) {
        int i = 0;
        while (this.fMenuExts != null && i < this.fMenuExts.size()) {
            PopupMenuExtender extender = (PopupMenuExtender)this.fMenuExts.get(i);
            if (extender.matches(menuMgr, selProvider, (IWorkbenchPart)this.fEditorPart)) {
                return extender;
            }
            ++i;
        }
        return null;
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selProvider) {
        this.getMultiPageEditor().getSite().registerContextMenu(menuManager, selProvider);
    }

    public void progressEnd(Job job) {
    }

    public void progressStart(Job job) {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IWorkbenchPart getPart() {
        return this.fEditor;
    }

    public final void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
        this.registerContextMenu(this.getId(), menuManager, selectionProvider, includeEditorInput);
    }

    public final void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
        if (this.fMenuExts == null) {
            this.fMenuExts = new ArrayList(1);
        }
    }

    public Object getService(Class api) {
        return this.serviceLocator.getService(api);
    }

    public boolean hasService(Class api) {
        return this.serviceLocator.hasService(api);
    }

    public final void activate() {
        this.serviceLocator.activate();
    }

    public final void deactivate() {
        this.serviceLocator.deactivate();
    }
}

