/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.jspeditor;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension2;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.contentoutline.ConfigurableContentOutlinePage;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.filesystems.impl.DiscardFileHandler;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.ui.editor.EditorDescriptor;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTASync;
import org.jboss.tools.common.text.ext.IMultiPageEditor;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.editor.IVisualEditor;
import org.jboss.tools.jst.jsp.editor.IVisualEditorFactory;
import org.jboss.tools.jst.jsp.jspeditor.JSPEditorMessages;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditorPart;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditorSite;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageSelectionProvider;
import org.jboss.tools.jst.jsp.jspeditor.JSPTextEditor;
import org.jboss.tools.jst.jsp.jspeditor.PalettePageImpl;
import org.jboss.tools.jst.jsp.jspeditor.ResourceChangeListener;
import org.jboss.tools.jst.web.tld.VpeTaglibManager;
import org.jboss.tools.jst.web.tld.VpeTaglibManagerProvider;

public class JSPMultiPageEditor
extends JSPMultiPageEditorPart
implements XModelTreeListener,
ITextEditor,
IGotoMarker,
VpeTaglibManagerProvider,
IReusableEditor,
ITextEditorExtension,
ITextEditorExtension2,
ITextEditorExtension3,
INavigationLocationProvider,
IMultiPageEditor {
    public static final String EDITOR_ID = "org.jboss.tools.jst.jsp.jspeditor.JSPTextEditor";
    private static final String VPE_VISUAL_EDITOR_IMPL_ID = "org.jboss.tools.vpe.org.jboss.tools.vpe.editor.VpeEditorPartFactory";
    private static final String VISUAL_EDITOR_IMPL_EXTENSION_POINT_NAME = "visulaEditorImplementations";
    private IVisualEditor visualEditor;
    private int visualSourceIndex;
    private JSPTextEditor sourceEditor;
    private int sourceIndex;
    private int previewIndex;
    protected XModelTreeListenerSWTASync syncListener = new XModelTreeListenerSWTASync((XModelTreeListener)this);
    private ConfigurableContentOutlinePage outlinePage = null;
    private XModelObject object;
    private QualifiedName persistentTabQualifiedName = new QualifiedName("", "Selected_tab");
    int selectedPageIndex = 0;
    static IVisualEditorFactory visualEditorFactory;
    private ISelectionProvider selectionProvider = null;
    private JSPMultiPageEditorSite site;
    PalettePageImpl palettePage;

    static {
        try {
            IExtension visualEditorExtension = Platform.getExtensionRegistry().getExtension("org.jboss.tools.jst.jsp", VISUAL_EDITOR_IMPL_EXTENSION_POINT_NAME, VPE_VISUAL_EDITOR_IMPL_ID);
            if (visualEditorExtension != null) {
                IConfigurationElement[] configurationElements = visualEditorExtension.getConfigurationElements();
                if (configurationElements != null && configurationElements.length == 1) {
                    visualEditorFactory = (IVisualEditorFactory)configurationElements[0].createExecutableExtension("class");
                } else {
                    JspEditorPlugin.getPluginLog().logError("Visual Editor Extension Point not configured correctly");
                }
            } else {
                JspEditorPlugin.getPluginLog().logError("Visual Editor Implementation not available");
            }
        }
        catch (CoreException e) {
            JspEditorPlugin.getPluginLog().logError("Visual Editor Implementation not available" + (Object)((Object)e));
        }
    }

    private void loadSelectedTab() {
        String defaultVpeTab = JspEditorPlugin.getDefault().getPreferenceStore().getString("Default VPE Tab");
        this.selectedPageIndex = "0".equalsIgnoreCase(defaultVpeTab) ? 0 : ("1".equalsIgnoreCase(defaultVpeTab) ? 1 : ("2".equalsIgnoreCase(defaultVpeTab) ? 2 : 0));
    }

    public void superPageChange(int newPageIndex) {
        ISelectionProvider selectionProvider;
        Control control = this.getControl(this.visualSourceIndex);
        if (control != null) {
            control.setVisible(true);
        }
        this.setFocus();
        IEditorPart activeEditor = this.getEditor(this.visualSourceIndex);
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage(activeEditor);
        }
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
            ((JSPMultiPageSelectionProvider)this.getSite().getSelectionProvider()).fireSelectionChanged(event);
        }
    }

    public void pageChange(int newPageIndex) {
        this.selectedPageIndex = newPageIndex;
        if (this.visualEditor != null) {
            if (newPageIndex == this.visualSourceIndex) {
                if (this.visualEditor.getVisualEditor() == null) {
                    this.visualEditor.createVisualEditor();
                }
                this.visualEditor.setVisualMode(0);
            } else if (newPageIndex == this.sourceIndex) {
                this.visualEditor.setVisualMode(1);
            } else if (newPageIndex == this.getPreviewIndex()) {
                if (this.visualEditor.getPreviewWebBrowser() == null) {
                    this.visualEditor.createPreviewBrowser();
                }
                this.visualEditor.setVisualMode(2);
            }
        }
        this.superPageChange(newPageIndex);
        JspEditorPlugin.getDefault().getPreferenceStore().setValue("Default VPE Tab", this.selectedPageIndex);
    }

    public int getSelectedPageIndex() {
        return this.selectedPageIndex;
    }

    public void setInput(IEditorInput input) {
        super.setInput(XModelObjectEditorInput.checkInput((IEditorInput)input));
        if (this.getEditorInput() instanceof IModelObjectEditorInput) {
            this.object = ((IModelObjectEditorInput)this.getEditorInput()).getXModelObject();
        }
        if (this.sourceEditor != null && this.sourceEditor.getEditorInput() != this.getEditorInput() && this.sourceEditor.getEditorInput() != null) {
            if (this.sourceEditor instanceof AbstractTextEditor) {
                this.sourceEditor.setInput(this.getEditorInput());
            }
            if (this.visualEditor != null) {
                this.visualEditor.setInput(this.getEditorInput());
            }
            this.updateTitle();
        }
        this.updateFile();
    }

    public void setInput0(IEditorInput input) {
        super.setInput(XModelObjectEditorInput.checkInput((IEditorInput)input));
        this.updateFile();
        this.firePropertyChange(258);
    }

    private void updateFile() {
        IFile file = this.getFile();
        if (file == null) {
            return;
        }
        try {
            file.refreshLocal(0, null);
        }
        catch (CoreException e) {
            JspEditorPlugin.getPluginLog().logWarning((Throwable)e);
        }
    }

    private IFile getFile() {
        IEditorInput input = this.getEditorInput();
        return input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
    }

    public String getContentDescription() {
        return "";
    }

    protected IEditorSite createSite(IEditorPart editor) {
        this.site = new JSPMultiPageEditorSite(this, editor){
            private ISelectionChangedListener postSelectionChangedListener;
            {
                this.postSelectionChangedListener = null;
            }

            private ISelectionChangedListener getPostSelectionChangedListener() {
                if (this.postSelectionChangedListener == null) {
                    this.postSelectionChangedListener = new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            this.handlePostSelectionChanged(event);
                        }
                    };
                }
                return this.postSelectionChangedListener;
            }

            protected void handlePostSelectionChanged(SelectionChangedEvent event) {
                ISelectionProvider parentProvider = this.getMultiPageEditor().getSite().getSelectionProvider();
                ISelection s = event.getSelection();
                if (s == null || s.isEmpty()) {
                    return;
                }
                if (s instanceof ITextSelection && parentProvider instanceof JSPMultiPageSelectionProvider) {
                    ((JSPMultiPageSelectionProvider)parentProvider).firePostSelectionChanged(event);
                }
            }

            public String getId() {
                return JSPMultiPageEditor.this.getSite().getId();
            }

            public ISelectionProvider getSelectionProvider() {
                return JSPMultiPageEditor.this.selectionProvider;
            }

            public void setSelectionProvider(ISelectionProvider provider) {
                ISelectionProvider oldSelectionProvider = this.getSelectionProvider();
                if (oldSelectionProvider != null && oldSelectionProvider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)oldSelectionProvider).removePostSelectionChangedListener(this.getPostSelectionChangedListener());
                }
                JSPMultiPageEditor.this.selectionProvider = provider;
                if (oldSelectionProvider != null) {
                    oldSelectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
                }
                if (JSPMultiPageEditor.this.selectionProvider != null) {
                    JSPMultiPageEditor.this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
                }
                if (provider != null && provider instanceof IPostSelectionProvider) {
                    ((IPostSelectionProvider)provider).addPostSelectionChangedListener(this.getPostSelectionChangedListener());
                }
            }

            public void dispose() {
                ISelectionProvider provider = this.getSelectionProvider();
                if (provider != null) {
                    provider.removeSelectionChangedListener(this.getSelectionChangedListener());
                }
                if (provider instanceof IPostSelectionProvider && this.postSelectionChangedListener != null) {
                    ((IPostSelectionProvider)provider).removePostSelectionChangedListener(this.postSelectionChangedListener);
                }
                this.postSelectionChangedListener = null;
                super.dispose();
            }
        };
        return this.site;
    }

    protected void createPages() {
        this.createPagesForVPE();
        this.loadSelectedTab();
        switch (this.selectedPageIndex) {
            case 0: {
                this.setActivePage(this.selectedPageIndex);
                this.pageChange(this.selectedPageIndex);
                break;
            }
            case 1: {
                this.setActivePage(this.selectedPageIndex);
                this.pageChange(this.selectedPageIndex);
                break;
            }
            case 2: {
                this.setActivePage(this.selectedPageIndex);
                this.pageChange(this.selectedPageIndex);
                break;
            }
            default: {
                this.setActivePage(0);
                this.pageChange(0);
            }
        }
        new ResourceChangeListener((IEditorPart)this, this.getContainer());
        if (this.getModelObject() != null) {
            this.getModelObject().getModel().addModelTreeListener((XModelTreeListener)this.syncListener);
        }
    }

    private void createPagesForVPE() {
        this.sourceEditor = new JSPTextEditor(this);
        if (visualEditorFactory != null) {
            this.visualEditor = visualEditorFactory.createVisualEditor(this, this.sourceEditor, false);
        }
        try {
            if (this.visualEditor != null) {
                this.visualSourceIndex = this.addPage((IEditorPart)this.visualEditor, this.getEditorInput());
                this.setPageText(this.visualSourceIndex, JSPEditorMessages.JSPMultiPageEditor_TabLabel_VisualSource);
                this.setPartName(this.visualEditor.getTitle());
            }
        }
        catch (PartInitException e) {
            JspEditorPlugin.getPluginLog().logError((Throwable)e);
        }
        try {
            String sourceTabLabel = JSPEditorMessages.JSPMultiPageEditor_TabLabel_Source;
            if (this.visualEditor != null) {
                this.sourceIndex = this.addPage((IEditorPart)this.visualEditor, this.getEditorInput());
                this.setPageText(this.sourceIndex, sourceTabLabel);
                this.setPartName(this.visualEditor.getTitle());
            } else {
                this.sourceIndex = this.addPage((IEditorPart)this.sourceEditor, this.getEditorInput());
                this.setPageText(this.sourceIndex, sourceTabLabel);
                this.setPartName(this.sourceEditor.getTitle());
            }
        }
        catch (PartInitException e) {
            JspEditorPlugin.getPluginLog().logError((Throwable)e);
        }
        try {
            if (this.visualEditor != null) {
                this.setPreviewIndex(this.addPage((IEditorPart)this.visualEditor, this.getEditorInput()));
                this.setPageText(this.getPreviewIndex(), JSPEditorMessages.JSPMultiPageEditor_TabLabel_Preview);
                this.setPartName(this.visualEditor.getTitle());
            }
        }
        catch (PartInitException e) {
            JspEditorPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.sourceEditor.doSave(monitor);
    }

    public void doSaveAs() {
        XModelObject old = this.getModelObject();
        PCL pcl = new PCL();
        this.sourceEditor.addPropertyListener(pcl);
        this.sourceEditor.doSaveAs();
        this.sourceEditor.removePropertyListener(pcl);
        try {
            if (old.isModified()) {
                new DiscardFileHandler().executeHandler(old, new Properties());
            }
        }
        catch (XModelException e) {
            JspEditorPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(1);
        this.pageChange(1);
        IGotoMarker adapter = (IGotoMarker)this.sourceEditor.getAdapter(IGotoMarker.class);
        if (adapter != null) {
            adapter.gotoMarker(marker);
        }
    }

    public boolean isSaveAsAllowed() {
        return this.sourceEditor.isSaveAsAllowed();
    }

    public JSPTextEditor getJspEditor() {
        return this.sourceEditor;
    }

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public IVisualEditor getVisualEditor() {
        return this.visualEditor;
    }

    public IEditorPart getActivePageEditor() {
        return this.getActiveEditor();
    }

    protected XModelObject getModelObject() {
        return this.object;
    }

    public void dispose() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPageEditorActionBarContributor) {
            ((MultiPageEditorActionBarContributor)contributor).setActivePage(null);
        }
        if (this.visualEditor != null) {
            this.visualEditor.dispose();
        }
        this.site.dispose();
        this.site = null;
        this.outlinePage = null;
        XModelObject o = this.getModelObject();
        if (o != null) {
            o.getModel().removeModelTreeListener((XModelTreeListener)this.syncListener);
        }
        if (this.syncListener != null) {
            this.syncListener.dispose();
        }
        this.syncListener = null;
        if (o != null && o.isModified() && o.isActive()) {
            try {
                ((FolderImpl)o.getParent()).discardChildFile(o);
            }
            catch (XModelException e) {
                JspEditorPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        if (this.palettePage != null) {
            this.palettePage.dispose();
            this.palettePage = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (PalettePage.class == adapter) {
            if (this.palettePage == null) {
                this.palettePage = new PalettePageImpl();
            }
            return this.palettePage;
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            if (this.visualEditor != null) {
                if (this.outlinePage == null) {
                    this.outlinePage = (ConfigurableContentOutlinePage)this.visualEditor.getAdapter(adapter);
                }
                return this.outlinePage;
            }
        } else if (IPropertySheetPage.class.equals((Object)adapter)) {
            if (this.sourceEditor != null) {
                return this.sourceEditor.getAdapter(adapter);
            }
        } else if (adapter == EditorDescriptor.class) {
            return new EditorDescriptor(new String[]{"jsp", "html"});
        }
        if (this.sourceEditor != null) {
            return this.sourceEditor.getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public void nodeChanged(XModelTreeEvent event) {
        if (event.getModelObject() == this.getModelObject()) {
            this.setContentDescription(this.getEditorInput().getName());
            if (this.sourceEditor != null) {
                this.sourceEditor.updateModification();
            }
        }
    }

    public void structureChanged(XModelTreeEvent event) {
    }

    public void close(boolean save) {
        this.sourceEditor.close(save);
    }

    public void doRevertToSaved() {
        this.sourceEditor.doRevertToSaved();
    }

    public IAction getAction(String actionId) {
        return this.sourceEditor.getAction(actionId);
    }

    public IDocumentProvider getDocumentProvider() {
        return this.sourceEditor.getDocumentProvider();
    }

    public IRegion getHighlightRange() {
        return this.sourceEditor.getHighlightRange();
    }

    public ISelectionProvider getSelectionProvider() {
        return this.sourceEditor.getSelectionProvider();
    }

    public boolean isEditable() {
        return this.sourceEditor.isEditable();
    }

    public void removeActionActivationCode(String actionId) {
        this.sourceEditor.removeActionActivationCode(actionId);
    }

    public void resetHighlightRange() {
        this.sourceEditor.resetHighlightRange();
    }

    public void selectAndReveal(int offset, int length) {
        this.sourceEditor.selectAndReveal(offset, length);
    }

    public void setAction(String actionID, IAction action) {
        this.sourceEditor.setAction(actionID, action);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        this.sourceEditor.setActionActivationCode(actionId, activationCharacter, activationKeyCode, activationStateMask);
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
        this.sourceEditor.setHighlightRange(offset, length, moveCursor);
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        this.sourceEditor.showHighlightRangeOnly(showHighlightRangeOnly);
    }

    public boolean showsHighlightRangeOnly() {
        return this.sourceEditor.showsHighlightRangeOnly();
    }

    public VpeTaglibManager getTaglibManager() {
        if (this.sourceEditor != null && this.sourceEditor.getPageContext() instanceof VpeTaglibManager) {
            return (VpeTaglibManager)this.sourceEditor.getPageContext();
        }
        return null;
    }

    void updateTitle() {
        this.setPartName(this.getEditorInput().getName());
    }

    public void runDropCommand(String flavor, String data) {
        if (this.sourceEditor != null) {
            this.sourceEditor.runDropCommand(flavor, data);
        }
    }

    public void setStatusField(IStatusField field, String category) {
        if (this.sourceEditor != null) {
            this.sourceEditor.setStatusField(field, category);
        }
    }

    public boolean isEditorInputReadOnly() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isEditorInputReadOnly();
        }
        return false;
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        if (this.sourceEditor != null) {
            this.sourceEditor.addRulerContextMenuListener(listener);
        }
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        if (this.sourceEditor != null) {
            this.sourceEditor.removeRulerContextMenuListener(listener);
        }
    }

    public boolean isEditorInputModifiable() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isEditorInputModifiable();
        }
        return false;
    }

    public boolean validateEditorInputState() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.validateEditorInputState();
        }
        return false;
    }

    public ITextEditorExtension3.InsertMode getInsertMode() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.getInsertMode();
        }
        return null;
    }

    public void setInsertMode(ITextEditorExtension3.InsertMode mode) {
        if (this.sourceEditor != null) {
            this.sourceEditor.setInsertMode(mode);
        }
    }

    public void showChangeInformation(boolean show) {
        if (this.sourceEditor != null) {
            this.sourceEditor.showChangeInformation(show);
        }
    }

    public boolean isChangeInformationShowing() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.isChangeInformationShowing();
        }
        return false;
    }

    public INavigationLocation createEmptyNavigationLocation() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.createEmptyNavigationLocation();
        }
        return null;
    }

    public INavigationLocation createNavigationLocation() {
        if (this.sourceEditor != null) {
            return this.sourceEditor.createNavigationLocation();
        }
        return null;
    }

    public void updatePartAccordingToPreferences() {
        String tabIndex = JspEditorPlugin.getDefault().getPreferenceStore().getString("Default VPE Tab");
        try {
            int ind = Integer.parseInt(tabIndex);
            this.getTabFolder().setSelection(ind);
            this.pageChange(ind);
        }
        catch (NumberFormatException e) {
            JspEditorPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    public int getPreviewIndex() {
        return this.previewIndex;
    }

    public void setPreviewIndex(int previewIndex) {
        this.previewIndex = previewIndex;
    }

    public void setVisualSourceIndex(int visualSourceIndex) {
        this.visualSourceIndex = visualSourceIndex;
    }

    public int getVisualSourceIndex() {
        return this.visualSourceIndex;
    }

    class PCL
    implements IPropertyListener {
        PCL() {
        }

        public void propertyChanged(Object source, int i) {
            JSPMultiPageEditor.this.firePropertyChange(i);
            if (i == 258 && JSPMultiPageEditor.this.getEditorInput() != JSPMultiPageEditor.this.sourceEditor.getEditorInput()) {
                JSPMultiPageEditor.this.setInput(JSPMultiPageEditor.this.sourceEditor.getEditorInput());
                JSPMultiPageEditor.this.setPartName(JSPMultiPageEditor.this.sourceEditor.getPartName());
                JSPMultiPageEditor.this.setTitleToolTip(JSPMultiPageEditor.this.sourceEditor.getTitleToolTip());
            }
        }
    }
}

