/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.contentassist;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELCompletionEngine;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELContextImpl;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolutionImpl;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.Var;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.jst.jsp.contentassist.AbstractXMLContentAssistProcessor;
import org.jboss.tools.jst.jsp.contentassist.AutoContentAssistantProposal;
import org.jboss.tools.jst.jsp.contentassist.XmlContentAssistProcessor;
import org.jboss.tools.jst.web.kb.IPageContext;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.jboss.tools.jst.web.kb.PageProcessor;
import org.jboss.tools.jst.web.kb.taglib.INameSpace;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JspContentAssistProcessor
extends XmlContentAssistProcessor {
    protected ELContext createContext() {
        return PageContextFactory.createPageContext((IFile)this.getResource(), (String)"JSP_PAGE_CONTEXT_TYPE");
    }

    public IPageContext getContext() {
        return (IPageContext)super.getContext();
    }

    public String getUri(String prefix) {
        if (prefix == null) {
            return null;
        }
        Map nameSpaces = this.getContext().getNameSpaces(this.getOffset());
        if (nameSpaces == null || nameSpaces.isEmpty()) {
            return null;
        }
        for (List nameSpace : nameSpaces.values()) {
            for (INameSpace n : nameSpace) {
                if (!prefix.equals(n.getPrefix())) continue;
                return n.getURI();
            }
        }
        return null;
    }

    protected boolean isExistingAttribute(String attrName) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            IDOMDocument xmlDocument;
            if (sModel == null) {
                return false;
            }
            IDOMDocument iDOMDocument = xmlDocument = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
            if (xmlDocument == null) {
                return false;
            }
            IStructuredDocumentRegion sdFixedRegion = this.getStructuredDocumentRegion(this.getOffset());
            if (sdFixedRegion == null) {
                return false;
            }
            Node n = this.findNodeForOffset((Node)xmlDocument, sdFixedRegion.getStartOffset());
            if (n == null) {
                return false;
            }
            if (!(n instanceof Element)) {
                if (n instanceof Attr) {
                    n = ((Attr)n).getOwnerElement();
                } else {
                    return false;
                }
            }
            if (n == null) {
                return false;
            }
            boolean bl = ((Element)n).getAttribute(attrName) != null;
            return bl;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        AbstractXMLContentAssistProcessor.TextRegion prefix = this.getELPrefix(contentAssistRequest);
        if (prefix != null && prefix.isELStarted()) {
            return;
        }
        this.addTagNameProposals(contentAssistRequest, childPosition, true);
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest) {
        String matchString = contentAssistRequest.getMatchString();
        String query = matchString;
        if (query == null) {
            query = "";
        }
        String stringQuery = matchString;
        KbQuery kbQuery = this.createKbQuery(KbQuery.Type.ATTRIBUTE_NAME, query, stringQuery);
        TextProposal[] proposals = PageProcessor.getInstance().getProposals(kbQuery, (ELContext)this.getContext());
        int i = 0;
        while (proposals != null && i < proposals.length) {
            TextProposal textProposal = proposals[i];
            if (!this.isExistingAttribute(textProposal.getLabel())) {
                String replacementString = String.valueOf(textProposal.getReplacementString()) + "=\"\"";
                int replacementOffset = contentAssistRequest.getReplacementBeginPosition();
                int replacementLength = contentAssistRequest.getReplacementLength();
                int cursorPosition = this.getCursorPositionForProposedText(replacementString);
                Image image = textProposal.getImage();
                if (image == null) {
                    image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/attribute_obj.gif");
                }
                String displayString = textProposal.getLabel() == null ? replacementString : textProposal.getLabel();
                IContextInformation contextInformation = null;
                String additionalProposalInfo = textProposal.getContextInfo();
                int relevance = textProposal.getRelevance();
                AutoContentAssistantProposal proposal = new AutoContentAssistantProposal(true, replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, relevance);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
            ++i;
        }
    }

    protected void addTextELProposals(ContentAssistRequest contentAssistRequest) {
    }

    protected void setVars(ELContextImpl context, IFile file) {
        ELCompletionEngine fakeEngine = new ELCompletionEngine(){

            public ELResolution resolveELOperand(IFile file, ELExpression operand, boolean returnEqualedVariablesOnly, List<Var> vars, ElVarSearcher varSearcher) throws BadLocationException, StringIndexOutOfBoundsException {
                return new ELResolutionImpl(operand);
            }

            public ELParserFactory getParserFactory() {
                return ELParserUtil.getJbossFactory();
            }

            public List<TextProposal> getProposals(ELContext context, String el, int offset) {
                return Collections.emptyList();
            }

            public ELResolution resolve(ELContext context, ELExpression operand, int offset) {
                return new ELResolutionImpl(operand);
            }

            public List<TextProposal> getProposals(ELContext context, int offset) {
                return Collections.emptyList();
            }
        };
        ElVarSearcher varSearcher = new ElVarSearcher(file, fakeEngine);
        List vars = varSearcher.findAllVars(file, this.getOffset());
        if (vars != null) {
            for (Var var : vars) {
                context.addVar(new Region(this.getOffset(), 0), var);
            }
        }
    }
}

