/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp.contentassist;

import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELUtil;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.jst.jsp.contentassist.AutoContentAssistantProposal;
import org.jboss.tools.jst.web.kb.KbQuery;
import org.jboss.tools.jst.web.kb.internal.KbProject;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractXMLContentAssistProcessor
extends AbstractContentAssistProcessor {
    private static final char[] PROPOSAL_AUTO_ACTIVATION_CHARS = new char[]{'<', '=', '\"', '\'', '.', '{'};
    private IDocument fDocument;
    private int fDocumentPosition;
    private ELContext fContext;
    protected static final ICompletionProposal[] EMPTY_PROPOSAL_LIST = new ICompletionProposal[0];
    private static final String[] EMPTY_TAGS = new String[0];

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        this.fDocument = viewer == null ? null : viewer.getDocument();
        this.fDocumentPosition = offset;
        this.fContext = this.createContext();
        IFile resource = this.fContext == null ? null : this.fContext.getResource();
        KbProject.checkKBBuilderInstalled((IResource)resource);
        return super.computeCompletionProposals(viewer, offset);
    }

    public IStructuredDocumentRegion getStructuredDocumentRegion(int pos) {
        IStructuredDocumentRegion sdRegion = null;
        if (this.fDocument == null) {
            return null;
        }
        int lastOffset = pos;
        IStructuredDocument doc = (IStructuredDocument)this.fDocument;
        do {
            ITextRegion region;
            if ((sdRegion = doc.getRegionAtCharacterOffset(lastOffset)) == null || (region = sdRegion.getRegionAtCharacterOffset(lastOffset)) == null || region.getType() != "XML_TAG_OPEN" || sdRegion.getStartOffset(region) != lastOffset) continue;
            if (sdRegion.getStartOffset(region) == sdRegion.getStartOffset() && sdRegion.getPrevious() != null && !sdRegion.getPrevious().isEnded()) {
                sdRegion = null;
                continue;
            }
            ITextRegion previousRegion = sdRegion.getRegionAtCharacterOffset(lastOffset - 1);
            if (previousRegion == null || previousRegion == region || previousRegion.getTextLength() != previousRegion.getLength()) continue;
            sdRegion = null;
        } while (sdRegion == null && --lastOffset >= 0);
        return sdRegion;
    }

    protected ITextRegion getCompletionRegion(int documentPosition, Node domnode) {
        Node prevnode;
        if (domnode == null) {
            return null;
        }
        IStructuredDocumentRegion sdNormalRegion = super.getStructuredDocumentRegion(documentPosition);
        IStructuredDocumentRegion sdFixedRegion = this.getStructuredDocumentRegion(documentPosition);
        if (sdFixedRegion != null && !sdFixedRegion.equals(sdNormalRegion) && (prevnode = domnode.getParentNode()) != null) {
            domnode = prevnode;
        }
        return super.getCompletionRegion(documentPosition, domnode);
    }

    protected ITextRegion getCompletionRegion(int offset, IStructuredDocumentRegion sdRegion) {
        ITextRegion previousRegion;
        ITextRegion region = super.getCompletionRegion(offset, sdRegion);
        if (region != null && region.getType() == "UNDEFINED" && (previousRegion = sdRegion.getRegionAtCharacterOffset(offset - 1)) != null && previousRegion != region && previousRegion.getTextLength() < previousRegion.getLength()) {
            region = previousRegion;
        }
        return region;
    }

    protected ContentAssistRequest computeTagNameProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = null;
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (sdRegion != nodeAtOffset.getFirstStructuredDocumentRegion()) {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(sdRegion.getStartOffset(completionRegion));
            if (actualNode != null) {
                if (actualNode.getFirstStructuredDocumentRegion() == sdRegion) {
                    if (documentPosition >= sdRegion.getStartOffset(completionRegion) + completionRegion.getLength() && documentPosition > sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength()) {
                        contentAssistRequest = this.newContentAssistRequest((Node)actualNode, (Node)actualNode, sdRegion, completionRegion, documentPosition - matchString.length(), matchString.length(), matchString);
                        if (node.getStructuredDocument().getRegionAtCharacterOffset(sdRegion.getStartOffset(completionRegion) - 1).getRegionAtCharacterOffset(sdRegion.getStartOffset(completionRegion) - 1).getType() == "XML_TAG_OPEN") {
                            this.addAttributeNameProposals(contentAssistRequest);
                        }
                        this.addTagCloseProposals(contentAssistRequest);
                    } else {
                        contentAssistRequest = this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition - matchString.length(), matchString.length(), matchString);
                        this.addTagNameProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)actualNode));
                    }
                } else {
                    contentAssistRequest = documentPosition >= sdRegion.getStartOffset(completionRegion) + completionRegion.getLength() ? this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString) : this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
                    this.addEndTagNameProposals(contentAssistRequest);
                }
            }
        } else if (documentPosition > sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength()) {
            contentAssistRequest = this.newContentAssistRequest((Node)nodeAtOffset, (Node)node, sdRegion, completionRegion, documentPosition - matchString.length(), matchString.length(), matchString);
            this.addAttributeNameProposals(contentAssistRequest);
            this.addTagCloseProposals(contentAssistRequest);
        } else if (sdRegion.getRegions().get(0).getType() != "XML_END_TAG_OPEN") {
            int replaceLength = documentPosition - sdRegion.getStartOffset(completionRegion);
            contentAssistRequest = this.newContentAssistRequest((Node)node, node.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), replaceLength, matchString);
            this.addTagNameProposals(contentAssistRequest, this.getElementPositionForModelQuery((Node)nodeAtOffset));
        } else {
            IDOMNode actualNode = (IDOMNode)node.getModel().getIndexedRegion(documentPosition);
            if (actualNode != null) {
                contentAssistRequest = documentPosition >= sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() ? this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, matchString) : this.newContentAssistRequest((Node)actualNode, actualNode.getParentNode(), sdRegion, completionRegion, sdRegion.getStartOffset(completionRegion), completionRegion.getTextLength(), matchString);
                this.addEndTagNameProposals(contentAssistRequest);
            }
        }
        return contentAssistRequest;
    }

    private int getElementPositionForModelQuery(Node child) {
        return this.getElementPosition(child);
    }

    public void createContext(ITextViewer viewer, int offset) {
        this.fDocument = viewer == null ? null : viewer.getDocument();
        this.fDocumentPosition = offset;
        this.fContext = this.createContext();
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        this.fDocument = viewer == null ? null : viewer.getDocument();
        this.fDocumentPosition = offset;
        this.fContext = this.createContext();
        return super.computeContextInformation(viewer, offset);
    }

    protected String getMatchString(IStructuredDocumentRegion parent, ITextRegion aRegion, int offset) {
        if (aRegion == null) {
            return "";
        }
        String matchString = super.getMatchString(parent, aRegion, offset);
        String regionType = aRegion.getType();
        if (regionType == "XML_TAG_ATTRIBUTE_VALUE" && matchString.startsWith("\"")) {
            matchString = matchString.substring(1);
        }
        return matchString;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return PROPOSAL_AUTO_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return super.getContextInformationAutoActivationCharacters();
    }

    public IContextInformationValidator getContextInformationValidator() {
        return super.getContextInformationValidator();
    }

    public String getErrorMessage() {
        return super.getErrorMessage();
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest) {
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
    }

    protected void addCommentProposal(ContentAssistRequest contentAssistRequest) {
    }

    protected void addDocTypeProposal(ContentAssistRequest contentAssistRequest) {
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest) {
    }

    protected void addEndTagNameProposals(ContentAssistRequest contentAssistRequest) {
    }

    protected void addEndTagProposals(ContentAssistRequest contentAssistRequest) {
    }

    protected void addEntityProposals(ContentAssistRequest contentAssistRequest, int documentPosition, ITextRegion completionRegion, IDOMNode treeNode) {
        super.addEntityProposals(contentAssistRequest, documentPosition, completionRegion, treeNode);
    }

    protected void addPCDATAProposal(String nodeName, ContentAssistRequest contentAssistRequest) {
    }

    protected void addStartDocumentProposals(ContentAssistRequest contentAssistRequest) {
    }

    protected void addTagCloseProposals(ContentAssistRequest contentAssistRequest) {
        IDOMNode node = (IDOMNode)contentAssistRequest.getParent();
        if (node.getNodeType() == 1) {
            int contentType = 0;
            boolean endWithSlashBracket = this.getXML((Node)node) && contentType != 2;
            Image image = XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
            if (contentAssistRequest.getDocumentRegion() == node.getFirstStructuredDocumentRegion() && !node.getFirstStructuredDocumentRegion().isEnded()) {
                this.setErrorMessage(null);
                AutoContentAssistantProposal proposal = new AutoContentAssistantProposal(true, ">", this.getOffset(), 0, 2, image, NLS.bind((String)XMLUIMessages.Close_with__, (Object[])new Object[]{" '>'"}), null, null, 1550);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
                if (node.getEndStructuredDocumentRegion() == null) {
                    String openingTagText;
                    IStructuredDocumentRegion sdr = contentAssistRequest.getDocumentRegion();
                    String string = openingTagText = sdr != null ? sdr.getFullText() : "";
                    if (openingTagText != null && openingTagText.indexOf(node.getNodeName()) != -1) {
                        proposal = new AutoContentAssistantProposal(true, "></" + node.getNodeName() + ">", this.getOffset(), 0, 1, image, NLS.bind((String)XMLUIMessages.Close_with____, (Object[])new Object[]{node.getNodeName()}), null, null, 1550);
                        contentAssistRequest.addProposal((ICompletionProposal)proposal);
                    }
                }
                if (endWithSlashBracket) {
                    proposal = new AutoContentAssistantProposal(true, "/>", this.getOffset(), 0, 1, image, NLS.bind((String)XMLUIMessages.Close_with__, (Object[])new Object[]{" \"/>\""}), null, null, 1551);
                    contentAssistRequest.addProposal((ICompletionProposal)proposal);
                }
            } else if (contentAssistRequest.getDocumentRegion() == node.getLastStructuredDocumentRegion() && !node.getLastStructuredDocumentRegion().isEnded()) {
                this.setErrorMessage(null);
                AutoContentAssistantProposal proposal = new AutoContentAssistantProposal(true, ">", this.getOffset(), 0, 1, image, NLS.bind((String)XMLUIMessages.Close_with__, (Object[])new Object[]{" '>'"}), null, null, 1550);
                contentAssistRequest.addProposal((ICompletionProposal)proposal);
            }
        } else if (node.getNodeType() == 9) {
            this.setErrorMessage(UNKNOWN_CONTEXT);
        }
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
    }

    protected abstract void addTagNameProposals(ContentAssistRequest var1, int var2);

    protected abstract void addAttributeValueELProposals(ContentAssistRequest var1);

    protected abstract void addTextELProposals(ContentAssistRequest var1);

    protected ContentAssistRequest computeCompletionProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode treeNode, IDOMNode xmlnode) {
        ContentAssistRequest contentAssistRequest = super.computeCompletionProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
        if (contentAssistRequest == null) {
            IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
            contentAssistRequest = this.newContentAssistRequest((Node)treeNode, treeNode.getParentNode(), sdRegion, completionRegion, documentPosition, 0, "");
        }
        String regionType = completionRegion.getType();
        if (xmlnode.getNodeType() == 1 || xmlnode.getNodeType() == 9) {
            if (regionType == "XML_EMPTY_TAG_CLOSE") {
                this.addAttributeNameProposals(contentAssistRequest);
            } else if (regionType == "XML_CONTENT" || regionType == "XML_CHAR_REFERENCE" || regionType == "XML_ENTITY_REFERENCE" || regionType == "XML_PE_REFERENCE" || regionType == "BLOCK_TEXT" || regionType == "XML_END_TAG_OPEN") {
                this.addTextELProposals(contentAssistRequest);
            }
        }
        return contentAssistRequest;
    }

    protected ContentAssistRequest computeAttributeValueProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode nodeAtOffset, IDOMNode node) {
        ContentAssistRequest contentAssistRequest = super.computeAttributeValueProposals(documentPosition, matchString, completionRegion, nodeAtOffset, node);
        IStructuredDocumentRegion sdRegion = this.getStructuredDocumentRegion(documentPosition);
        if (!(documentPosition > sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() && sdRegion.getStartOffset(completionRegion) + completionRegion.getTextLength() != sdRegion.getStartOffset(completionRegion) + completionRegion.getLength() || !nodeAtOffset.getFirstStructuredDocumentRegion().isEnded() && documentPosition < sdRegion.getStartOffset(completionRegion))) {
            this.addAttributeValueELProposals(contentAssistRequest);
        }
        return contentAssistRequest;
    }

    protected abstract ELContext createContext();

    protected abstract KbQuery createKbQuery(KbQuery.Type var1, String var2, String var3);

    protected abstract KbQuery createKbQuery(KbQuery.Type var1, String var2, String var3, String var4, String var5);

    protected ELContext getContext() {
        return this.fContext;
    }

    protected int getOffset() {
        return this.fDocumentPosition;
    }

    protected IDocument getDocument() {
        return this.fDocument;
    }

    protected IFile getResource() {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            if (sModel != null) {
                String baseLocation = sModel.getBaseLocation();
                IPath location = new Path(baseLocation).makeAbsolute();
                IFile iFile = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
                return iFile;
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return null;
    }

    protected ELResolver[] getELResolvers(IResource resource) {
        if (resource == null) {
            return null;
        }
        ELResolverFactoryManager elrfm = ELResolverFactoryManager.getInstance();
        return elrfm.getResolvers(resource);
    }

    public String[] getParentTags(boolean includeThisTag) {
        ArrayList<String> parentTags = new ArrayList<String>();
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            IDOMDocument xmlDocument;
            if (sModel == null) {
                String[] stringArray = EMPTY_TAGS;
                return stringArray;
            }
            IDOMDocument iDOMDocument = xmlDocument = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
            if (xmlDocument == null) {
                String[] stringArray = EMPTY_TAGS;
                return stringArray;
            }
            Node n = null;
            if (includeThisTag) {
                n = this.findNodeForOffset((Node)xmlDocument, this.getOffset());
            } else {
                IStructuredDocumentRegion sdFixedRegion = this.getStructuredDocumentRegion(this.getOffset());
                if (sdFixedRegion == null) {
                    String[] stringArray = EMPTY_TAGS;
                    return stringArray;
                }
                n = this.findNodeForOffset((Node)xmlDocument, sdFixedRegion.getStartOffset());
            }
            if (n == null) {
                String[] stringArray = EMPTY_TAGS;
                return stringArray;
            }
            if (!(n instanceof Element)) {
                n = n instanceof Attr ? ((Attr)n).getOwnerElement() : n.getParentNode();
            } else if (!includeThisTag) {
                n = n.getParentNode();
            }
            while (n != null && n instanceof Element) {
                String tagName = this.getTagName(n);
                parentTags.add(0, tagName);
                n = n.getParentNode();
            }
            String[] stringArray = parentTags.toArray(new String[parentTags.size()]);
            return stringArray;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    protected String getTagName(Node tag) {
        return tag.getNodeName();
    }

    protected String getParent(boolean returnAttributeName, boolean returnThisElement) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            IDOMDocument xmlDocument;
            if (sModel == null) {
                return null;
            }
            IDOMDocument iDOMDocument = xmlDocument = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
            if (xmlDocument == null) {
                return null;
            }
            Node n = null;
            if (returnAttributeName) {
                n = this.findNodeForOffset((Node)xmlDocument, this.getOffset());
            }
            IStructuredDocumentRegion sdFixedRegion = this.getStructuredDocumentRegion(this.getOffset());
            if (sdFixedRegion == null) {
                return null;
            }
            n = this.findNodeForOffset((Node)xmlDocument, sdFixedRegion.getStartOffset());
            return n;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    public String getTagPrefix() {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            String nodePrefix;
            IDOMDocument xmlDocument;
            if (sModel == null) {
                return null;
            }
            IDOMDocument iDOMDocument = xmlDocument = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
            if (xmlDocument == null) {
                return null;
            }
            IStructuredDocumentRegion sdFixedRegion = this.getStructuredDocumentRegion(this.getOffset());
            if (sdFixedRegion == null) {
                return null;
            }
            Node n = this.findNodeForOffset((Node)xmlDocument, sdFixedRegion.getStartOffset());
            if (n == null) {
                return null;
            }
            if (!(n instanceof Element) && !(n instanceof Attr)) {
                return null;
            }
            if (n instanceof Attr) {
                n = ((Attr)n).getOwnerElement();
            }
            if (n == null) {
                return null;
            }
            String string = nodePrefix = ((Element)n).getPrefix();
            return string;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    public String getTagUri() {
        String nodePrefix = this.getTagPrefix();
        return this.getUri(nodePrefix);
    }

    protected abstract String getUri(String var1);

    Node findNodeForOffset(IDOMNode node, int offset) {
        int i;
        if (node == null) {
            return null;
        }
        if (!node.contains(offset)) {
            return null;
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            i = 0;
            while (children != null && i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if (child.contains(offset)) {
                    return this.findNodeForOffset(child, offset);
                }
                ++i;
            }
        }
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            i = 0;
            while (attributes != null && i < attributes.getLength()) {
                IDOMNode attr = (IDOMNode)attributes.item(i);
                if (attr.contains(offset)) {
                    return attr;
                }
                ++i;
            }
        }
        return node;
    }

    Node findNodeForOffset(Node node, int offset) {
        return node instanceof IDOMNode ? this.findNodeForOffset((IDOMNode)node, offset) : null;
    }

    protected int getCursorPositionForProposedText(String proposedText) {
        int cursorAdjustment = proposedText.indexOf("\"\"") + 1;
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.indexOf(62) + 1;
        }
        if (cursorAdjustment == 0) {
            cursorAdjustment = proposedText.length();
        }
        return cursorAdjustment;
    }

    protected TextRegion getELPrefix(ContentAssistRequest request) {
        if (!("XML_TAG_ATTRIBUTE_VALUE".equals(request.getRegion().getType()) || "XML_CONTENT".equals(request.getRegion().getType()) || "BLOCK_TEXT".equals(request.getRegion().getType()))) {
            return null;
        }
        String text = request.getDocumentRegion().getFullText(request.getRegion());
        int startOffset = request.getDocumentRegion().getStartOffset() + request.getRegion().getStart();
        boolean isAttributeValue = false;
        boolean hasOpenQuote = false;
        boolean hasCloseQuote = false;
        char quoteChar = '\u0000';
        if ("XML_TAG_ATTRIBUTE_VALUE".equals(request.getRegion().getType())) {
            isAttributeValue = true;
            if (text.startsWith("\"") || text.startsWith("'")) {
                quoteChar = text.charAt(0);
                hasOpenQuote = true;
            }
            if (hasOpenQuote && text.trim().endsWith(String.valueOf(quoteChar))) {
                hasCloseQuote = true;
            }
        }
        int inValueOffset = this.getOffset() - startOffset;
        if (text != null && text.length() < inValueOffset) {
            return null;
        }
        if (inValueOffset < 0) {
            return null;
        }
        ELParser p = ELParserUtil.getJbossFactory().createParser();
        ELModel model = p.parse(text);
        ELInstance is = ELUtil.findInstance((ELModel)model, (int)inValueOffset);
        ELInvocationExpression ie = ELUtil.findExpression((ELModel)model, (int)inValueOffset);
        boolean isELStarted = model != null && is != null && (model.toString().startsWith("#{") || model.toString().startsWith("${"));
        boolean isELClosed = model != null && is != null && model.toString().endsWith("}");
        TextRegion tr = new TextRegion(startOffset, ie == null ? inValueOffset : ie.getStartPosition(), ie == null ? 0 : inValueOffset - ie.getStartPosition(), ie == null ? "" : ie.getText(), isELStarted, isELClosed, isAttributeValue, hasOpenQuote, hasCloseQuote, quoteChar);
        return tr;
    }

    protected TextRegion getELPredicatePrefix(ContentAssistRequest request) {
        int inValueOffset;
        if (request == null || request.getRegion() == null) {
            return null;
        }
        IStructuredDocumentRegion documentRegion = request.getDocumentRegion();
        ITextRegion completionRegion = request.getRegion();
        String regionType = completionRegion.getType();
        if ("XML_END_TAG_OPEN".equals(regionType) || "XML_TAG_OPEN".equals(regionType)) {
            documentRegion = documentRegion.getPrevious();
            completionRegion = this.getCompletionRegion(request.getDocumentRegion().getStartOffset() + request.getRegion().getStart() - 1, request.getParent());
        }
        if (!("XML_TAG_ATTRIBUTE_VALUE".equals(completionRegion.getType()) || "XML_CONTENT".equals(completionRegion.getType()) || "BLOCK_TEXT".equals(completionRegion.getType()))) {
            return null;
        }
        String text = documentRegion.getFullText(completionRegion);
        int startOffset = documentRegion.getStartOffset() + completionRegion.getStart();
        boolean isAttributeValue = false;
        boolean hasOpenQuote = false;
        boolean hasCloseQuote = false;
        char quoteChar = '\u0000';
        if ("XML_TAG_ATTRIBUTE_VALUE".equals(request.getRegion().getType())) {
            isAttributeValue = true;
            if (text.startsWith("\"") || text.startsWith("'")) {
                quoteChar = text.charAt(0);
                hasOpenQuote = true;
            }
            if (hasOpenQuote && text.trim().endsWith(String.valueOf(quoteChar))) {
                hasCloseQuote = true;
            }
        }
        if ((inValueOffset = this.getOffset() - startOffset) < 0 || text != null && text.length() < inValueOffset) {
            return null;
        }
        String matchString = this.getELPredicateMatchString(text, inValueOffset);
        if (matchString == null) {
            return null;
        }
        TextRegion tr = new TextRegion(startOffset, this.getOffset() - matchString.length() - startOffset, matchString.length(), matchString, false, false, isAttributeValue, hasOpenQuote, hasCloseQuote, quoteChar);
        return tr;
    }

    protected String getELPredicateMatchString(String text, int offset) {
        int beginningOffset = offset - 1;
        while (beginningOffset >= 0 && (Character.isJavaIdentifierPart(text.charAt(beginningOffset)) || '.' == text.charAt(beginningOffset) || '_' == text.charAt(beginningOffset))) {
            --beginningOffset;
        }
        return text.substring(++beginningOffset, offset);
    }

    protected TextRegion getELPrefix() {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
        try {
            TextRegion tr;
            IDOMDocument xmlDocument;
            if (sModel == null) {
                return null;
            }
            IDOMDocument iDOMDocument = xmlDocument = sModel instanceof IDOMModel ? ((IDOMModel)sModel).getDocument() : null;
            if (xmlDocument == null) {
                return null;
            }
            Node n = this.findNodeForOffset((Node)xmlDocument, this.getOffset());
            if (n == null) {
                return null;
            }
            String text = null;
            ITextRegion region = null;
            int startOffset = -1;
            int offset = this.getOffset();
            while (n != null && startOffset == -1) {
                IDOMElement elem;
                if (n instanceof IDOMAttr) {
                    text = ((IDOMAttr)n).getValueRegionText();
                    region = ((IDOMAttr)n).getValueRegion();
                    startOffset = ((IndexedRegion)((IDOMAttr)n).getOwnerElement()).getStartOffset();
                    if (region != null) {
                        startOffset += region.getStart();
                        continue;
                    }
                    region = ((IDOMAttr)n).getEqualRegion();
                    if (region != null) {
                        startOffset += region.getStart() + region.getLength();
                        continue;
                    }
                    startOffset = ((IDOMAttr)n).getEndOffset();
                    continue;
                }
                if (n instanceof IDOMText) {
                    text = ((IDOMText)n).getNodeValue();
                    region = ((IDOMText)n).getFirstStructuredDocumentRegion();
                    startOffset = ((IDOMText)n).getStartOffset();
                    continue;
                }
                if (n instanceof IDOMElement && ((elem = (IDOMElement)n).hasEndTag() && elem.getEndStartOffset() == offset || elem.getStartOffset() == offset)) {
                    n = this.findNodeForOffset((Node)xmlDocument, --offset);
                    continue;
                }
                return null;
            }
            int inValueOffset = this.getOffset() - startOffset;
            if (text != null && text.length() < inValueOffset) {
                return null;
            }
            if (inValueOffset < 0) {
                return null;
            }
            ELParser p = ELParserUtil.getJbossFactory().createParser();
            ELModel model = p.parse(text);
            ELInstance is = ELUtil.findInstance((ELModel)model, (int)inValueOffset);
            ELInvocationExpression ie = ELUtil.findExpression((ELModel)model, (int)inValueOffset);
            boolean isELStarted = model != null && is != null && (model.toString().startsWith("#{") || model.toString().startsWith("${"));
            boolean isELClosed = model != null && is != null && model.toString().endsWith("}");
            TextRegion textRegion = tr = new TextRegion(startOffset, ie == null ? inValueOffset : ie.getStartPosition(), ie == null ? 0 : inValueOffset - ie.getStartPosition(), ie == null ? "" : ie.getText(), isELStarted, isELClosed);
            return textRegion;
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    public static class TextRegion {
        private int startOffset;
        private int offset;
        private int length;
        private String text;
        private boolean isELStarted;
        private boolean isELClosed;
        private boolean isAttributeValue;
        private boolean hasOpenQuote;
        private boolean hasCloseQuote;
        private char quoteChar;

        TextRegion(int startOffset, int offset, int length, String text, boolean isELStarted, boolean isELClosed) {
            this(startOffset, offset, length, text, isELStarted, isELClosed, false, false, false, '\u0000');
        }

        public TextRegion(int startOffset, int offset, int length, String text, boolean isELStarted, boolean isELClosed, boolean isAttributeValue, boolean hasOpenQuote, boolean hasCloseQuote, char quoteChar) {
            this.startOffset = startOffset;
            this.offset = offset;
            this.length = length;
            this.text = text;
            this.isELStarted = isELStarted;
            this.isELClosed = isELClosed;
            this.isAttributeValue = isAttributeValue;
            this.hasOpenQuote = hasOpenQuote;
            this.hasCloseQuote = hasCloseQuote;
            this.quoteChar = quoteChar;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getText() {
            StringBuffer sb = new StringBuffer(this.length);
            sb = sb.append(this.text.substring(0, this.length));
            sb.setLength(this.length);
            return sb.toString();
        }

        public boolean isELStarted() {
            return this.isELStarted;
        }

        public boolean isELClosed() {
            return this.isELClosed;
        }

        public boolean isAttributeValue() {
            return this.isAttributeValue;
        }

        public char getQuoteChar() {
            return this.quoteChar;
        }

        public boolean hasOpenQuote() {
            return this.hasOpenQuote;
        }

        public boolean hasCloseQuote() {
            return this.hasCloseQuote;
        }
    }
}

