/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jboss.tools.common.log.BaseUIPlugin;
import org.jboss.tools.common.log.IPluginLog;
import org.jboss.tools.common.text.xml.XmlEditorPlugin;
import org.jboss.tools.jst.jsp.preferences.JSPOccurrencePreferenceConstants;
import org.osgi.framework.Bundle;

public class JspEditorPlugin
extends BaseUIPlugin {
    private static JspEditorPlugin plugin;
    public static final String PLUGIN_ID = "org.jboss.tools.jst.jsp";
    public static final String RESOURCES_PATH = "/resources";
    private HashMap fImageDescRegistry = null;
    public static final String CA_JSF_ACTION_IMAGE_PATH = "images/ca/icons_JSF_Actions.gif";
    public static final String CA_JSF_EL_IMAGE_PATH = "images/ca/icons_JSF_EL.gif";
    public static final String CA_RESOURCES_IMAGE_PATH = "images/ca/icons_Resource_path.gif";
    public static final String CA_JSF_MESSAGES_IMAGE_PATH = "images/ca/icons_Message_Bundles.gif";

    public JspEditorPlugin() {
        plugin = this;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void startup() throws CoreException {
        super.startup();
        Platform.getPlugin((String)"org.jboss.tools.jst.web.debug.ui");
    }

    protected void initializeDefaultPluginPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        JSPOccurrencePreferenceConstants.initializeDefaultValues(store);
    }

    public void initDefaultPluginPreferences() {
        IPreferenceStore store = JSPUIPlugin.getDefault().getPreferenceStore();
        JSPOccurrencePreferenceConstants.initializeDefaultValues(store);
    }

    public synchronized JavaTextTools getJavaTextTools() {
        return XmlEditorPlugin.getDefault().getJavaTextTools();
    }

    public static Path getInstallLocation() {
        try {
            URL url = JspEditorPlugin.getDefault().getDescriptor().getInstallURL();
            String s1 = FileLocator.resolve((URL)url).getFile();
            if (s1.startsWith("/")) {
                s1 = s1.substring(1);
            }
            String s = (s1 = new Path(s1).toOSString()).endsWith(File.separator) ? s1 : String.valueOf(s1) + File.separator;
            return new Path(s);
        }
        catch (Exception exception) {
            JspEditorPlugin.getDefault().logError(exception);
            return null;
        }
    }

    public static Shell getActiveShell() {
        if (plugin == null) {
            return null;
        }
        IWorkbench workBench = plugin.getWorkbench();
        if (workBench == null) {
            return null;
        }
        IWorkbenchWindow workBenchWindow = workBench.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static JspEditorPlugin getDefault() {
        return plugin;
    }

    public static boolean isDebugEnabled() {
        return JspEditorPlugin.getDefault().isDebugging();
    }

    public static IPluginLog getPluginLog() {
        return JspEditorPlugin.getDefault();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return JspEditorPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String getPluginResourcePath() {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        URL url = null;
        try {
            url = bundle == null ? null : FileLocator.resolve((URL)bundle.getEntry(RESOURCES_PATH));
        }
        catch (IOException iOException) {
            url = bundle.getEntry(RESOURCES_PATH);
        }
        return url == null ? null : url.getPath();
    }

    private Image createImage(String resource) {
        ImageDescriptor desc = this.getImageDescriptorFromRegistry(resource);
        Image image = null;
        if (desc != null) {
            image = desc.createImage();
            if (!desc.equals(ImageDescriptor.getMissingImageDescriptor())) {
                this.getImageRegistry().put(resource, image);
            }
        }
        return image;
    }

    private ImageDescriptor createImageDescriptor(String imageFilePath) {
        ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)imageFilePath);
        if (imageDescriptor != null) {
            this.getImageDescriptorRegistry().put(imageFilePath, imageDescriptor);
        } else {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }

    public Image getImage(String resource) {
        Image image = this.getImageRegistry().get(resource);
        if (image == null) {
            image = this.createImage(resource);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptorFromRegistry(String resource) {
        ImageDescriptor imageDescriptor = null;
        Object o = this.getImageDescriptorRegistry().get(resource);
        imageDescriptor = o == null ? this.createImageDescriptor(resource) : (ImageDescriptor)o;
        return imageDescriptor;
    }

    private HashMap getImageDescriptorRegistry() {
        if (this.fImageDescRegistry == null) {
            this.fImageDescRegistry = new HashMap();
        }
        return this.fImageDescRegistry;
    }
}

