/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.jsp;

import java.util.List;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.ExtendedConfigurationBuilder;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;
import org.jboss.tools.jst.jsp.ITextViewerConfiguration;
import org.jboss.tools.jst.jsp.TextHoverInformationProvider;
import org.jboss.tools.jst.jsp.TextViewerConfigurationDelegate;
import org.jboss.tools.jst.jsp.format.HTMLFormatProcessor;
import org.jboss.tools.jst.jsp.jspeditor.info.ChainTextHover;

public class HTMLTextViewerConfiguration
extends StructuredTextViewerConfigurationHTML
implements ITextViewerConfiguration {
    TextViewerConfigurationDelegate configurationDelegate = new TextViewerConfigurationDelegate(this);

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        return this.configurationDelegate.getContentAssistProcessors(sourceViewer, partitionType);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return this.configurationDelegate.getHyperlinkDetectors(sourceViewer, this.fPreferenceStore.getBoolean("hyperlinksEnabled"));
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter formatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "org.eclipse.wst.html.HTML_DEFAULT");
        formatter.setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new HTMLFormatProcessor()));
        return formatter;
    }

    public IContentAssistProcessor[] getContentAssistProcessorsForPartitionType(ISourceViewer sourceViewer, String partitionType) {
        return super.getContentAssistProcessors(sourceViewer, partitionType);
    }

    private ITextHover[] createDocumentationHovers(String partitionType) {
        List extendedTextHover = ExtendedConfigurationBuilder.getInstance().getConfigurations("documentationTextHover", partitionType);
        ITextHover[] hovers = extendedTextHover.toArray(new ITextHover[extendedTextHover.size()]);
        return hovers;
    }

    protected IInformationProvider getInformationProvider(ISourceViewer sourceViewer, String partitionType) {
        ChainTextHover chainTextHover = new ChainTextHover(this.createDocumentationHovers(partitionType));
        return new TextHoverInformationProvider(chainTextHover);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        Object textHover = null;
        TextHoverManager.TextHoverDescriptor[] hoverDescs = SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
        int i = 0;
        while (i < hoverDescs.length && textHover == null) {
            if (hoverDescs[i].isEnabled() && HTMLTextViewerConfiguration.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                ITextHover[] hovers;
                String hoverType = hoverDescs[i].getId();
                if ("problemHover".equalsIgnoreCase(hoverType)) {
                    textHover = new ProblemAnnotationHoverProcessor();
                } else if ("annotationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new AnnotationHoverProcessor();
                } else if ("combinationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new ChainTextHover(this.createDocumentationHovers(contentType));
                } else if ("documentationHover".equalsIgnoreCase(hoverType) && (hovers = this.createDocumentationHovers(contentType)).length > 0) {
                    textHover = hovers[0];
                }
            }
            ++i;
        }
        return textHover;
    }
}

