/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.xml.core.internal.validation.ValidatorHelper;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationConfiguration;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.XMLValidator;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.core.internal.validation.eclipse.ErrorCustomizationPluginRegistryReader;
import org.eclipse.wst.xml.core.internal.validation.eclipse.Validator;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.web.validation.XHTMLEntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class XHTMLSyntaxValidator
extends Validator {
    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context, ValidationResult result) {
        long ct = 0L;
        if (JSFModelPlugin.getDefault().isDebugging()) {
            ct = System.currentTimeMillis();
        }
        XMLValidator validator = XMLValidator.getInstance();
        XMLValidationConfiguration configuration = new XMLValidationConfiguration();
        try {
            configuration.setFeature(XMLValidationConfiguration.INDICATE_NO_GRAMMAR, 0);
        }
        catch (Exception e) {
            JSFModelPlugin.log("XHTMLSyntaxValidator was unable to set the preference", e);
        }
        XMLValidationReport valreport = null;
        valreport = inputstream != null ? validator.validate(uri, inputstream, configuration, context, result) : validator.validate(uri, null, configuration, context, result);
        if (JSFModelPlugin.getDefault().isDebugging()) {
            long et = System.currentTimeMillis() - ct;
            System.out.println("XHTMLSyntaxValidator: Elapsed time = " + et + " ms for " + uri);
        }
        return valreport;
    }

    public static class XMLValidator
    extends org.eclipse.wst.xml.core.internal.validation.XMLValidator {
        private static XMLValidator instance = null;

        public static XMLValidator getInstance() {
            if (instance == null) {
                instance = new XMLValidator();
            }
            return instance;
        }

        protected XMLValidator() {
            this.setURIResolver(URIResolverPlugin.createResolver());
            new ErrorCustomizationPluginRegistryReader().readRegistry();
        }

        public XMLValidationReport validate(String uri, InputStream inputStream, XMLValidationConfiguration configuration, NestedValidatorContext context, ValidationResult result) {
            String grammarFile = "";
            StringReader reader1 = null;
            StringReader reader2 = null;
            if (inputStream != null) {
                String string = this.createStringForInputStream(inputStream);
                reader1 = new StringReader(string);
                reader2 = new StringReader(string);
            }
            XMLValidationInfo valinfo = new XMLValidationInfo(uri);
            XHTMLEntityResolver entityResolver = new XHTMLEntityResolver(this.uriResolver, context);
            XHTMLValidatorHelper helper = new XHTMLValidatorHelper(entityResolver);
            try {
                helper.computeValidationInformation(uri, reader1, this.uriResolver);
                valinfo.setDTDEncountered(false);
                valinfo.setElementDeclarationCount(0);
                valinfo.setNamespaceEncountered(false);
                valinfo.setGrammarEncountered(false);
                if (!helper.isXHTMLDoctype) {
                    return valinfo;
                }
                XMLReader reader = this.createXMLReader(valinfo, entityResolver);
                XMLValidator.XMLErrorHandler errorhandler = new XMLValidator.XMLErrorHandler((org.eclipse.wst.xml.core.internal.validation.XMLValidator)this, valinfo);
                reader.setErrorHandler((ErrorHandler)errorhandler);
                InputSource inputSource = new InputSource(uri);
                inputSource.setCharacterStream(reader2);
                reader.parse(inputSource);
            }
            catch (SAXParseException sAXParseException) {
            }
            catch (IOException ioException) {
                this.addValidationMessage(valinfo, ioException);
            }
            catch (Exception exception) {
                JSFModelPlugin.log(exception.getLocalizedMessage(), exception);
            }
            if (result != null) {
                try {
                    IResource resource = this.getWorkspaceFileFromLocation(grammarFile);
                    ArrayList<IResource> resources = new ArrayList<IResource>();
                    if (resource != null) {
                        resources.add(resource);
                    }
                    result.setDependsOn(resources.toArray(new IResource[0]));
                }
                catch (Exception e) {
                    JSFModelPlugin.log(e.getLocalizedMessage(), e);
                }
            }
            return valinfo;
        }

        final String createStringForInputStream(InputStream inputStream) {
            StringBuffer fileString = new StringBuffer();
            try {
                InputStreamReader inputReader = new InputStreamReader(inputStream, "UTF-8");
                BufferedReader reader = new BufferedReader(inputReader);
                char[] chars = new char[1024];
                int numberRead = reader.read(chars);
                while (numberRead != -1) {
                    fileString.append(chars, 0, numberRead);
                    numberRead = reader.read(chars);
                }
            }
            catch (Exception e) {
                JSFModelPlugin.log(e.getLocalizedMessage(), e);
            }
            return fileString.toString();
        }

        class XHTMLValidatorHelper
        extends ValidatorHelper {
            public boolean isXHTMLDoctype = false;
            private XHTMLEntityResolver entityResolver;

            public XHTMLValidatorHelper(XHTMLEntityResolver entityResolver) {
                this.entityResolver = entityResolver;
            }

            protected XMLReader createXMLReader(String uri) throws Exception {
                XMLReader reader = super.createXMLReader(uri);
                reader.setFeature("http://xml.org/sax/features/namespaces", true);
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
                reader.setFeature("http://xml.org/sax/features/validation", true);
                reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
                reader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
                reader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
                LexicalHandler lexicalHandler = new LexicalHandler(){

                    public void startDTD(String name, String publicId, String systemId) {
                        XHTMLValidatorHelper.this.isGrammarEncountered = true;
                        XHTMLValidatorHelper.this.isDTDEncountered = true;
                        if (publicId != null && publicId.indexOf("W3C") != -1 && publicId.indexOf("DTD") != -1 && publicId.indexOf("XHTML") != -1) {
                            XHTMLValidatorHelper.this.isXHTMLDoctype = true;
                        }
                    }

                    public void endDTD() throws SAXException {
                    }

                    public void startEntity(String name) throws SAXException {
                    }

                    public void endEntity(String name) throws SAXException {
                    }

                    public void startCDATA() throws SAXException {
                    }

                    public void endCDATA() throws SAXException {
                    }

                    public void comment(char[] ch, int start, int length) throws SAXException {
                    }
                };
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
                if (this.entityResolver != null) {
                    reader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", this.entityResolver);
                }
                return reader;
            }
        }
    }
}

