/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.web.pattern;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.jsf.web.pattern.JSFUrlPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostfixUrlPattern
implements JSFUrlPattern {
    protected String postfix = ".jsf";
    protected String fileSuffix = ".jsp";
    protected String[] fileExtensions = new String[]{".jsp", ".xhtml", ".jspx"};

    public void setPostfix(String postfix) {
        this.postfix = postfix;
    }

    public void setFileSuffix(String s) {
        this.fileSuffix = s;
    }

    public void setFileExtentions(String[] fileExtentions) {
        this.fileExtensions = fileExtentions;
    }

    @Override
    public boolean matches(String path) {
        return path.endsWith(this.postfix);
    }

    @Override
    public boolean isJSFUrl(String path) {
        return path.endsWith(this.postfix) || path.endsWith(this.fileSuffix);
    }

    @Override
    public String getJSFPath(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        return url.endsWith(this.postfix) ? String.valueOf(url.substring(0, url.length() - this.postfix.length())) + this.fileSuffix : url;
    }

    @Override
    public List<String> getJSFPaths(String url) {
        ArrayList<String> jsfPathsList = new ArrayList<String>();
        if (url != null && url.length() > 0) {
            if (url.endsWith(this.postfix)) {
                String[] stringArray = this.fileExtensions;
                int n = this.fileExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    jsfPathsList.add(String.valueOf(url.substring(0, url.length() - this.postfix.length())) + extension);
                    ++n2;
                }
            } else {
                jsfPathsList.add(url);
            }
        }
        return jsfPathsList;
    }

    @Override
    public String getJSFUrl(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (!path.endsWith(this.postfix)) {
            int dot = path.lastIndexOf(46);
            if (dot >= 0) {
                path = path.substring(0, dot);
            }
            path = String.valueOf(path) + this.postfix;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public String toString() {
        return "PostfixUrlPattern:" + this.postfix;
    }
}

