/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.project.capabilities;

import java.io.Reader;
import java.io.StringReader;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XOrderedObject;
import org.jboss.tools.common.model.engines.impl.EnginesLoader;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.loaders.impl.SerializingLoader;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLEntityResolver;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.project.capabilities.PerformerContext;
import org.jboss.tools.jsf.project.capabilities.PerformerItem;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class FileAdditionPerformer
extends PerformerItem {
    XModelObject fileAddition;
    XModelObject configFile;
    String xPath;
    String preferredPosition;
    String text;
    Element element;
    XModelObject targetObject;
    String targetAttribute;
    String attributePath;
    XModelObject updateObject = null;
    String attributeValue = null;

    public String getDisplayName() {
        return this.fileAddition.getAttributeValue("label");
    }

    public void init(XModelObject configFile, XModelObject fileAddition) {
        this.fileAddition = fileAddition;
        this.configFile = configFile;
        this.xPath = fileAddition.getAttributeValue("x-path");
        this.preferredPosition = fileAddition.getAttributeValue("preferred position");
        this.text = fileAddition.getAttributeValue("text");
        this.targetObject = configFile;
    }

    void setConfigFile(XModelObject configFile) {
        this.configFile = configFile;
        this.targetObject = configFile;
    }

    public boolean check() {
        if (!this.isSelected()) {
            return true;
        }
        if (!this.scan(this.configFile, "")) {
            String path = XModelObjectLoaderUtil.getResourcePath((XModelObject)this.configFile);
            String message = "Cannot find x-path " + this.xPath + " in config file" + path + ".\n" + "Please correct file addition " + this.fileAddition.getAttributeValue("label") + ".";
            this.report(message);
            return false;
        }
        return this.parseText();
    }

    public boolean execute(PerformerContext context) throws XModelException {
        if (!this.isSelected()) {
            return true;
        }
        if (this.targetAttribute != null && this.attributeValue != null) {
            this.targetObject.getModel().editObjectAttribute(this.targetObject, this.targetAttribute, this.attributeValue);
        } else if (this.updateObject != null) {
            this.mergeAttributes(this.targetObject, this.updateObject);
            this.mergeChildren(this.targetObject, this.updateObject.getChildren());
        }
        String capability = this.fileAddition.getParent().getAttributeValue("name");
        context.changeList.add(capability + ": " + "Added \"" + this.getDisplayName() + "\" to " + this.fileAddition.getAttributeValue("file name"));
        context.monitor.worked(1);
        return true;
    }

    private boolean scan(XModelObject object, String xp) {
        String xml = object.getModelEntity().getXMLSubPath();
        if (xml == null || xml.length() == 0) {
            return this.scanChildren(object, xp);
        }
        if (!this.xPath.startsWith(xp = String.valueOf(xp) + "/" + xml)) {
            return false;
        }
        if (this.xPath.equals(xp)) {
            this.targetObject = object;
            this.targetAttribute = null;
            return true;
        }
        if (this.scanAttributes(object, xp)) {
            return true;
        }
        return this.scanChildren(object, xp);
    }

    private boolean scanAttributes(XModelObject object, String xp) {
        XAttribute[] as = object.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String xml = as[i].getXMLName();
            if (xml != null && xml.length() != 0) {
                int k;
                xml = (xml = xml.replace('.', '/')).endsWith("#text") ? String.valueOf(xml.substring(0, xml.length() - 5)) + "text()" : ((k = xml.lastIndexOf("/")) < 0 ? "@" + xml : String.valueOf(xml.substring(0, k + 1)) + "@" + xml.substring(k + 1));
                if ((xp = String.valueOf(xp) + "/" + xml).equals(this.xPath) || xp.startsWith(this.xPath)) {
                    this.targetObject = object;
                    this.targetAttribute = as[i].getName();
                    this.attributePath = null;
                    if (!xp.equals(this.xPath)) {
                        this.attributePath = xp.substring(this.xPath.length() + 1);
                        this.attributePath = this.attributePath.replace('/', '.');
                        if (this.attributePath.endsWith("text()")) {
                            this.attributePath = String.valueOf(this.attributePath.substring(0, this.attributePath.length() - 6)) + "#text";
                        }
                    }
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean scanChildren(XModelObject object, String xp) {
        XModelObject[] cs = object.getChildrenForSave();
        int i = 0;
        while (i < cs.length) {
            if (this.scan(cs[i], xp)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean parseText() {
        if (this.text == null) {
            return false;
        }
        if (this.text.length() == 0) {
            return true;
        }
        if (this.text.trim().startsWith("<") || this.targetAttribute == null) {
            String tag = this.targetObject.getModelEntity().getXMLSubPath();
            String body = "<" + tag + ">\n" + this.text + "</" + tag + ">\n";
            this.element = XMLUtilities.getElement((Reader)new StringReader(body), (EntityResolver)XMLEntityResolver.getInstance());
            if (this.element == null) {
                String[] errors = XMLUtilities.getXMLErrors((Reader)new StringReader(body), (boolean)false, (EntityResolver)XMLEntityResolver.getInstance());
                String message = "Cannot load xml";
                if (errors.length > 0) {
                    message = String.valueOf(message) + ": " + errors[0];
                }
                message = String.valueOf(message) + "\nPlease correct file addition " + this.fileAddition.getAttributeValue("label") + ".";
                this.report(message);
                return false;
            }
            if (this.targetAttribute == null) {
                this.updateObject = XModelObjectLoaderUtil.createValidObject((XModel)this.targetObject.getModel(), (String)this.targetObject.getModelEntity().getName());
                XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader((XModelObject)this.configFile);
                if (loader instanceof SerializingLoader) {
                    SerializingLoader sl = (SerializingLoader)loader;
                    sl.loadFragment(this.updateObject, this.element);
                } else {
                    new XModelObjectLoaderUtil().load(this.element, this.updateObject);
                }
            } else {
                this.attributeValue = this.readAttributeValue(this.element);
            }
        } else {
            this.attributeValue = this.text;
        }
        return true;
    }

    private void report(String message) {
        ServiceDialog d = this.configFile.getModel().getService();
        d.showDialog(JSFUIMessages.ERROR, message, new String[]{JSFUIMessages.CLOSE}, null, 1);
    }

    private String readAttributeValue(Element element) {
        XModelObjectLoaderUtil util = new XModelObjectLoaderUtil();
        if (this.attributePath != null) {
            return util.getAttribute(element, this.attributePath);
        }
        return XMLUtilities.getCDATA((Element)element);
    }

    private void mergeAttributes(XModelObject object, XModelObject update) throws XModelException {
        XAttribute[] as = update.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String v;
            String xml = as[i].getXMLName();
            if (xml != null && xml.indexOf(46) >= 0 && (v = update.getAttributeValue(as[i].getName())) != null && v.length() != 0) {
                object.getModel().editObjectAttribute(object, as[i].getName(), v);
            }
            ++i;
        }
    }

    private void mergeChildren(XModelObject object, XModelObject[] update) throws XModelException {
        int i = 0;
        while (i < update.length) {
            String pp = update[i].getPathPart();
            XModelObject c = object.getChildByPath(pp);
            if (c == null) {
                DefaultCreateHandler.addCreatedObject((XModelObject)object, (XModelObject)update[i], (int)-1);
                if ("0".equals(this.preferredPosition) || "top".equals(this.preferredPosition)) {
                    this.moveToPotition(object, update[i], 0);
                }
            } else {
                String xml = update[i].getModelEntity().getXMLSubPath();
                if (xml == null || xml.length() == 0) {
                    this.mergeChildren(c, update[i].getChildren());
                } else {
                    EnginesLoader.merge((XModelObject)c, (XModelObject)update[i], (boolean)true);
                }
            }
            ++i;
        }
    }

    private void moveToPotition(XModelObject parent, XModelObject child, int pos) {
        if (!(parent instanceof XOrderedObject)) {
            return;
        }
        XModelObject[] cs = parent.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (cs[i] == child) {
                if (i == 0) {
                    return;
                }
                ((XOrderedObject)parent).move(i, 0, true);
                return;
            }
            ++i;
        }
    }
}

