/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.project;

import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.project.IAutoLoad;
import org.jboss.tools.common.model.project.ProjectHome;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.common.util.FileUtil;

public class JSFAutoLoad
implements IAutoLoad {
    public void load(XModel model) {
        Properties properties = null;
        XModelObject fs = FileSystemsHelper.getFileSystems((XModel)model);
        IProject project = EclipseResourceUtil.getProject((XModelObject)fs);
        if (project == null) {
            return;
        }
        fs.setAttributeValue("application name", project.getName());
        String fsLoc = null;
        FileSystemImpl s = null;
        properties = new Properties();
        fsLoc = project.getLocation().toString();
        properties.setProperty("location", fsLoc);
        properties.setProperty("name", project.getName());
        s = (FileSystemImpl)model.createModelObject("FileSystemFolder", properties);
        fs.addChild((XModelObject)s);
        XModelObject webinf = model.createModelObject("FileSystemFolder", null);
        webinf.setAttributeValue("name", "WEB-INF");
        webinf.setAttributeValue("location", XModelConstants.WORKSPACE_REF);
        fs.addChild(webinf);
        String webInfLocation = XModelObjectUtil.expand((String)XModelConstants.WORKSPACE_REF, (XModel)model, null);
        String webRootLocation = JSFAutoLoad.getWebRootPath(project, webInfLocation);
        XModelObject webroot = model.createModelObject("FileSystemFolder", null);
        webroot.setAttributeValue("name", "WEB-ROOT");
        webroot.setAttributeValue("location", webRootLocation);
        fs.addChild(webroot);
        XModelObject lib = model.createModelObject("FileSystemFolder", null);
        lib.setAttributeValue("name", "lib");
        lib.setAttributeValue("location", String.valueOf(XModelConstants.WORKSPACE_REF) + "/lib");
        fs.addChild(lib);
    }

    static String getWebRootPath(IProject project, String webInfLocation) {
        IPath p;
        String webRootLocation = String.valueOf(XModelConstants.WORKSPACE_REF) + "/..";
        IPath wrp = ProjectHome.getFirstWebContentPath((IProject)project);
        IPath wip = ProjectHome.getWebInfPath((IProject)project);
        if (wrp == null || wip == null) {
            return webRootLocation;
        }
        IResource wrpc = ResourcesPlugin.getWorkspace().getRoot().findMember(wrp);
        IResource wipc = ResourcesPlugin.getWorkspace().getRoot().findMember(wip);
        if (wrpc != null && wipc != null && wipc.isLinked() && (p = wrpc.getLocation()) != null) {
            try {
                webRootLocation = p.toFile().getCanonicalPath().replace('\\', '/');
            }
            catch (IOException iOException) {}
            String relative = FileUtil.getRelativePath((String)webInfLocation, (String)webRootLocation);
            if (relative != null) {
                webRootLocation = String.valueOf(XModelConstants.WORKSPACE_REF) + relative;
            }
        }
        return webRootLocation;
    }
}

