/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.pv;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.impl.ExtraRootImpl;
import org.jboss.tools.common.model.project.WatcherLoader;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.model.pv.JsfTreeListener;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class JSFProjectsRoot
extends ExtraRootImpl
implements WebProjectNode {
    private static final long serialVersionUID = 2682624545624629547L;
    XModelObject fs;
    XModelObject webroot = null;
    XModelObject webxml = null;
    XModelObject[] treeChildren = new XModelObject[0];

    protected void onSetEntity(String entity) {
        super.onSetEntity(entity);
        this.getFileSystems();
        this.getModel().addModelTreeListener((XModelTreeListener)new JsfTreeListener());
    }

    public boolean isLoaded() {
        return this.children != null && !this.children.isEmpty();
    }

    public XModelObject getFileSystems() {
        if (this.fs == null) {
            this.fs = FileSystemsHelper.getFileSystems((XModel)this.getModel());
            this.webxml = WebAppHelper.getWebApp((XModel)this.getModel());
            if (this.fs != null) {
                this.webroot = this.fs.getChildByPath("WEB-ROOT");
            }
        }
        return this.fs;
    }

    public String get(String name) {
        if ("_hasErrors_".equals(name)) {
            return this.fs == null ? "yes" : this.fs.get(name);
        }
        return super.get(name);
    }

    public XModelObject getWebXML() {
        return this.webxml;
    }

    public boolean hasChildren() {
        return true;
    }

    protected void loadChildren() {
        if (!this.isLoaded()) {
            XModelObjectLoaderUtil.addRequiredChildren((XModelObject)this);
        }
    }

    public String getPresentationString() {
        if (this.getFileSystems() == null) {
            return "";
        }
        return this.getFileSystems().getPresentationString();
    }

    public boolean isActive() {
        return this.getFileSystems() != null && this.getFileSystems().isActive();
    }

    public XModelObject[] getTreeChildren() {
        this.fs = FileSystemsHelper.getFileSystems((XModel)this.getModel());
        if (this.fs == null) {
            return new XModelObject[0];
        }
        this.webroot = this.fs.getChildByPath("WEB-ROOT");
        this.webxml = WebAppHelper.getWebApp((XModel)this.getModel());
        XModelObject[] cs = this.getChildren();
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        if (this.webroot != null) {
            list.add(this.webroot);
        }
        int i = 0;
        while (i < cs.length) {
            list.add(cs[i]);
            ++i;
        }
        if (this.webxml != null) {
            list.add(this.webxml);
        }
        this.treeChildren = list.toArray(new XModelObject[0]);
        return this.treeChildren;
    }

    public boolean isChild(XModelObject object) {
        int i = 0;
        while (i < this.treeChildren.length) {
            if (this.treeChildren[i] == object) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public XModelObject getTreeParent(XModelObject object) {
        if (this.treeChildren.length == 0) {
            this.getTreeChildren();
        }
        if (this.isChild(object)) {
            return this;
        }
        XModelObject[] cs = this.getChildren();
        int i = 0;
        while (i < cs.length) {
            WebProjectNode n;
            if (cs[i] instanceof WebProjectNode && (n = (WebProjectNode)cs[i]).isChild(object)) {
                return n.getTreeParent(object);
            }
            ++i;
        }
        return object.getParent();
    }

    public void invalidate() {
        if (!this.isLoaded()) {
            return;
        }
        XModelObject[] cs = this.getChildren();
        int i = 0;
        while (i < cs.length) {
            WebProjectNode n = (WebProjectNode)cs[i];
            n.invalidate();
            ++i;
        }
        this.fireStructureChanged(3, (Object)this);
    }

    public Object getAdapter(Class adapter) {
        return this.fs != null ? this.fs.getAdapter(adapter) : super.getAdapter(adapter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getErrorState() {
        IProject p;
        if (WatcherLoader.isLocked((XModel)this.getModel())) {
            return 0;
        }
        if (!this.isLoaded() && (p = EclipseResourceUtil.getProject((XModelObject)this.fs)) != null && p.exists() && p.isAccessible()) {
            try {
                IMarker[] ms = p.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                if (ms == null) return 0;
                if (ms.length <= 0) return 0;
                int i = 0;
                while (true) {
                    if (i >= ms.length) {
                        return 0;
                    }
                    if (ms[i].getAttribute("severity", 0) == 2) {
                        return 2;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                JSFModelPlugin.getPluginLog().logError((Throwable)e);
                return 0;
            }
        }
        this.getTreeChildren();
        if (this.webxml != null && this.webxml.getErrorState() == 0 && this.webxml.getErrorChildCount() <= 0) {
            this.setErrorState(0);
            return super.getErrorState();
        }
        this.setErrorState(this.webxml == null ? 2 : this.webxml.getErrorState());
        return super.getErrorState();
    }
}

