/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model.handlers.refactoring;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.refactoring.RefactoringHelper;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.model.ReferenceGroupImpl;
import org.jboss.tools.jsf.model.handlers.RenameViewSupport;
import org.jboss.tools.jsf.model.handlers.refactoring.JSFRenamePathDiagramChange;
import org.jboss.tools.jsf.model.helpers.JSFProcessHelper;
import org.jboss.tools.jsf.model.helpers.JSFProcessStructureHelper;
import org.jboss.tools.jsf.model.pv.JSFProjectsRoot;
import org.jboss.tools.jsf.model.pv.JSFProjectsTree;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;

public class JSFRenameFolderFacesConfigChange
extends CompositeChange {
    XModelObject object;
    String newName;
    XModelObject[] fs;
    String oldPath;
    String newPath;
    Properties replacements = new Properties();

    public JSFRenameFolderFacesConfigChange(XModelObject object, String newName) {
        super(JSFUIMessages.FACES_CONFIG_CHANGES);
        this.object = object;
        this.newName = newName;
        this.replacements.clear();
        this.oldPath = object.getAttributeValue("name");
        this.newPath = newName;
        this.oldPath = "/" + this.oldPath + "/";
        this.newPath = "/" + this.newPath + "/";
        XModelObject parent = object.getParent();
        while (parent != null && parent.getFileType() == 2) {
            this.oldPath = "/" + parent.getAttributeValue("name") + this.oldPath;
            this.newPath = "/" + parent.getAttributeValue("name") + this.newPath;
            parent = parent.getParent();
        }
        this.replacements.setProperty(">" + this.oldPath, ">" + this.newPath);
        this.addChanges();
    }

    private void addChanges() {
        if (this.object == null) {
            return;
        }
        JSFProjectsRoot root = JSFProjectsTree.getProjectsRoot(this.object.getModel());
        XModelObject conf = root == null ? null : root.getChildByPath("Configuration");
        this.fs = conf == null ? new XModelObject[]{} : ((WebProjectNode)conf).getTreeChildren();
        this.addChanges(this.fs);
    }

    private void addChanges(XModelObject[] objects) {
        int i = 0;
        while (i < objects.length) {
            XModelObject[] gs;
            int c = this.getChildren().length;
            RefactoringHelper.addChanges((XModelObject)objects[i], (Properties)this.replacements, (CompositeChange)this);
            if (c == this.getChildren().length && (gs = this.findGroups(objects[i])).length > 0) {
                this.add((Change)new JSFRenamePathDiagramChange(objects[i], gs));
            }
            ++i;
        }
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        XModelObject parent = this.object.getParent();
        if (parent instanceof FolderImpl) {
            ((FolderImpl)parent).update();
        }
        int i = 0;
        while (i < this.fs.length) {
            this.performChangeInFile(this.fs[i]);
            ++i;
        }
        i = 0;
        while (i < this.fs.length) {
            if (this.fs[i].isModified()) {
                XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)this.fs[i], null);
            }
            ++i;
        }
        return null;
    }

    private void performChangeInFile(XModelObject f) throws XModelException {
        XModelObject[] gs = this.findGroups(f);
        if (gs.length == 0) {
            return;
        }
        JSFProcessHelper h = JSFProcessHelper.getHelper(JSFProcessStructureHelper.instance.getProcess(f));
        h.addUpdateLock((Object)this);
        try {
            int j = 0;
            while (j < gs.length) {
                String op = gs[j].getAttributeValue("path");
                String np = String.valueOf(this.newPath) + op.substring(this.oldPath.length());
                RenameViewSupport.replace((ReferenceGroupImpl)gs[j], op, np);
                ++j;
            }
        }
        finally {
            h.removeUpdateLock((Object)this);
            h.updateProcess();
        }
    }

    XModelObject[] findGroups(XModelObject f) {
        XModelObject process = JSFProcessStructureHelper.instance.getProcess(f);
        if (process == null) {
            return new XModelObject[0];
        }
        XModelObject[] gs = JSFProcessStructureHelper.instance.getGroups(process);
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        int i = 0;
        while (i < gs.length) {
            String path = gs[i].getAttributeValue("path");
            if (path != null && path.startsWith(this.oldPath)) {
                list.add(gs[i]);
            }
            ++i;
        }
        return list.toArray(new XModelObject[0]);
    }
}

