/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.el.core.ca.AbstractELCompletionEngine;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.IVariable;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jsf.JSFModelPlugin;
import org.jboss.tools.jsf.model.pv.JSFPromptingProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFELCompletionEngine
extends AbstractELCompletionEngine<IJSFVariable> {
    private static final Image JSF_EL_PROPOSAL_IMAGE = JSFModelPlugin.getDefault().getImage("images/ca/icons_JSF_EL.gif");
    private static ELParserFactory factory = ELParserUtil.getDefaultFactory();

    public Image getELProposalImage() {
        return JSF_EL_PROPOSAL_IMAGE;
    }

    protected void log(Exception e) {
        JSFModelPlugin.getPluginLog().logError((Throwable)e);
    }

    public ELParserFactory getParserFactory() {
        return factory;
    }

    public List<IJSFVariable> resolveVariables(IFile file, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames) {
        IModelNature project = EclipseResourceUtil.getModelNature((IProject)file.getProject());
        return this.resolveVariables(file, project, expr, isFinal, onlyEqualNames);
    }

    public List<IJSFVariable> resolveVariables(IFile file, IModelNature project, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames) {
        IJavaProject jp;
        List<Object> resolvedVars = new ArrayList();
        if (project == null) {
            return new ArrayList<IJSFVariable>();
        }
        String varName = expr.toString();
        if (varName != null) {
            resolvedVars = this.resolveVariables(project, varName, onlyEqualNames);
        }
        if (resolvedVars != null && !resolvedVars.isEmpty()) {
            ArrayList<IJSFVariable> newResolvedVars = new ArrayList<IJSFVariable>();
            for (IJSFVariable iJSFVariable : resolvedVars) {
                if (!isFinal) {
                    if (!varName.equals(iJSFVariable.getName())) continue;
                    newResolvedVars.add(iJSFVariable);
                    continue;
                }
                newResolvedVars.add(iJSFVariable);
            }
            return newResolvedVars;
        }
        if (varName != null && (varName.startsWith("\"") || varName.startsWith("'")) && (varName.endsWith("\"") || varName.endsWith("'")) && (jp = EclipseResourceUtil.getJavaProject((IProject)file.getProject())) != null) {
            try {
                IMethod m;
                IType iType = jp.findType("java.lang.String");
                if (iType != null && (m = iType.getMethod("toString", new String[0])) != null) {
                    Variable v = new Variable("String", (IMember)m);
                    ArrayList<IJSFVariable> newResolvedVars = new ArrayList<IJSFVariable>();
                    newResolvedVars.add(v);
                    return newResolvedVars;
                }
            }
            catch (JavaModelException javaModelException) {
                JSFModelPlugin.getDefault().logError(javaModelException);
            }
        }
        return new ArrayList<IJSFVariable>();
    }

    protected List<IJSFVariable> resolveVariables(IModelNature project, String varName, boolean onlyEqualNames) {
        if (project == null) {
            return null;
        }
        List<IJSFVariable> beans = new JSFPromptingProvider().getVariables(project.getModel());
        ArrayList<IJSFVariable> resolvedVariables = new ArrayList<IJSFVariable>();
        for (IJSFVariable variable : beans) {
            String n = variable.getName();
            if (onlyEqualNames) {
                if (!n.equals(varName)) continue;
                resolvedVariables.add(variable);
                continue;
            }
            if (!n.startsWith(varName)) continue;
            resolvedVariables.add(variable);
        }
        return resolvedVariables;
    }

    protected TypeInfoCollector.MemberInfo getMemberInfoByVariable(IJSFVariable var, boolean onlyEqualNames) {
        return TypeInfoCollector.createMemberInfo((IMember)var.getSourceMember());
    }

    protected boolean isStaticMethodsCollectingEnabled() {
        return false;
    }

    public static interface IJSFVariable
    extends IVariable {
        public IMember getSourceMember();
    }

    public static class Variable
    implements IJSFVariable {
        private String name;
        private IMember source;

        public Variable(String name, IMember source) {
            this.name = name;
            this.source = source;
        }

        public IMember getSourceMember() {
            return this.source;
        }

        public String getName() {
            return this.name;
        }
    }
}

