/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.el.refactoring;

import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.ELReference;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELMethodInvocation;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.parser.ELParser;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELCompletionEngine;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.ELResolution;
import org.jboss.tools.common.el.core.resolver.ELResolver;
import org.jboss.tools.common.el.core.resolver.ELResolverFactoryManager;
import org.jboss.tools.common.el.core.resolver.ELSegment;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.SimpleELContext;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.kb.PageContextFactory;

public abstract class RefactorSearcher {
    protected static final String JAVA_EXT = "java";
    protected static final String XML_EXT = "xml";
    protected static final String XHTML_EXT = "xhtml";
    protected static final String JSP_EXT = "jsp";
    protected static final String PROPERTIES_EXT = "properties";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String IS = "is";
    protected static final String SEAM_PROPERTIES_FILE = "seam.properties";
    protected IFile baseFile;
    protected String propertyName;
    protected IJavaElement javaElement;
    protected IJavaSearchScope searchScope;

    public RefactorSearcher(IFile baseFile, String propertyName) {
        this.baseFile = baseFile;
        this.propertyName = propertyName;
    }

    public RefactorSearcher(IFile baseFile, String propertyName, IJavaElement javaElement) {
        this(baseFile, propertyName);
        this.javaElement = javaElement;
    }

    public void setSearchScope(IJavaSearchScope searchScope) {
        this.searchScope = searchScope;
    }

    public void findELReferences() {
        IProject[] projects;
        if (this.baseFile == null) {
            return;
        }
        IProject[] iProjectArray = projects = this.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project != null && this.containsInSearchScope(project)) {
                this.updateEnvironment(project);
                IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
                if (javaProject != null) {
                    IResource[] iResourceArray = EclipseResourceUtil.getJavaSourceRoots((IProject)project);
                    int n3 = iResourceArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IResource resource = iResourceArray[n4];
                        if (resource instanceof IFolder) {
                            this.scanForJava((IContainer)((IFolder)resource));
                        } else if (resource instanceof IFile) {
                            this.scanForJava((IFile)resource);
                        }
                        ++n4;
                    }
                }
                if (this.getViewFolder(project) != null) {
                    this.scan(this.getViewFolder(project));
                } else {
                    this.scan((IContainer)project);
                }
            }
            ++n2;
        }
    }

    protected void updateEnvironment(IProject project) {
    }

    protected abstract IProject[] getProjects();

    protected abstract IContainer getViewFolder(IProject var1);

    private void scanForJava(IContainer container) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    this.scanForJava((IContainer)((IFolder)resource));
                } else if (resource instanceof IFile) {
                    this.scanForJava((IFile)resource);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            ELCorePlugin.getDefault().logError((Throwable)ex);
        }
    }

    private void scan(IContainer container) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    this.scan((IContainer)((IFolder)resource));
                } else if (resource instanceof IFile) {
                    this.scan((IFile)resource);
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            ELCorePlugin.getDefault().logError((Throwable)ex);
        }
    }

    private String getFileContent(IFile file) {
        try {
            return FileUtil.readStream((IFile)file);
        }
        catch (CoreException e) {
            ELCorePlugin.getDefault().logError((Throwable)e);
            return null;
        }
    }

    private void scanForJava(IFile file) {
        if (this.isFileCorrect(file)) {
            if (PROPERTIES_EXT.equalsIgnoreCase(file.getFileExtension())) {
                if (file.getName().equals(SEAM_PROPERTIES_FILE)) {
                    String content = this.getFileContent(file);
                    this.scanProperties(file, content);
                } else {
                    this.searchInCach(file);
                }
            } else if (JAVA_EXT.equalsIgnoreCase(file.getFileExtension()) || JSP_EXT.equalsIgnoreCase(file.getFileExtension()) || XHTML_EXT.equalsIgnoreCase(file.getFileExtension()) || XML_EXT.equalsIgnoreCase(file.getFileExtension())) {
                this.searchInCach(file);
            }
        }
    }

    private void scan(IFile file) {
        String ext;
        if (this.isFileCorrect(file) && (XML_EXT.equalsIgnoreCase(ext = file.getFileExtension()) || XHTML_EXT.equalsIgnoreCase(ext) || JSP_EXT.equalsIgnoreCase(ext))) {
            this.searchInCach(file);
        }
    }

    private void searchInCach(IFile file) {
        ELContext context = PageContextFactory.createPageContext((IFile)file);
        if (context == null) {
            return;
        }
        ELReference[] references = context.getELReferences();
        ELResolver[] resolvers = context.getElResolvers();
        if (this.javaElement != null) {
            ELReference[] eLReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                ELReference reference = eLReferenceArray[n2];
                int offset = reference.getStartPosition();
                ELExpression[] eLExpressionArray = reference.getEl();
                int n3 = eLExpressionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ELExpression operand = eLExpressionArray[n4];
                    ELResolver[] eLResolverArray = resolvers;
                    int n5 = resolvers.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        ELResolution resolution;
                        ELResolver resolver = eLResolverArray[n6];
                        if (resolver instanceof ELCompletionEngine && (resolution = resolver.resolve(context, operand, offset)) != null) {
                            List segments = resolution.findSegmentsByJavaElement(this.javaElement);
                            for (ELSegment segment : segments) {
                                this.match(file, offset + segment.getSourceReference().getStartPosition(), segment.getSourceReference().getLength());
                            }
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        } else {
            ELReference[] eLReferenceArray = references;
            int n = references.length;
            int n7 = 0;
            while (n7 < n) {
                ELExpression[] expressions;
                ELReference reference = eLReferenceArray[n7];
                int offset = reference.getStartPosition();
                ELExpression[] eLExpressionArray = expressions = reference.getEl();
                int n8 = expressions.length;
                int n9 = 0;
                while (n9 < n8) {
                    ELInvocationExpression expression;
                    ELExpression operand = eLExpressionArray[n9];
                    if (operand instanceof ELInvocationExpression && (expression = this.findComponentReference((ELInvocationExpression)operand)) != null) {
                        this.checkMatch(file, (ELExpression)expression, offset + this.getOffset(expression), this.getLength(expression));
                    }
                    ++n9;
                }
                ++n7;
            }
        }
    }

    private void scanString(IFile file, String string, int offset) {
        int startEl = string.indexOf("#{");
        if (startEl < 0) {
            startEl = string.indexOf("${");
        }
        if (startEl > -1) {
            ELParser parser = ELParserUtil.getJbossFactory().createParser();
            ELModel model = parser.parse(string);
            for (ELInstance instance : model.getInstances()) {
                for (ELInvocationExpression ie : instance.getExpression().getInvocations()) {
                    ELInvocationExpression expression = this.findComponentReference(ie);
                    if (expression == null) continue;
                    this.checkMatch(file, (ELExpression)expression, offset + this.getOffset(expression), this.getLength(expression));
                }
            }
        }
    }

    protected int getOffset(ELInvocationExpression expression) {
        ELMethodInvocation mi;
        if (expression instanceof ELPropertyInvocation) {
            ELPropertyInvocation pi = (ELPropertyInvocation)expression;
            if (pi.getName() != null) {
                return pi.getName().getStart();
            }
        } else if (expression instanceof ELMethodInvocation && (mi = (ELMethodInvocation)expression).getName() != null) {
            return mi.getName().getStart();
        }
        return 0;
    }

    private int getLength(ELInvocationExpression expression) {
        ELMethodInvocation mi;
        if (expression instanceof ELPropertyInvocation) {
            ELPropertyInvocation pi = (ELPropertyInvocation)expression;
            if (pi.getName() != null) {
                return pi.getName().getLength();
            }
        } else if (expression instanceof ELMethodInvocation && (mi = (ELMethodInvocation)expression).getName() != null) {
            return mi.getName().getLength();
        }
        return 0;
    }

    private void scanProperties(IFile file, String content) {
        if (!file.getName().equals(SEAM_PROPERTIES_FILE)) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(content, "#= \t\r\n\f", true);
        String lastToken = "\n";
        int offset = 0;
        boolean comment = false;
        boolean key = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken("#= \t\r\n\f");
            if (token.equals("\r")) {
                token = "\n";
            }
            if (token.equals("#") && lastToken.equals("\n")) {
                comment = true;
            } else if (token.equals("\n") && comment) {
                comment = false;
            }
            if (!comment) {
                if (!token.equals("\n") && lastToken.equals("\n")) {
                    key = true;
                } else if (key && (token.equals("=") || token.equals(" "))) {
                    key = false;
                }
                if (key && token.startsWith(this.propertyName)) {
                    this.match(file, offset, token.length());
                }
            }
            lastToken = token;
            offset += token.length();
        }
    }

    protected ELInvocationExpression findComponentReference(ELInvocationExpression invocationExpression) {
        return invocationExpression;
    }

    protected abstract boolean isFileCorrect(IFile var1);

    protected abstract void match(IFile var1, int var2, int var3);

    protected void checkMatch(IFile file, ELExpression operand, int offset, int length) {
        if (this.javaElement != null && operand != null) {
            this.resolve(file, operand, offset - this.getOffset((ELInvocationExpression)operand));
        } else {
            this.match(file, offset, length);
        }
    }

    public static boolean isGetter(IMethod method) {
        String name = method.getElementName();
        int numberOfParameters = method.getNumberOfParameters();
        return (name.startsWith(GET) && !name.equals(GET) || name.startsWith(IS)) && numberOfParameters == 0;
    }

    public static boolean isSetter(IMethod method) {
        String name = method.getElementName();
        int numberOfParameters = method.getNumberOfParameters();
        return name.startsWith(SET) && !name.equals(SET) && numberOfParameters == 1;
    }

    public static String getPropertyName(IMethod method, String methodName) {
        if (RefactorSearcher.isGetter(method) || RefactorSearcher.isSetter(method)) {
            StringBuffer name = new StringBuffer(methodName);
            if (methodName.startsWith("i")) {
                name.delete(0, 2);
            } else {
                name.delete(0, 3);
            }
            if (name.length() < 2 || Character.isLowerCase(name.charAt(1))) {
                name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            }
            String propertyName = name.toString();
            return propertyName;
        }
        return methodName;
    }

    public static String getPropertyName(IType method, String className) {
        StringBuffer name = new StringBuffer(className);
        if (name.length() < 2 || Character.isLowerCase(name.charAt(1))) {
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
        }
        String propertyName = name.toString();
        return propertyName;
    }

    private boolean containsInSearchScope(IProject project) {
        IPath[] paths;
        if (this.searchScope == null) {
            return true;
        }
        IPath[] iPathArray = paths = this.searchScope.enclosingProjectsAndJars();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath path = iPathArray[n2];
            if (path.equals((Object)project.getFullPath())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void resolve(IFile file, ELExpression operand, int offset) {
        ELResolver[] resolvers;
        ELResolver[] eLResolverArray = resolvers = ELResolverFactoryManager.getInstance().getResolvers((IResource)file);
        int n = resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            ELResolver resolver = eLResolverArray[n2];
            if (resolver instanceof ELCompletionEngine) {
                SimpleELContext context = new SimpleELContext();
                context.setResource(file);
                context.setElResolvers(resolvers);
                List vars = ElVarSearcher.findAllVars((ELContext)context, (int)offset, (ELResolver)resolver);
                context.setVars(vars);
                ELResolution resolution = resolver.resolve((ELContext)context, operand, offset);
                List segments = resolution.findSegmentsByJavaElement(this.javaElement);
                for (ELSegment segment : segments) {
                    this.match(file, offset + segment.getSourceReference().getStartPosition(), segment.getSourceReference().getLength());
                }
            }
            ++n2;
        }
    }
}

