/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.el.refactoring;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.el.core.ELCorePlugin;
import org.jboss.tools.common.el.core.ElCoreMessages;
import org.jboss.tools.common.model.project.ProjectHome;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jsf.el.refactoring.RefactorSearcher;

public abstract class ELRenameProcessor
extends RenameProcessor {
    protected static final String JAVA_EXT = "java";
    protected static final String XML_EXT = "xml";
    protected static final String XHTML_EXT = "xhtml";
    protected static final String JSP_EXT = "jsp";
    protected static final String PROPERTIES_EXT = "properties";
    protected static final RefactoringParticipant[] EMPTY_REF_PARTICIPANT = new RefactoringParticipant[0];
    protected static final String SEAM_PROPERTIES_FILE = "seam.properties";
    protected RefactoringStatus status;
    protected CompositeChange rootChange;
    protected TextFileChange lastChange;
    protected IFile declarationFile = null;
    private ArrayList<String> keys = new ArrayList();
    private String newName;
    private String oldName;
    private ELSearcher searcher = null;

    public ELRenameProcessor(IFile file, String oldName) {
        this.searcher = new ELSearcher(file, oldName);
    }

    protected RefactorSearcher getSearcher() {
        return this.searcher;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    protected String getNewName() {
        return this.newName;
    }

    protected void setOldName(String oldName) {
        this.oldName = oldName;
    }

    public String getOldName() {
        return this.oldName;
    }

    protected TextFileChange getChange(IFile file) {
        if (this.lastChange != null && this.lastChange.getFile().equals((Object)file)) {
            return this.lastChange;
        }
        int i = 0;
        while (i < this.rootChange.getChildren().length) {
            TextFileChange change = (TextFileChange)this.rootChange.getChildren()[i];
            if (change.getFile().equals((Object)file)) {
                this.lastChange = change;
                return this.lastChange;
            }
            ++i;
        }
        this.lastChange = new TextFileChange(file.getName(), file);
        MultiTextEdit root = new MultiTextEdit();
        this.lastChange.setEdit((TextEdit)root);
        this.rootChange.add((Change)this.lastChange);
        return this.lastChange;
    }

    private boolean isBadLocation(ITextSourceReference location, IFile file) {
        boolean flag = location == null ? true : location.getStartPosition() == 0 && location.getLength() == 0;
        return flag;
    }

    private void changeXMLNode(ITextSourceReference location, IFile file) {
        if (this.isBadLocation(location, file)) {
            return;
        }
        if (!this.isFileCorrect(file)) {
            return;
        }
        String content = null;
        try {
            content = FileUtil.readStream((IFile)file);
        }
        catch (CoreException e) {
            ELCorePlugin.getDefault().logError((Throwable)e);
        }
        String text = content.substring(location.getStartPosition(), location.getStartPosition() + location.getLength());
        if (text.startsWith("<")) {
            int position = text.lastIndexOf("/>");
            if (position < 0) {
                position = text.lastIndexOf(">");
            }
            this.change(file, location.getStartPosition() + position, 0, " name=\"" + this.getNewName() + "\"");
        } else {
            this.change(file, location.getStartPosition(), location.getLength(), this.getNewName());
        }
    }

    private void changeAnnotation(ITextSourceReference location, IFile file) {
        if (this.isBadLocation(location, file)) {
            return;
        }
        if (!this.isFileCorrect(file)) {
            return;
        }
        String content = null;
        try {
            content = FileUtil.readStream((IFile)file);
        }
        catch (CoreException e) {
            ELCorePlugin.getDefault().logError((Throwable)e);
        }
        String text = content.substring(location.getStartPosition(), location.getStartPosition() + location.getLength());
        int openBracket = text.indexOf("(");
        int openQuote = text.indexOf("\"");
        if (openBracket >= 0) {
            int closeBracket = text.indexOf(")", openBracket);
            int equals = text.indexOf("=", openBracket);
            int value = text.indexOf("value", openBracket);
            if (closeBracket == openBracket + 1) {
                String newText = "\"" + this.getNewName() + "\"";
                this.change(file, location.getStartPosition() + openBracket + 1, 0, newText);
            } else if (value > 0) {
                String newText = text.replace(this.getOldName(), this.getNewName());
                this.change(file, location.getStartPosition(), location.getLength(), newText);
            } else if (equals > 0) {
                String newText = "value=\"" + this.getNewName() + "\",";
                this.change(file, location.getStartPosition() + openBracket + 1, 0, newText);
            } else {
                String newText = text.replace(this.getOldName(), this.getNewName());
                this.change(file, location.getStartPosition(), location.getLength(), newText);
            }
        } else if (openQuote >= 0) {
            int closeQuota = text.indexOf("\"", openQuote);
            if (closeQuota == openQuote + 1) {
                String newText = "\"" + this.getNewName() + "\"";
                this.change(file, location.getStartPosition() + openQuote + 1, 0, newText);
            } else {
                String newText = text.replace(this.getOldName(), this.getNewName());
                this.change(file, location.getStartPosition(), location.getLength(), newText);
            }
        } else {
            String newText = "(\"" + this.getNewName() + "\")";
            this.change(file, location.getStartPosition() + location.getLength(), 0, newText);
        }
    }

    private void clearChanges() {
        this.keys.clear();
    }

    private void change(IFile file, int offset, int length, String text) {
        String key = String.valueOf(file.getFullPath().toString()) + " " + offset;
        if (!this.keys.contains(key)) {
            TextFileChange change = this.getChange(file);
            ReplaceEdit edit = new ReplaceEdit(offset, length, text);
            change.addEdit((TextEdit)edit);
            this.keys.add(key);
        }
    }

    protected boolean isFileCorrect(IFile file) {
        if (!file.isSynchronized(0)) {
            this.status.addFatalError(Messages.format((String)ElCoreMessages.EL_RENAME_PROCESSOR_OUT_OF_SYNC_FILE, (Object)file.getFullPath().toString()));
            return false;
        }
        if (file.isPhantom()) {
            this.status.addFatalError(Messages.format((String)ElCoreMessages.EL_RENAME_PROCESSOR_ERROR_PHANTOM_FILE, (Object)file.getFullPath().toString()));
            return false;
        }
        if (file.isReadOnly()) {
            this.status.addFatalError(Messages.format((String)ElCoreMessages.EL_RENAME_PROCESSOR_ERROR_READ_ONLY_FILE, (Object)file.getFullPath().toString()));
            return false;
        }
        return true;
    }

    public class ELSearcher
    extends RefactorSearcher {
        ArrayList<String> keys;

        public ELSearcher(IFile file, String oldName) {
            super(file, oldName);
            this.keys = new ArrayList();
        }

        private boolean checkFolder(IResource resource, IResource[] sources, IPath output) {
            IResource[] iResourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource folder = iResourceArray[n2];
                if (resource.equals((Object)folder)) {
                    return false;
                }
                ++n2;
            }
            return !resource.getFullPath().equals((Object)output);
        }

        protected IProject[] getProjects() {
            return new IProject[]{this.baseFile.getProject()};
        }

        protected IContainer getViewFolder(IProject project) {
            IPath path = ProjectHome.getFirstWebContentPath((IProject)this.baseFile.getProject());
            if (path != null) {
                return project.getFolder(path.removeFirstSegments(1));
            }
            return null;
        }

        protected void match(IFile file, int offset, int length) {
            ELRenameProcessor.this.change(file, offset, length, ELRenameProcessor.this.newName);
        }

        protected boolean isFileCorrect(IFile file) {
            return ELRenameProcessor.this.isFileCorrect(file);
        }
    }
}

