/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.text.ext.hyperlink.jsp;

import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.xml.XMLElementNameHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSPElementNameHyperlinkPartitioner
extends XMLElementNameHyperlinkPartitioner {
    protected String getAxis(IDocument document, IHyperlinkRegion superRegion) {
        if (superRegion.getAxis() == null || superRegion.getAxis().length() == 0) {
            return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis(document, superRegion.getOffset())) + "/";
        }
        return superRegion.getAxis();
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        if (!super.recognize(document, region)) {
            return false;
        }
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            Element elem = (Element)n;
            IHyperlinkRegion r = JSPElementNameHyperlinkPartitioner.getRegion((IDocument)document, (int)region.getOffset());
            if (r == null) {
                return false;
            }
            String nodeName = elem.getNodeName();
            if (nodeName.indexOf(":") == -1) {
                return false;
            }
            String nodePrefix = nodeName.substring(0, nodeName.indexOf(":"));
            if (nodePrefix == null || nodePrefix.length() == 0) {
                return false;
            }
            Map trackers = JSPRootHyperlinkPartitioner.getTrackersMap(document, region.getOffset());
            boolean bl = trackers != null && trackers.containsKey(nodePrefix);
            return bl;
        }
        finally {
            smw.dispose();
        }
    }
}

