/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.text.ext.hyperlink;

import org.eclipse.jface.text.IDocument;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CSSClassHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer {
    public static final String CSS_CLASS_PARTITION = "org.jboss.tools.common.text.ext.CSS_CLASS";
    private static final String CSS_CLASS_TOKEN = "/class/";
    private static final String EXCLUSION_TOKEN = "jsp:usebean/class/";

    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)superRegion.getOffset());
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = this.getPartitionType(axis);
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || end < start) {
                return null;
            }
            int length = end - start;
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getPartitionType(String axis) {
        return CSS_CLASS_PARTITION;
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        return region.getAxis() != null && region.getAxis().toLowerCase().endsWith(CSS_CLASS_TOKEN) && !region.getAxis().toLowerCase().endsWith(EXCLUSION_TOKEN);
    }
}

