/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.text.ext.ExtensionsPlugin;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.StructuredSelectionHelper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.web.kb.ICSSContainerSupport;
import org.jboss.tools.jst.web.kb.PageContextFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

public class CSSClassHyperlink
extends AbstractHyperlink {
    public static final String[] STYLE_TAGS = new String[]{"style", "link"};
    public static final String LINK_TAG = "link";
    public static final String HREF_ATTRIBUTE = "href";
    public static final String COMPARE_CLASS_REGEX_PREFIX = "([A-Za-z_][A-Za-z_0-9\\-]*)*[\\.]?";
    public static final String CONTEXT_PATH_EXPRESSION = "^\\s*(\\#|\\$)\\{facesContext.externalContext.requestContextPath\\}";
    protected IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        ICSSContainerSupport cssContainerSupport = null;
        ELContext context = PageContextFactory.createPageContext((IFile)this.getFile());
        if (!(context instanceof ICSSContainerSupport)) {
            this.openFileFailed();
            return;
        }
        cssContainerSupport = (ICSSContainerSupport)context;
        List descrs = cssContainerSupport.getCSSStyleSheetDescriptors();
        int i = descrs == null ? -1 : descrs.size() - 1;
        while (descrs != null && i >= 0) {
            PageContextFactory.CSSStyleSheetDescriptor descr = (PageContextFactory.CSSStyleSheetDescriptor)descrs.get(i);
            CSSRuleList rules = descr.sheet.getCssRules();
            int r = 0;
            while (rules != null && r < rules.getLength()) {
                if (this.isRuleMatch(rules.item(r), this.getStyleName(region))) {
                    CSSRule rule = rules.item(r);
                    IFile file = this.findFileForCSSStyleSheet(descr.source);
                    if (file != null) {
                        Node node;
                        int startOffset = 0;
                        if (descr.sheet.getOwnerNode() != null && (node = descr.sheet.getOwnerNode().getFirstChild()) instanceof IndexedRegion) {
                            startOffset = ((IndexedRegion)node).getStartOffset();
                        }
                        this.showRegion(file, (IRegion)new Region(startOffset + ((IndexedRegion)rule).getStartOffset(), ((IndexedRegion)rule).getLength()));
                        return;
                    }
                }
                ++r;
            }
            --i;
        }
        this.openFileFailed();
    }

    private IFile findFileForCSSStyleSheet(String filePath) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(filePath));
        return file != null ? file : PageContextFactory.getFileFromProject((String)filePath, (IFile)this.getFile());
    }

    protected boolean isRuleMatch(CSSRule cssRule, String styleName) {
        String selectorText = ((ICSSStyleRule)cssRule).getSelectorText();
        if (selectorText != null) {
            String[] styles;
            String[] stringArray = styles = selectorText.trim().split(",");
            int n = styles.length;
            int n2 = 0;
            while (n2 < n) {
                int searchIndex;
                String styleText = stringArray[n2];
                String[] styleWords = styleText.trim().split(" ");
                if (styleWords != null && (searchIndex = Arrays.binarySearch(styleWords, styleName, new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        Matcher matcher = Pattern.compile(CSSClassHyperlink.COMPARE_CLASS_REGEX_PREFIX + o2).matcher(o1);
                        return matcher.matches() ? 0 : 1;
                    }
                })) >= 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected Region getRegion(CSSRule cssRule) {
        int offset = ((IndexedRegion)cssRule).getStartOffset();
        ICSSStyleSheet document = (ICSSStyleSheet)((ICSSStyleRule)cssRule).getOwnerDocument();
        ICSSModel model = document.getModel();
        Node node = model.getOwnerDOMNode();
        if (node instanceof IDOMElement) {
            offset += ((IDOMElement)node).getStartEndOffset();
        }
        return new Region(offset, 0);
    }

    protected void showRegion(IFile file, IRegion region) {
        IWorkbenchPage workbenchPage = ExtensionsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart part = null;
        if (file != null) {
            try {
                part = IDE.openEditor((IWorkbenchPage)workbenchPage, (IFile)file, (boolean)true);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        if (part == null) {
            this.openFileFailed();
            return;
        }
        StructuredSelectionHelper.setSelectionAndReveal(part, (IRegion)region);
    }

    protected String getStyleName(IRegion region) {
        try {
            return this.getDocument().get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = this.getRegion(offset);
        return this.fLastRegion;
    }

    protected IRegion getRegion(int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(this.getDocument());
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start > offset) {
                return null;
            }
            String attrText = this.getDocument().get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = offset - start;
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '_' && sb.charAt(bStart) != '-' && sb.charAt(bStart) != '.') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            int bEnd = offset - start;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd)) && sb.charAt(bEnd) != '_' && sb.charAt(bEnd) != '-' && sb.charAt(bEnd) != '.') break;
                ++bEnd;
            }
            int propStart = bStart + start;
            int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            Region region = new Region(propStart, propLength);
            return region;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public String getHyperlinkText() {
        String styleName = this.getStyleName(this.fLastRegion);
        if (styleName == null) {
            return MessageFormat.format(Messages.OpenA, Messages.CSSStyle);
        }
        return MessageFormat.format(Messages.OpenCSSStyle, styleName);
    }

    protected String findAndReplaceElVariable(String fileName) {
        if (fileName != null) {
            fileName = fileName.replaceFirst(CONTEXT_PATH_EXPRESSION, "");
        }
        return super.findAndReplaceElVariable(fileName);
    }
}

