/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jst.web.webapp.model;

import java.util.Set;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.xml.XMLUtilities;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FWLoaderUtil
extends XModelObjectLoaderUtil {
    boolean schema = false;

    FWLoaderUtil() {
    }

    protected Set<String> getAllowedChildren(XModelEntity entity) {
        Set children = super.getAllowedChildren(entity);
        if ("WebAppResourceCollection".equals(entity.getName())) {
            children.add("url-pattern");
            children.add("http-method");
        } else if ("WebAppServiceRef".equals(entity.getName())) {
            children.add("port-component-ref");
            children.add("handler");
        } else if ("WebAppFilterMapping24".equals(entity.getName())) {
            children.add("dispatcher");
        } else if (entity.getName().startsWith("FileWebApp")) {
            children.add("distributable");
        }
        return children;
    }

    protected boolean isSaveable(XModelEntity entity, String n, String v, String dv) {
        if ("load-on-startup".equals(n)) {
            return false;
        }
        if (v == null) {
            return false;
        }
        if (v.length() == 0 || v.equals(dv)) {
            XAttribute attr = entity.getAttribute(n);
            return attr != null && "always".equals(attr.getProperty("save"));
        }
        return super.isSaveable(entity, n, v, dv);
    }

    public String getAttribute(Element element, String xmlname, XAttribute attr) {
        if ("distributable".equals(xmlname)) {
            return XMLUtil.getUniqueChild((Element)element, (String)"distributable") != null ? "yes" : "no";
        }
        if ("role-names".equals(xmlname)) {
            return this.loadArray(element, "role-name");
        }
        if ("url-patterns".equals(xmlname)) {
            return this.loadArray(element, "url-pattern");
        }
        if ("http-methods".equals(xmlname)) {
            return this.loadArray(element, "http-method");
        }
        if ("handlers".equals(xmlname)) {
            return this.loadArray(element, "handler");
        }
        if ("port-component-refs".equals(xmlname)) {
            return this.loadArray(element, "port-component-ref");
        }
        if ("dispatchers".equals(xmlname)) {
            return this.loadArray(element, "dispatcher");
        }
        return super.getAttribute(element, xmlname, attr);
    }

    public void saveAttributes(Element element, XModelObject o) {
        super.saveAttributes(element, o);
        String entity = o.getModelEntity().getName();
        if ("WebAppErrorPage".equals(entity)) {
            this.eitherOr(element, "error-code", "exception-type");
        } else if (WebAppHelper.FILTER_ENTITY.equals(entity) || entity.startsWith(WebAppHelper.FILTER_MAPPING_ENTITY)) {
            this.eitherOr(element, "url-pattern", "servlet-name");
        } else if (WebAppHelper.SERVLET_ENTITY.equals(entity)) {
            this.eitherOr(element, "servlet-class", "jsp-file");
        }
        if (this.schema) {
            Element e;
            if (o.getModelEntity().getAttribute("description") != null) {
                this.makeChildrenFirst(element, new String[]{"description", "display-name", "icon"});
            }
            if ("WebAppEnvEntry".equals(o.getModelEntity().getName()) && (e = XMLUtilities.getUniqueChild((Element)element, (String)"env-entry-value")) != null) {
                element.removeChild(e);
                element.appendChild(e);
            }
        }
    }

    public void saveAttribute(Element element, String xmlname, String value) {
        if ("distributable".equals(xmlname)) {
            if ("yes".equals(value)) {
                XMLUtil.createElement((Element)element, (String)"distributable");
            }
        } else if ("role-names".equals(xmlname)) {
            this.saveArray(element, "role-name", value);
        } else if ("url-patterns".equals(xmlname)) {
            this.saveArray(element, "url-pattern", value);
        } else if ("http-methods".equals(xmlname)) {
            this.saveArray(element, "http-method", value);
        } else if ("handlers".equals(xmlname)) {
            this.saveArray(element, "handler", value);
        } else if ("port-component-refs".equals(xmlname)) {
            this.saveArray(element, "port-component-ref", value);
        } else if ("dispatchers".equals(xmlname)) {
            this.saveArray(element, "dispatcher", value);
        } else {
            super.saveAttribute(element, xmlname, value);
        }
    }

    public boolean saveChildren(Element element, XModelObject o) {
        String entity = o.getModelEntity().getName();
        if (entity.startsWith("FileWebApp")) {
            return this.saveWebAppChildren(element, o);
        }
        if (WebAppHelper.FILTER_MAPPING_24_ENTITY.equals(entity)) {
            return true;
        }
        if (!"WebAppServlet".equals(entity)) {
            boolean b = super.saveChildren(element, o);
            if (o.getModelEntity().getAttribute("mapped-name") != null) {
                this.moveChild(element, "mapped-name", "injection-target");
            }
            return b;
        }
        this.saveChildren(element, o, "WebAppInitParam");
        String l = o.getAttributeValue("load-on-startup");
        if (l.length() > 0) {
            this.saveAttribute(element, "load-on-startup.#text", l);
        }
        this.saveChildren(element, o, "WebAppRunAs");
        this.saveChildren(element, o, "WebAppSecurityRoleRef");
        return true;
    }

    protected void saveChildren(Element element, XModelObject o, String entity) {
        XModelObject[] os = o.getChildren(entity);
        int i = 0;
        while (i < os.length) {
            this.save(element, os[i]);
            ++i;
        }
    }

    private boolean saveWebAppChildren(Element element, XModelObject o) {
        XModelObject[] os = o.getChildrenForSave();
        boolean b = true;
        int i = 0;
        while (i < os.length) {
            String xmlname = os[i].getModelEntity().getXMLSubPath();
            if (xmlname == null || xmlname.length() == 0) {
                if (!super.saveChildren(element, os[i])) {
                    b = false;
                }
            } else if (!this.save(element, os[i])) {
                b = false;
            }
            ++i;
        }
        return b;
    }

    public void loadChildren(Element element, XModelObject o) {
        String entity = o.getModelEntity().getName();
        if (entity.startsWith("FileWebApp")) {
            FWLoaderUtil.addRequiredChildren((XModelObject)o, (boolean)true);
            XModelObject[] os = o.getChildren();
            int i = 0;
            while (i < os.length) {
                String xmlname = os[i].getModelEntity().getXMLSubPath();
                if (xmlname == null || xmlname.length() == 0) {
                    super.loadChildren(element, os[i]);
                }
                ++i;
            }
            super.loadChildren(element, o);
        } else {
            super.loadChildren(element, o);
        }
    }

    private void makeChildrenFirst(Element element, String[] names) {
        Element[] es = new Element[names.length + 1];
        int[] indices = new int[names.length + 1];
        int k = 0;
        while (k < indices.length) {
            indices[k] = -1;
            ++k;
        }
        NodeList l = element.getChildNodes();
        int i = 0;
        while (i < l.getLength()) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                int index = this.getIndex(n.getNodeName(), names);
                if (index < 0) {
                    index = names.length;
                }
                if (es[index] == null) {
                    es[index] = (Element)n;
                    int k2 = index - 1;
                    while (k2 >= 0) {
                        if (es[k2] == null && (indices[k2] > index || indices[k2] < 0)) {
                            indices[k2] = index;
                        }
                        --k2;
                    }
                }
            }
            ++i;
        }
        i = names.length - 1;
        while (i >= 0) {
            if (es[i] != null && indices[i] >= 0) {
                element.removeChild(es[i]);
                element.insertBefore(es[i], es[indices[i]]);
                int k3 = i - 1;
                while (k3 >= 0) {
                    if (es[k3] != null && indices[k3] > indices[i]) {
                        indices[k3] = indices[i];
                    }
                    --k3;
                }
            }
            --i;
        }
    }

    private int getIndex(String name, String[] names) {
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void moveChild(Element element, String child, String childAfter) {
        NodeList l = element.getChildNodes();
        Element childE = null;
        Element childAfterE = null;
        int i = 0;
        while (i < l.getLength()) {
            Node n = l.item(i);
            if (n.getNodeType() == 1) {
                String name = n.getNodeName();
                if (child.equals(name)) {
                    childE = (Element)n;
                } else if (childAfter.equals(name) && childAfterE == null) {
                    childAfterE = (Element)n;
                }
            }
            ++i;
        }
        if (childE != null) {
            element.removeChild(childE);
            if (childAfterE != null) {
                element.insertBefore(childE, childAfterE);
            } else {
                element.appendChild(childE);
            }
        }
    }

    public boolean save(Element parent, XModelObject o) {
        if (!this.needToSave(o)) {
            return true;
        }
        return super.save(parent, o);
    }

    boolean needToSave(XModelObject o) {
        if (o == null) {
            return false;
        }
        String entity = o.getModelEntity().getName();
        if ("WebAppSessionConfig".equals(entity) || "WebAppLoginConfig".equals(entity)) {
            return this.hasSetAttributes(o);
        }
        if ("WebAppWelcomFileList".equals(entity) || "WebAppLocaleEncodingMappingList".equals(entity)) {
            return o.getChildren().length > 0;
        }
        if ("WebAppJspConfig".equals(entity)) {
            return o.getChildren().length > 0;
        }
        return true;
    }

    private boolean hasSetAttributes(XModelObject o) {
        XAttribute[] as = o.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            String v;
            String xml = as[i].getXMLName();
            if (xml != null && xml.length() != 0 && !"NAME".equals(xml) && (v = o.getAttributeValue(as[i].getName())) != null && v.length() > 0) {
                return true;
            }
            ++i;
        }
        String finalComment = o.get("#final-comment");
        return finalComment != null && finalComment.length() > 0;
    }
}

